/*
 * Decompiled with CFR 0.152.
 */
package nl.nikhef.slcshttps;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import nl.nikhef.slcshttps.CAHttps;
import nl.nikhef.slcshttps.gui.GraphTools;
import nl.nikhef.slcshttps.gui.PKCS12PopupComm;
import nl.nikhef.slcshttps.util.ConsoleTools;

public class PKCS12Https
extends CAHttps {
    private static final String COMMPROP = "nl.nikhef.slcshttps.comm";
    private String fileName = null;
    private char[] pkcs12Password = null;
    private KeyStore pkcs12Store = null;
    private static String commString = null;
    private static PKCS12Communicator comm = null;
    private static boolean showSuccess;

    public PKCS12Https() throws KeyStoreException {
        super(false);
        try {
            this.pkcs12Store = KeyStore.getInstance("PKCS12", "BC");
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyStoreException("Cannot use BouncyCastle provider");
        }
    }

    public void initialize() throws IOException {
        this.initialize(null, null);
    }

    public void initialize(String string) throws IOException {
        this.initialize(string, null);
    }

    public void initialize(String string, String string2) throws IOException {
        if (string == null || new File(string).isDirectory()) {
            try {
                this.fileName = comm.getFile(string);
            }
            catch (IOException iOException) {
                comm.error(string, iOException);
            }
            if (this.fileName == null) {
                try {
                    this.pkcs12Store.load(null, null);
                    return;
                }
                catch (Exception exception) {
                    comm.error(this.fileName, exception);
                }
            }
        } else {
            this.fileName = string;
        }
        this.pkcs12Password = string2 == null ? comm.getPassword("Enter PKCS12 password: ") : string2.toCharArray();
        try {
            this.pkcs12Store.load(new FileInputStream(this.fileName), this.pkcs12Password);
        }
        catch (Exception exception) {
            comm.error(this.fileName, exception);
        }
    }

    public void storeCertificate() throws IOException, CertificateException, KeyStoreException, KeyManagementException {
        this.storeCertificate(this.pkcs12Password, false);
    }

    public void storeCertificate(boolean bl) throws IOException, CertificateException, KeyStoreException, KeyManagementException {
        this.storeCertificate(this.pkcs12Password, bl);
    }

    public void storeCertificate(String string) throws IOException, CertificateException, KeyStoreException, KeyManagementException {
        this.storeCertificate(string.toCharArray(), false);
    }

    public void storeCertificate(String string, boolean bl) throws IOException, CertificateException, KeyStoreException, KeyManagementException {
        this.storeCertificate(string.toCharArray(), bl);
    }

    public void storeCertificate(char[] cArray, boolean bl) throws IOException, CertificateException, KeyStoreException, KeyManagementException {
        X509Certificate x509Certificate = this.cryptoStore.importPKCS12(this.pkcs12Store, cArray);
        comm.success(this.fileName, x509Certificate.getSubjectX500Principal().toString());
        if (bl) {
            try {
                this.setSSLSocketFactory();
            }
            catch (Exception exception) {
                throw new KeyManagementException("Cannot set the SSLSocketFactory: " + exception.getMessage());
            }
        }
    }

    public static String setCommunicator(String string) {
        commString = !GraphTools.isGraphic() ? "stdio" : (string == null ? "stdio" : string.toLowerCase());
        if ("popup".equals(commString)) {
            comm = new PKCS12PopupComm();
            return commString;
        }
        if ("stdio".equals(commString)) {
            comm = new StdioComm();
            return commString;
        }
        comm = new StdioComm();
        return commString;
    }

    public static String getCommunicator() {
        return commString;
    }

    public static void setShowSuccess(boolean bl) {
        showSuccess = bl;
    }

    public static boolean getShowSuccess() {
        return showSuccess;
    }

    static {
        String string = System.getProperty(COMMPROP);
        PKCS12Https.setCommunicator(string);
        showSuccess = CAHttps.showSuccess;
    }

    static class StdioComm
    implements PKCS12Communicator {
        StdioComm() {
        }

        public char[] getPassword(String string) throws IOException {
            return ConsoleTools.getPassword(string);
        }

        public String getFile(String string) throws IOException {
            File file;
            if (string == null) {
                file = new File(".");
                string = file.getCanonicalPath() + File.separatorChar;
            }
            System.out.println("Give PKCS12 filename (with respect to " + string + ")");
            String string2 = ConsoleTools.readLine();
            if (string2 == null || string2.length() == 0) {
                return null;
            }
            String string3 = string2.charAt(0) == '/' ? string2 : string + string2;
            file = new File(string3);
            if (file.canRead()) {
                return string3;
            }
            throw new IOException("File " + string3 + " is unreadable");
        }

        public void error(String string, Exception exception) throws IOException {
            System.err.println("Error: Cannot import PKCS12 file");
            if (string != null) {
                System.err.println("\n " + string);
            }
            throw new IOException("Cannot import PKCS12: " + exception.getMessage());
        }

        public void success(String string, String string2) {
            if (PKCS12Https.getShowSuccess()) {
                System.out.println("Successfully imported PKCS12 file: " + string + "\nSubject:\n " + string2);
            }
        }
    }

    public static interface PKCS12Communicator {
        public char[] getPassword(String var1) throws IOException;

        public String getFile(String var1) throws IOException;

        public void error(String var1, Exception var2) throws IOException;

        public void success(String var1, String var2);
    }
}

