/*
 * Decompiled with CFR 0.152.
 */
package nl.nikhef.slcshttps;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import nl.nikhef.slcshttps.CAHttps;
import nl.nikhef.slcshttps.PKCS12Https;
import nl.nikhef.slcshttps.SURFCAHttps;
import nl.nikhef.slcshttps.gui.CATool;
import nl.nikhef.slcshttps.gui.SURFCAInitDialog;
import nl.nikhef.slcshttps.trust.HttxURLConnection;

public class TestSURFCA {
    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage: TestSURFCA <URL>");
            System.err.println("  use as URL e.g.: \"https://www.nikhef.nl/~msalle/cert/showcert.php?nohtml=1\"");
            System.exit(1);
        }
        String string = stringArray[0];
        System.out.println("Starting...");
        PKCS12Https pKCS12Https = null;
        try {
            pKCS12Https = new PKCS12Https();
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception.getMessage());
            System.exit(1);
        }
        SURFCAHttps sURFCAHttps = null;
        try {
            sURFCAHttps = new SURFCAHttps();
        }
        catch (Exception exception) {
            System.err.println("Exception:\n" + exception.getMessage());
            System.exit(1);
        }
        try {
            pKCS12Https.initialize();
            pKCS12Https.storeCertificate(true);
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception.getMessage());
            System.exit(1);
        }
        try {
            CATool.showCATool(pKCS12Https);
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception.getMessage());
            System.exit(1);
        }
        try {
            System.out.println("authenticate...");
            sURFCAHttps.initialize();
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception.getMessage());
            System.exit(1);
        }
        try {
            System.out.println("get certificate...");
            sURFCAHttps.storeCertificate();
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception.getMessage());
            System.exit(1);
        }
        try {
            CATool.showCATool(sURFCAHttps);
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception.getMessage());
            System.exit(1);
        }
        CAHttps cAHttps = SURFCAInitDialog.getDialog(pKCS12Https);
        if (cAHttps instanceof SURFCAHttps) {
            sURFCAHttps = (SURFCAHttps)cAHttps;
        } else {
            System.err.println("Returned object cannot be cast into SURFCAHttps");
            System.exit(1);
        }
        try {
            CATool.showCATool(sURFCAHttps);
        }
        catch (Exception exception) {
            System.err.println("Exception: " + exception.getMessage());
            System.exit(1);
        }
        try {
            System.out.println("about to dump connection to: " + string + " ...");
            TestSURFCA.dumpConnection(string);
        }
        catch (IOException iOException) {
            System.err.println("Exception: " + iOException.getMessage());
            System.exit(1);
        }
    }

    private static void dumpConnection(String string) throws IOException, MalformedURLException {
        Object object;
        Object object2;
        URL uRL = null;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Malformed URL: " + string);
            throw malformedURLException;
        }
        HttxURLConnection httxURLConnection = null;
        try {
            System.out.println("Opening connection...");
            httxURLConnection = HttxURLConnection.openConnection(uRL);
            System.out.println("Connecting connection: ");
            httxURLConnection.connect();
        }
        catch (IOException iOException) {
            System.err.println("IOException: Cannot open connection to " + string + "\n " + iOException.getMessage());
            throw iOException;
        }
        catch (ClassCastException classCastException) {
            System.err.println("Cannot open " + string + " as https:\n " + classCastException.getMessage());
            throw new MalformedURLException("Cannot open " + string + " as https");
        }
        catch (Exception exception) {
            System.err.println("Cannot open connection to dump:\n " + exception.getMessage());
            throw new IOException("Cannot open connection to dump");
        }
        try {
            object2 = (X509Certificate[])httxURLConnection.getServerCertificates();
            object = new X509Certificate[((X509Certificate[])object2).length - 1];
            for (int i = 0; i < ((X509Certificate[])object2).length; ++i) {
                X500Principal x500Principal = object2[i].getSubjectX500Principal();
                if (i < ((X509Certificate[])object2).length - 1) {
                    object[i] = object2[i];
                }
                System.out.println("Peer principal: " + x500Principal.getName());
            }
        }
        catch (Exception exception) {
            httxURLConnection.disconnect();
            System.err.println("Cannot get Peer principal or its name");
            throw new IOException("Cannot get Peer principal or its name");
        }
        object2 = null;
        try {
            System.out.println("Starting to read...");
            object2 = new BufferedReader(new InputStreamReader(httxURLConnection.getInputStream()));
            System.out.println("BEGIN OF SERVER REPLY");
            while ((object = ((BufferedReader)object2).readLine()) != null) {
                System.out.println((String)object);
            }
            System.out.println("END OF SERVER REPLY\n");
        }
        catch (IOException iOException) {
            System.err.println("Error reading: " + iOException.getMessage());
            throw iOException;
        }
        finally {
            if (object2 != null) {
                ((BufferedReader)object2).close();
                object2 = null;
            }
            httxURLConnection.disconnect();
        }
    }
}

