/*
 * Decompiled with CFR 0.152.
 */
package nl.nikhef.slcshttps.gui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import nl.nikhef.slcshttps.CAHttps;
import nl.nikhef.slcshttps.SURFCAHttps;

public class SURFCAInitDialog
extends JDialog
implements ActionListener {
    CAHttps surfCA = null;
    CAHttps oldSurfCA = null;
    JLabel subject1Name = null;
    JLabel subject7Name = null;
    JLabel subject8Name = null;
    JButton button1;
    JButton button2a;
    JButton button2b;
    JPanel buttonPanel;
    JPanel cardPanel;

    public SURFCAInitDialog(CAHttps cAHttps) {
        this.surfCA = this.oldSurfCA = cAHttps;
        this.setModal(true);
        this.setTitle("Certificate Dialog");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SURFCAInitDialog.this.dispose();
            }
        });
        this.cardPanel = this.getCards();
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        this.buttonPanel = this.getButtons();
        CardLayout cardLayout2 = (CardLayout)this.buttonPanel.getLayout();
        cardLayout2.show(this.buttonPanel, "DOUBLE");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(this.cardPanel);
        jPanel.add(this.buttonPanel);
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(12, 12, 12, 12)));
        this.setContentPane(jPanel);
        this.pack();
        this.setLocationRelativeTo(null);
        boolean bl = false;
        String string = null;
        if (cAHttps != null) {
            try {
                X509Certificate x509Certificate = cAHttps.getCertificate();
                if (x509Certificate != null && x509Certificate.getNotAfter().getTime() >= new Date().getTime()) {
                    bl = true;
                    string = "<html>CA object is already initialized with a certificate with subject:<P>&nbsp;<P><I>" + x509Certificate.getSubjectX500Principal().toString() + "</I></html>";
                }
            }
            catch (KeyStoreException keyStoreException) {
                bl = true;
                string = "<html>CA object is already initialized<P>&nbsp;<P><I>Failed to get its certificate</I></html>";
            }
        }
        if (bl) {
            this.subject1Name.setText(string);
            cardLayout.show(this.cardPanel, "INITCONFIRM");
            this.button2a.setActionCommand("init");
            this.button2a.setText("REINIT");
            this.button2b.setActionCommand("cancel");
            this.button2b.setText("CANCEL");
            this.getRootPane().setDefaultButton(this.button2a);
        } else {
            try {
                this.surfCA = new SURFCAHttps(new EmptyCommunicator());
                cardLayout.show(this.cardPanel, "STARTBROWS");
                this.button2a.setActionCommand("browse");
                this.button2a.setText("START BROWSER");
                this.button2b.setActionCommand("cancel");
                this.button2b.setText("CANCEL");
                this.getRootPane().setDefaultButton(this.button2a);
            }
            catch (Exception exception) {
                cardLayout.show(this.cardPanel, "INITFAIL");
                this.button2a.setActionCommand("init");
                this.button2a.setText("RETRY");
                this.button2b.setActionCommand("cancel");
                this.button2b.setText("CANCEL");
                this.getRootPane().setDefaultButton(this.button2a);
            }
        }
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        CardLayout cardLayout = (CardLayout)this.cardPanel.getLayout();
        CardLayout cardLayout2 = (CardLayout)this.buttonPanel.getLayout();
        if ("init".equals(string)) {
            try {
                this.surfCA = new SURFCAHttps(new EmptyCommunicator());
                cardLayout.show(this.cardPanel, "STARTBROWS");
                this.button2a.setActionCommand("browse");
                this.button2a.setText("START BROWSER");
                this.button2b.setActionCommand("cancel");
                this.button2b.setText("CANCEL");
                this.getRootPane().setDefaultButton(this.button2a);
            }
            catch (Exception exception) {
                cardLayout.show(this.cardPanel, "INITFAIL");
                this.button2a.setActionCommand("init");
                this.button2a.setText("RETRY");
                this.button2b.setActionCommand("cancel");
                this.button2b.setText("CANCEL");
                this.getRootPane().setDefaultButton(this.button2a);
            }
        } else if ("browse".equals(string)) {
            try {
                ((SURFCAHttps)this.surfCA).initialize();
                cardLayout.show(this.cardPanel, "BROWSCOMPLETE");
                this.button2a.setActionCommand("cert");
                this.button2a.setText("DOWNLOAD CERTIFICATE");
                this.button2b.setActionCommand("cancel");
                this.button2b.setText("CANCEL");
                this.getRootPane().setDefaultButton(this.button2a);
            }
            catch (Exception exception) {
                cardLayout.show(this.cardPanel, "BROWSFAIL");
                this.button2a.setActionCommand("browse");
                this.button2a.setText("RETRY");
                this.button2b.setActionCommand("cancel");
                this.button2b.setText("CANCEL");
                this.getRootPane().setDefaultButton(this.button2a);
            }
        } else if ("cert".equals(string) || "https".equals(string)) {
            if ("cert".equals(string)) {
                try {
                    ((SURFCAHttps)this.surfCA).storeCertificate();
                }
                catch (Exception exception) {
                    cardLayout.show(this.cardPanel, "CERTFAIL");
                    this.button2a.setActionCommand("cert");
                    this.button2a.setText("RETRY");
                    this.button2b.setActionCommand("cancel");
                    this.button2b.setText("CANCEL");
                    this.getRootPane().setDefaultButton(this.button2a);
                    return;
                }
            }
            try {
                this.surfCA.setSSLSocketFactory();
                cardLayout.show(this.cardPanel, "CLOSE");
                cardLayout2.show(this.buttonPanel, "SINGLE");
                this.button1.setActionCommand("close");
                this.button1.setText("OK");
                this.getRootPane().setDefaultButton(this.button1);
            }
            catch (Exception exception) {
                cardLayout.show(this.cardPanel, "HTTPSFAIL");
                this.button2a.setActionCommand("https");
                this.button2a.setText("RETRY");
                this.button2b.setActionCommand("cancel");
                this.button2b.setText("CANCEL");
                this.getRootPane().setDefaultButton(this.button2a);
            }
        } else if ("cancel".equals(string)) {
            this.surfCA = this.oldSurfCA;
            this.dispose();
        } else if ("close".equals(string)) {
            this.dispose();
        }
    }

    private JPanel getCards() {
        JPanel jPanel = new JPanel(new CardLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        this.subject1Name = new JLabel("<html>CA object is already initialized<P>&nbsp;<P><I>&nbsp;</I></html>");
        jPanel2.add(this.subject1Name);
        jPanel2.add(new JLabel("<html><P>&nbsp;<P>Please press REINIT to reinitialize or CANCEL to cancel.</html>"));
        jPanel.add((Component)jPanel2, "INITCONFIRM");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BoxLayout(jPanel3, 1));
        jPanel3.add(new JLabel("<html>Initialization failed<P>&nbsp;<P>Check that following property is set and valid:<PRE>   nl.nikhef.slcshttps.AUTH_URL<BR>   <I>" + SURFCAHttps.AUTH_URL + "</I>" + "</html>"));
        jPanel.add((Component)jPanel3, "INITFAIL");
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 1));
        jPanel4.add(new JLabel("<html>A new webbrowser or browsertab is about to start.<P>&nbsp;<P>You will be asked to choose your Identity Provider and <I>log in</I>.<P>&nbsp;<P><I><FONT color=\"red\">After</FONT></I> you are done, please go <I>back</I> to this window.</html>"));
        jPanel.add((Component)jPanel4, "STARTBROWS");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BoxLayout(jPanel5, 1));
        jPanel5.add(new JLabel("<html>Browser failed to start<P>&nbsp;<P>Check also that the following property is set and valid:<PRE>   nl.nikhef.slcshttps.AUTH_URL<BR>   <I>" + SURFCAHttps.AUTH_URL + "</I></PRE>" + "</html>"));
        jPanel.add((Component)jPanel5, "BROWSFAIL");
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 1));
        jPanel6.add(new JLabel("<html>When <I><FONT color=\"red\">finished </FONT></I>in the webbrowser,<P>&nbsp;<P>press DOWNLOAD CERTIFICATE.<P>&nbsp;<P>This will download and install your Certificate</html>"));
        jPanel.add((Component)jPanel6, "BROWSCOMPLETE");
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BoxLayout(jPanel7, 1));
        jPanel7.add(new JLabel("<html>Certificate download <FONT color=\"red\">failed</FONT>.<P><P>Make sure you have <I>successfully logged in</I><BR>using your webbrowser.</html>"));
        jPanel.add((Component)jPanel7, "CERTFAIL");
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BoxLayout(jPanel8, 1));
        jPanel8.add(new JLabel("<html>Certificate downloaded succesfully<P>&nbps;"));
        this.subject7Name = new JLabel("");
        jPanel8.add(this.subject7Name);
        jPanel8.add(new JLabel("<P>&nbsp;<P>Setting HTTPS <FONT color=\"red\">failed</FONT>.</html>"));
        jPanel.add((Component)jPanel8, "HTTPSFAIL");
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout(new BoxLayout(jPanel9, 1));
        jPanel9.add(new JLabel("<html>Successfully installed certificate<P>&nbsp;"));
        this.subject8Name = new JLabel("");
        jPanel9.add(this.subject8Name);
        jPanel.add((Component)jPanel9, "CLOSE");
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEtchedBorder(), BorderFactory.createEmptyBorder(12, 12, 12, 12)));
        return jPanel;
    }

    private JPanel getButtons() {
        this.button1 = new JButton("START");
        this.button1.addActionListener(this);
        this.button1.setActionCommand("init");
        this.button2a = new JButton("REINIT");
        this.button2a.addActionListener(this);
        this.button2a.setActionCommand("reinit");
        this.button2b = new JButton("CANCEL");
        this.button2b.addActionListener(this);
        this.button2b.setActionCommand("cancel");
        JPanel jPanel = new JPanel();
        jPanel.add(this.button1);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 2));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.button2a);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(this.button2b);
        jPanel2.add(Box.createHorizontalGlue());
        JPanel jPanel3 = new JPanel(new CardLayout());
        jPanel3.add((Component)jPanel, "SINGLE");
        jPanel3.add((Component)jPanel2, "DOUBLE");
        return jPanel3;
    }

    public static CAHttps getDialog(CAHttps cAHttps) {
        try {
            SURFCAInitDialog sURFCAInitDialog = new SURFCAInitDialog(cAHttps);
            return sURFCAInitDialog.getSURFCAHttps();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private CAHttps getSURFCAHttps() {
        return this.surfCA;
    }

    private class EmptyCommunicator
    implements SURFCAHttps.SURFCACommunicator {
        private EmptyCommunicator() {
        }

        public void preBrowse() throws IOException {
        }

        public void postBrowse() throws IOException {
        }

        public void error(String string, Exception exception) {
        }

        public boolean retry(String string, Exception exception) {
            return false;
        }

        public void success(String string) {
            String string2 = null;
            try {
                X509Certificate x509Certificate = SURFCAInitDialog.this.surfCA.getCertificate();
                string2 = x509Certificate == null ? "<html><I>Certificate is empty</I></html>" : "<html>Subject information:<P><I>" + x509Certificate.getSubjectX500Principal().toString() + "</I></html>";
            }
            catch (KeyStoreException keyStoreException) {
                string2 = "<html><I>Failed to get certificate</I></html>";
            }
            SURFCAInitDialog.this.subject7Name.setText(string2);
            SURFCAInitDialog.this.subject8Name.setText(string2);
        }
    }
}

