/*
 * Decompiled with CFR 0.152.
 */
package nl.nikhef.slcshttps.trust;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class HostnameChecker {
    private static final int INADDR4SZ = 4;
    private static final int INADDR16SZ = 16;
    private static final int INT16SZ = 2;
    public static final byte TYPE_TLS = 1;
    private static final HostnameChecker INSTANCE_TLS = new HostnameChecker(1);
    public static final byte TYPE_LDAP = 2;
    private static final HostnameChecker INSTANCE_LDAP = new HostnameChecker(2);
    private static final int ALTNAME_DNS = 2;
    private static final int ALTNAME_IP = 7;
    private final byte checkType;

    private HostnameChecker(byte by) {
        this.checkType = by;
    }

    public static HostnameChecker getInstance(byte by) {
        if (by == 1) {
            return INSTANCE_TLS;
        }
        if (by == 2) {
            return INSTANCE_LDAP;
        }
        throw new IllegalArgumentException("Unknown check type: " + by);
    }

    public void match(String string, X509Certificate x509Certificate) throws CertificateException {
        if (HostnameChecker.isIpAddress(string)) {
            HostnameChecker.matchIP(string, x509Certificate);
        } else {
            this.matchDNS(string, x509Certificate);
        }
    }

    private static boolean isIpAddress(String string) {
        return HostnameChecker.isIPv4LiteralAddress(string) || HostnameChecker.isIPv6LiteralAddress(string);
    }

    private static void matchIP(String string, X509Certificate x509Certificate) throws CertificateException {
        Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
        if (collection == null) {
            throw new CertificateException("No subject alternative names present");
        }
        for (List<?> list : collection) {
            String string2;
            if ((Integer)list.get(0) != 7 || !string.equalsIgnoreCase(string2 = (String)list.get(1))) continue;
            return;
        }
        throw new CertificateException("No subject alternative names matching IP address " + string + " found");
    }

    private void matchDNS(String string, X509Certificate x509Certificate) throws CertificateException {
        this.matchDNS(string, x509Certificate, false);
    }

    private void matchDNS(String string, X509Certificate x509Certificate, boolean bl) throws CertificateException {
        String[] stringArray;
        Collection<List<?>> collection = x509Certificate.getSubjectAlternativeNames();
        if (collection != null) {
            boolean bl2 = false;
            for (List<?> list : collection) {
                if ((Integer)list.get(0) != 2) continue;
                bl2 = true;
                String string2 = (String)list.get(1);
                if (!this.isMatched(string, string2)) continue;
                return;
            }
            if (bl2) {
                throw new CertificateException("No subject alternative DNS name matching " + string + " found.");
            }
        }
        if ((stringArray = HostnameChecker.getCNs(x509Certificate)) != null) {
            int n = bl ? stringArray.length : 1;
            for (int i = 0; i < n; ++i) {
                if (!this.isMatched(string, stringArray[i])) continue;
                return;
            }
        }
        String string3 = "No name matching " + string + " found";
        throw new CertificateException(string3);
    }

    private static String[] getCNs(X509Certificate x509Certificate) {
        String[] stringArray;
        Vector<String> vector = new Vector<String>();
        String string = x509Certificate.getSubjectX500Principal().toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            int n = stringArray.indexOf("CN=");
            if (n < 0) continue;
            vector.add(stringArray.substring(n + 3));
        }
        if (!vector.isEmpty()) {
            stringArray = new String[vector.size()];
            vector.toArray(stringArray);
            return stringArray;
        }
        return null;
    }

    private boolean isMatched(String string, String string2) {
        if (this.checkType == 1) {
            return HostnameChecker.matchAllWildcards(string, string2);
        }
        if (this.checkType == 2) {
            return HostnameChecker.matchLeftmostWildcard(string, string2);
        }
        return false;
    }

    private static boolean matchAllWildcards(String string, String string2) {
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ".");
        if (stringTokenizer.countTokens() != stringTokenizer2.countTokens()) {
            return false;
        }
        while (stringTokenizer.hasMoreTokens()) {
            if (HostnameChecker.matchWildCards(stringTokenizer.nextToken(), stringTokenizer2.nextToken())) continue;
            return false;
        }
        return true;
    }

    private static boolean matchLeftmostWildcard(String string, String string2) {
        string = string.toLowerCase();
        string2 = string2.toLowerCase();
        int n = string2.indexOf(".");
        int n2 = string.indexOf(".");
        if (n == -1) {
            n = string2.length();
        }
        if (n2 == -1) {
            n2 = string.length();
        }
        if (HostnameChecker.matchWildCards(string.substring(0, n2), string2.substring(0, n))) {
            return string2.substring(n).equals(string.substring(n2));
        }
        return false;
    }

    private static boolean matchWildCards(String string, String string2) {
        int n = string2.indexOf("*");
        if (n == -1) {
            return string.equals(string2);
        }
        boolean bl = true;
        String string3 = "";
        String string4 = string2;
        while (n != -1) {
            string3 = string4.substring(0, n);
            string4 = string4.substring(n + 1);
            int n2 = string.indexOf(string3);
            if (n2 == -1 || bl && n2 != 0) {
                return false;
            }
            bl = false;
            string = string.substring(n2 + string3.length());
            n = string4.indexOf("*");
        }
        return string.endsWith(string4);
    }

    private static byte[] textToNumericFormatV4(String string) {
        if (string.length() == 0) {
            return null;
        }
        byte[] byArray = new byte[4];
        String[] stringArray = string.split("\\.", -1);
        try {
            switch (stringArray.length) {
                case 1: {
                    long l = Long.parseLong(stringArray[0]);
                    if (l < 0L || l > 0xFFFFFFFFL) {
                        return null;
                    }
                    byArray[0] = (byte)(l >> 24 & 0xFFL);
                    byArray[1] = (byte)((l & 0xFFFFFFL) >> 16 & 0xFFL);
                    byArray[2] = (byte)((l & 0xFFFFL) >> 8 & 0xFFL);
                    byArray[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 2: {
                    long l = Integer.parseInt(stringArray[0]);
                    if (l < 0L || l > 255L) {
                        return null;
                    }
                    byArray[0] = (byte)(l & 0xFFL);
                    l = Integer.parseInt(stringArray[1]);
                    if (l < 0L || l > 0xFFFFFFL) {
                        return null;
                    }
                    byArray[1] = (byte)(l >> 16 & 0xFFL);
                    byArray[2] = (byte)((l & 0xFFFFL) >> 8 & 0xFFL);
                    byArray[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 3: {
                    long l;
                    for (int i = 0; i < 2; ++i) {
                        l = Integer.parseInt(stringArray[i]);
                        if (l < 0L || l > 255L) {
                            return null;
                        }
                        byArray[i] = (byte)(l & 0xFFL);
                    }
                    l = Integer.parseInt(stringArray[2]);
                    if (l < 0L || l > 65535L) {
                        return null;
                    }
                    byArray[2] = (byte)(l >> 8 & 0xFFL);
                    byArray[3] = (byte)(l & 0xFFL);
                    break;
                }
                case 4: {
                    for (int i = 0; i < 4; ++i) {
                        long l = Integer.parseInt(stringArray[i]);
                        if (l < 0L || l > 255L) {
                            return null;
                        }
                        byArray[i] = (byte)(l & 0xFFL);
                    }
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return byArray;
    }

    private static byte[] textToNumericFormatV6(String string) {
        int n;
        if (string.length() < 2) {
            return null;
        }
        char[] cArray = string.toCharArray();
        byte[] byArray = new byte[16];
        int n2 = cArray.length;
        int n3 = string.indexOf("%");
        if (n3 == n2 - 1) {
            return null;
        }
        if (n3 != -1) {
            n2 = n3;
        }
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        if (cArray[n5] == ':' && cArray[++n5] != ':') {
            return null;
        }
        int n7 = n5;
        boolean bl = false;
        int n8 = 0;
        while (n5 < n2) {
            char c;
            if ((n = Character.digit(c = cArray[n5++], 16)) != -1) {
                n8 <<= 4;
                if ((n8 |= n) > 65535) {
                    return null;
                }
                bl = true;
                continue;
            }
            if (c == ':') {
                n7 = n5;
                if (!bl) {
                    if (n4 != -1) {
                        return null;
                    }
                    n4 = n6;
                    continue;
                }
                if (n5 == n2) {
                    return null;
                }
                if (n6 + 2 > 16) {
                    return null;
                }
                byArray[n6++] = (byte)(n8 >> 8 & 0xFF);
                byArray[n6++] = (byte)(n8 & 0xFF);
                bl = false;
                n8 = 0;
                continue;
            }
            if (c == '.' && n6 + 4 <= 16) {
                String string2 = string.substring(n7, n2);
                int n9 = 0;
                int n10 = 0;
                while ((n10 = string2.indexOf(46, n10)) != -1) {
                    ++n9;
                    ++n10;
                }
                if (n9 != 3) {
                    return null;
                }
                byte[] byArray2 = HostnameChecker.textToNumericFormatV4(string2);
                if (byArray2 == null) {
                    return null;
                }
                for (int i = 0; i < 4; ++i) {
                    byArray[n6++] = byArray2[i];
                }
                bl = false;
                break;
            }
            return null;
        }
        if (bl) {
            if (n6 + 2 > 16) {
                return null;
            }
            byArray[n6++] = (byte)(n8 >> 8 & 0xFF);
            byArray[n6++] = (byte)(n8 & 0xFF);
        }
        if (n4 != -1) {
            n = n6 - n4;
            if (n6 == 16) {
                return null;
            }
            for (n5 = 1; n5 <= n; ++n5) {
                byArray[16 - n5] = byArray[n4 + n - n5];
                byArray[n4 + n - n5] = 0;
            }
            n6 = 16;
        }
        if (n6 != 16) {
            return null;
        }
        byte[] byArray3 = HostnameChecker.convertFromIPv4MappedAddress(byArray);
        if (byArray3 != null) {
            return byArray3;
        }
        return byArray;
    }

    private static boolean isIPv4LiteralAddress(String string) {
        return HostnameChecker.textToNumericFormatV4(string) != null;
    }

    private static boolean isIPv6LiteralAddress(String string) {
        return HostnameChecker.textToNumericFormatV6(string) != null;
    }

    private static byte[] convertFromIPv4MappedAddress(byte[] byArray) {
        if (HostnameChecker.isIPv4MappedAddress(byArray)) {
            byte[] byArray2 = new byte[4];
            System.arraycopy(byArray, 12, byArray2, 0, 4);
            return byArray2;
        }
        return null;
    }

    private static boolean isIPv4MappedAddress(byte[] byArray) {
        if (byArray.length < 16) {
            return false;
        }
        return byArray[0] == 0 && byArray[1] == 0 && byArray[2] == 0 && byArray[3] == 0 && byArray[4] == 0 && byArray[5] == 0 && byArray[6] == 0 && byArray[7] == 0 && byArray[8] == 0 && byArray[9] == 0 && byArray[10] == -1 && byArray[11] == -1;
    }
}

