/*
 * Decompiled with CFR 0.152.
 */
package nl.nikhef.slcshttps.trust;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ContentHandlerFactory;
import java.net.FileNameMap;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.net.URL;
import java.security.Permission;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import nl.nikhef.slcshttps.gui.GraphTools;
import nl.nikhef.slcshttps.gui.HttxClientPopupComm;
import nl.nikhef.slcshttps.trust.TrustManagerImpl;
import nl.nikhef.slcshttps.util.ConsoleTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttxURLConnection
extends HttpsURLConnection {
    private HttpURLConnection httpImpl = null;
    private static SSLSocketFactory defaultSSLSocketFactory;
    private static boolean clientExpireWarn;
    private static long clientExpireWarnTime;
    private static final String EXPIREPROP = "nl.nikhef.slcshttps.httxclientwarn";
    private static final String EXPIRETIMEPROP = "nl.nikhef.slcshttps.httxclientwarntime";
    private static final String COMMPROP = "nl.nikhef.slcshttps.comm";
    private static Date clientExpireDate;
    private static boolean clientExpireWarnAcknowl;
    private static boolean clientExpireAcknowl;
    private static String commString;
    private static HttxClientCommunicator comm;
    private static HostnameVerifier hostVerifier;
    private URL url;
    private String hostName;
    private int portNumber;
    private boolean ssl;

    public HttxURLConnection(HttpURLConnection httpURLConnection) throws IOException {
        super(null);
        this.httpImpl = httpURLConnection;
        this.url = this.getURL();
        if ("https".equals(this.url.getProtocol())) {
            this.ssl = true;
            this.setSSLSocketFactory(defaultSSLSocketFactory);
            ((HttpsURLConnection)this.httpImpl).setHostnameVerifier(hostVerifier);
            this.hostName = this.url.getHost();
            this.portNumber = this.url.getPort();
            if (this.portNumber == -1) {
                this.portNumber = this.url.getDefaultPort();
            }
            TrustManagerImpl.setHostname(this.hostName);
            TrustManagerImpl.setPort(this.portNumber);
            if (!HttxURLConnection.checkClientExpire()) {
                throw new IOException("Client Certificate has expired");
            }
        } else {
            this.ssl = false;
        }
    }

    public HttxURLConnection(URL uRL) throws IOException {
        this((HttpURLConnection)uRL.openConnection());
    }

    public static HttxURLConnection openConnection(URL uRL) throws IOException {
        return new HttxURLConnection(uRL);
    }

    @Override
    public void connect() throws IOException {
        if (this.ssl) {
            TrustManagerImpl.setHostname(this.hostName);
            TrustManagerImpl.setPort(this.portNumber);
        }
        this.httpImpl.connect();
    }

    @Override
    public void disconnect() {
        this.httpImpl.disconnect();
        TrustManagerImpl.setHostname(null);
        TrustManagerImpl.setPort(1);
    }

    public static void setDefaultSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        defaultSSLSocketFactory = sSLSocketFactory;
    }

    public static SSLSocketFactory getDefaultSSLSocketFactory() {
        return defaultSSLSocketFactory;
    }

    @Override
    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
    }

    public static void setDefaultHostnameVerifier(HostnameVerifier hostnameVerifier) {
    }

    @Override
    public HostnameVerifier getHostnameVerifier() {
        return hostVerifier;
    }

    public static HostnameVerifier getDefaultHostnameVerifier() {
        return hostVerifier;
    }

    public static boolean checkClientExpire() {
        long l;
        if (!clientExpireWarn || clientExpireDate == null) {
            return true;
        }
        long l2 = new Date().getTime();
        if (l2 > (l = clientExpireDate.getTime())) {
            if (!clientExpireAcknowl) {
                clientExpireAcknowl = true;
                return comm.expired("Your certificate has <I>expired</I>, do you still want to continue?");
            }
        } else if (clientExpireWarnTime > 0L && l2 > l - clientExpireWarnTime && !clientExpireWarnAcknowl) {
            clientExpireWarnAcknowl = true;
            comm.almostexpired("Your certificate will <I>expire</I>: " + clientExpireDate.toString());
            return true;
        }
        return true;
    }

    public static void setClientExpireDate(Date date) {
        clientExpireDate = date;
        clientExpireWarnAcknowl = false;
        clientExpireAcknowl = false;
    }

    public static Date getClientExpireDate() {
        return clientExpireDate;
    }

    public static void setExpire(String string) {
        clientExpireWarn = string == null || !string.equals("false");
    }

    public static boolean getExpire() {
        return clientExpireWarn;
    }

    public static void setExpireWarnTime(String string) {
        if (string == null) {
            clientExpireWarnTime = 0L;
        } else {
            try {
                clientExpireWarnTime = Long.parseLong(string.trim()) * 1000L;
                if (clientExpireWarnTime < 0L) {
                    clientExpireWarnTime = 0L;
                }
            }
            catch (NumberFormatException numberFormatException) {
                clientExpireWarnTime = 0L;
            }
        }
    }

    public static long getExpireWarnTime() {
        return clientExpireWarnTime;
    }

    public static String setCommunicator(String string) {
        commString = !GraphTools.isGraphic() ? "stdio" : (string == null ? "stdio" : string.toLowerCase());
        if ("popup".equals(commString)) {
            comm = new HttxClientPopupComm();
            return commString;
        }
        if ("stdio".equals(commString)) {
            comm = new StdioComm();
            return commString;
        }
        comm = new StdioComm();
        return commString;
    }

    public static String getCommunicator() {
        return commString;
    }

    @Override
    public void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        ((HttpsURLConnection)this.httpImpl).setSSLSocketFactory(sSLSocketFactory);
    }

    @Override
    public Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        return ((HttpsURLConnection)this.httpImpl).getServerCertificates();
    }

    @Override
    public SSLSocketFactory getSSLSocketFactory() {
        return ((HttpsURLConnection)this.httpImpl).getSSLSocketFactory();
    }

    @Override
    public Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        return ((HttpsURLConnection)this.httpImpl).getPeerPrincipal();
    }

    @Override
    public Principal getLocalPrincipal() {
        return ((HttpsURLConnection)this.httpImpl).getLocalPrincipal();
    }

    @Override
    public Certificate[] getLocalCertificates() {
        return ((HttpsURLConnection)this.httpImpl).getLocalCertificates();
    }

    @Override
    public String getCipherSuite() {
        return ((HttpsURLConnection)this.httpImpl).getCipherSuite();
    }

    public static void setFileNameMap(FileNameMap fileNameMap) {
        HttpsURLConnection.setFileNameMap(fileNameMap);
    }

    public static synchronized FileNameMap getFileNameMap() {
        return HttpsURLConnection.getFileNameMap();
    }

    public static void setDefaultAllowUserInteraction(boolean bl) {
        HttpsURLConnection.setDefaultAllowUserInteraction(bl);
    }

    public static boolean getDefaultAllowUserInteraction() {
        return HttpsURLConnection.getDefaultAllowUserInteraction();
    }

    public static void setFollowRedirects(boolean bl) {
        HttpsURLConnection.setFollowRedirects(bl);
    }

    public static boolean getFollowRedirects() {
        return HttpsURLConnection.getFollowRedirects();
    }

    public static synchronized void setContentHandlerFactory(ContentHandlerFactory contentHandlerFactory) {
        HttpsURLConnection.setContentHandlerFactory(contentHandlerFactory);
    }

    public static String guessContentTypeFromStream(InputStream inputStream) throws IOException {
        return HttpsURLConnection.guessContentTypeFromStream(inputStream);
    }

    public static String guessContentTypeFromName(String string) {
        return HttpsURLConnection.guessContentTypeFromName(string);
    }

    public int hashCode() {
        return this.httpImpl.hashCode();
    }

    public boolean equals(Object object) {
        return this.httpImpl.equals(object);
    }

    @Override
    public String toString() {
        return this.httpImpl.toString();
    }

    @Override
    public void setUseCaches(boolean bl) {
        this.httpImpl.setUseCaches(bl);
    }

    @Override
    public void setRequestProperty(String string, String string2) {
        this.httpImpl.setRequestProperty(string, string2);
    }

    @Override
    public void setReadTimeout(int n) {
        this.httpImpl.setReadTimeout(n);
    }

    @Override
    public void setIfModifiedSince(long l) {
        this.httpImpl.setIfModifiedSince(l);
    }

    @Override
    public void setDoOutput(boolean bl) {
        this.httpImpl.setDoOutput(bl);
    }

    @Override
    public void setDoInput(boolean bl) {
        this.httpImpl.setDoInput(bl);
    }

    @Override
    public void setDefaultUseCaches(boolean bl) {
        this.httpImpl.setDefaultUseCaches(bl);
    }

    @Override
    public void setConnectTimeout(int n) {
        this.httpImpl.setConnectTimeout(n);
    }

    @Override
    public void setAllowUserInteraction(boolean bl) {
        this.httpImpl.setAllowUserInteraction(bl);
    }

    @Override
    public boolean getUseCaches() {
        return this.httpImpl.getUseCaches();
    }

    @Override
    public URL getURL() {
        return this.httpImpl.getURL();
    }

    @Override
    public String getRequestProperty(String string) {
        return this.httpImpl.getRequestProperty(string);
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        return this.httpImpl.getRequestProperties();
    }

    @Override
    public int getReadTimeout() {
        return this.httpImpl.getReadTimeout();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.httpImpl.getOutputStream();
    }

    @Override
    public long getLastModified() {
        return this.httpImpl.getLastModified();
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.httpImpl.getInputStream();
    }

    @Override
    public long getIfModifiedSince() {
        return this.httpImpl.getIfModifiedSince();
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.httpImpl.getHeaderFields();
    }

    @Override
    public int getHeaderFieldInt(String string, int n) {
        return this.httpImpl.getHeaderFieldInt(string, n);
    }

    @Override
    public String getHeaderField(String string) {
        return this.httpImpl.getHeaderField(string);
    }

    @Override
    public long getExpiration() {
        return this.httpImpl.getExpiration();
    }

    @Override
    public boolean getDoOutput() {
        return this.httpImpl.getDoOutput();
    }

    @Override
    public boolean getDoInput() {
        return this.httpImpl.getDoInput();
    }

    @Override
    public boolean getDefaultUseCaches() {
        return this.httpImpl.getDefaultUseCaches();
    }

    @Override
    public long getDate() {
        return this.httpImpl.getDate();
    }

    @Override
    public String getContentType() {
        return this.httpImpl.getContentType();
    }

    @Override
    public int getContentLength() {
        return this.httpImpl.getContentLength();
    }

    @Override
    public String getContentEncoding() {
        return this.httpImpl.getContentEncoding();
    }

    public Object getContent(Class[] classArray) throws IOException {
        return this.httpImpl.getContent(classArray);
    }

    @Override
    public Object getContent() throws IOException {
        return this.httpImpl.getContent();
    }

    @Override
    public int getConnectTimeout() {
        return this.httpImpl.getConnectTimeout();
    }

    @Override
    public boolean getAllowUserInteraction() {
        return this.httpImpl.getAllowUserInteraction();
    }

    @Override
    public void addRequestProperty(String string, String string2) {
        this.httpImpl.addRequestProperty(string, string2);
    }

    @Override
    public boolean usingProxy() {
        return this.httpImpl.usingProxy();
    }

    @Override
    public void setRequestMethod(String string) throws ProtocolException {
        this.httpImpl.setRequestMethod(string);
    }

    @Override
    public void setInstanceFollowRedirects(boolean bl) {
        this.httpImpl.setInstanceFollowRedirects(bl);
    }

    @Override
    public void setFixedLengthStreamingMode(int n) {
        this.httpImpl.setFixedLengthStreamingMode(n);
    }

    @Override
    public void setChunkedStreamingMode(int n) {
        this.httpImpl.setChunkedStreamingMode(n);
    }

    @Override
    public String getResponseMessage() throws IOException {
        return this.httpImpl.getResponseMessage();
    }

    @Override
    public int getResponseCode() throws IOException {
        return this.httpImpl.getResponseCode();
    }

    @Override
    public String getRequestMethod() {
        return this.httpImpl.getRequestMethod();
    }

    @Override
    public Permission getPermission() throws IOException {
        return this.httpImpl.getPermission();
    }

    @Override
    public boolean getInstanceFollowRedirects() {
        return this.httpImpl.getInstanceFollowRedirects();
    }

    @Override
    public String getHeaderFieldKey(int n) {
        return this.httpImpl.getHeaderFieldKey(n);
    }

    @Override
    public long getHeaderFieldDate(String string, long l) {
        return this.httpImpl.getHeaderFieldDate(string, l);
    }

    @Override
    public String getHeaderField(int n) {
        return this.httpImpl.getHeaderField(n);
    }

    @Override
    public InputStream getErrorStream() {
        return this.httpImpl.getErrorStream();
    }

    static {
        clientExpireDate = null;
        commString = null;
        comm = null;
        String string = System.getProperty(COMMPROP);
        HttxURLConnection.setCommunicator(string);
        Object object = System.getProperty(EXPIREPROP);
        HttxURLConnection.setExpire((String)object);
        String string2 = System.getProperty(EXPIRETIMEPROP);
        HttxURLConnection.setExpireWarnTime(string2);
        string = null;
        try {
            object = SSLContext.getInstance("TLS");
            ((SSLContext)object).init(null, new TrustManager[]{new TrustManagerImpl()}, null);
            defaultSSLSocketFactory = ((SSLContext)object).getSocketFactory();
        }
        catch (Exception exception) {
            throw new RuntimeException("Cannot get a SocketFactory for given managers", exception);
        }
        hostVerifier = new HostnameVerifier(){

            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
    }

    static class StdioComm
    implements HttxClientCommunicator {
        StdioComm() {
        }

        public boolean expired(String string) {
            String string2 = "WARNING:\n " + string.replaceAll("</*I>", " ");
            try {
                return ConsoleTools.getConfirm(string2);
            }
            catch (IOException iOException) {
                System.err.println("Caught exception: " + iOException.getMessage());
                System.err.println("Not confirming validation");
                return false;
            }
        }

        public void almostexpired(String string) {
            String string2 = string.replaceAll("</*I>", " ");
            System.err.println("WARNING:\n " + string2);
        }
    }

    public static interface HttxClientCommunicator {
        public boolean expired(String var1);

        public void almostexpired(String var1);
    }
}

