/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.data;

import java.util.HashSet;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.data.KinTreeNode;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.entityindexer.IndexerParameters;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindata.EntityData;
import nl.mpi.kinnate.kindata.EntityRelation;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.svg.SymbolGraphic;

public class KinTreeFilteredNode
extends KinTreeNode {
    DataTypes.RelationType subnodeFilter;
    EntityRelation entityRelation;

    public KinTreeFilteredNode(SymbolGraphic symbolGraphic, EntityRelation entityRelation, DataStoreSvg dataStoreSvg, IndexerParameters indexerParameters, MessageDialogHandler dialogHandler, EntityCollection entityCollection, ArbilDataNodeLoader dataNodeLoader) {
        super(symbolGraphic, entityRelation.alterUniqueIdentifier, entityRelation.getAlterNode(), dataStoreSvg, indexerParameters, dialogHandler, entityCollection, dataNodeLoader);
        this.subnodeFilter = entityRelation.getRelationType();
        this.entityRelation = entityRelation;
    }

    protected void loadEntityIfNotLoaded() {
        if (this.entityData == null) {
            this.entityData = this.entityRelation.getAlterNode();
            if (this.entityData == null) {
                try {
                    this.entityData = this.entityCollection.getEntity(this.entityRelation.alterUniqueIdentifier, this.indexerParameters);
                }
                catch (EntityServiceException exception) {
                    this.entityData = new EntityData(this.entityRelation.alterUniqueIdentifier, new String[]{"Error loading the entity data", "view log for details"});
                }
                this.entityRelation.setAlterNode(this.entityData);
            }
        }
    }

    public ArbilNode[] getChildArray() {
        if (this.childNodes == null) {
            if (this.subnodeFilter != DataTypes.RelationType.ancestor && this.subnodeFilter != DataTypes.RelationType.descendant) {
                return new ArbilNode[0];
            }
            HashSet<ArbilNode> relationList = new HashSet<ArbilNode>();
            for (EntityRelation entityRelation : this.entityData.getAllRelations()) {
                if (this.subnodeFilter != entityRelation.getRelationType()) continue;
                relationList.add(new KinTreeFilteredNode(this.symbolGraphic, entityRelation, this.dataStoreSvg, this.indexerParameters, this.dialogHandler, this.entityCollection, this.dataNodeLoader));
            }
            this.getLinksMetaNode(relationList);
            this.childNodes = relationList.toArray(new ArbilNode[0]);
            new Thread(){

                public void run() {
                    for (ArbilNode childNode : KinTreeFilteredNode.this.childNodes) {
                        ((KinTreeFilteredNode)childNode).loadEntityIfNotLoaded();
                    }
                }
            }.start();
        }
        return this.childNodes;
    }
}

