/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.entityindexer;

import java.util.ArrayList;
import java.util.HashMap;

public class IndexerEntityData {
    private HashMap<String, ArrayList<String[]>> relationData = new HashMap();
    private ArrayList<String[]> entityFields = new ArrayList();
    private String uniqueIdentifier;

    public IndexerEntityData(String uniqueIdentifierLocal) {
        this.uniqueIdentifier = uniqueIdentifierLocal;
    }

    public String getUniqueIdentifier() {
        return this.uniqueIdentifier;
    }

    protected String getEntityField(String fieldName) {
        for (String[] currentField : this.entityFields) {
            if (!currentField[0].equals(fieldName)) continue;
            return currentField[1];
        }
        return null;
    }

    protected void addRelation(String linkPath) {
        this.addRelationData(linkPath, null, null);
    }

    protected void addRelationData(String linkPath, String dataPath, String dataValue) {
        ArrayList<Object> dataArray;
        if (!this.relationData.containsKey(linkPath)) {
            dataArray = new ArrayList();
            this.relationData.put(linkPath, dataArray);
        } else {
            dataArray = this.relationData.get(linkPath);
        }
        dataArray.add(new String[]{dataPath, dataValue});
    }

    protected void addEntityData(String dataPath, String dataValue) {
        this.entityFields.add(new String[]{dataPath, dataValue});
    }

    protected String[][] getEntityFields() {
        return (String[][])this.entityFields.toArray((T[])new String[0][]);
    }

    protected String[] getRelationPaths() {
        return this.relationData.keySet().toArray(new String[0]);
    }

    protected String[][] getRelationData(String realtionPath) {
        if (this.relationData.containsKey(realtionPath)) {
            return (String[][])this.relationData.get(realtionPath).toArray((T[])new String[0][]);
        }
        return null;
    }
}

