/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.entityindexer;

import nl.mpi.kinnate.entityindexer.IndexerParam;
import nl.mpi.kinnate.entityindexer.IndexerParameters;
import nl.mpi.kinnate.entityindexer.ParameterElement;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kintypestrings.KinTypeElement;
import nl.mpi.kinnate.kintypestrings.QueryTerm;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class QueryBuilder {
    public String asSequenceString(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String currentEntry : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            } else {
                stringBuilder.append("{");
            }
            stringBuilder.append("\"");
            stringBuilder.append(QueryBuilder.escapeBadChars(currentEntry));
            stringBuilder.append("\"");
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    public String asContainsString(String keyWords) {
        String[] stringArray = keyWords.split("\\s");
        StringBuilder stringBuilder = new StringBuilder();
        for (String currentEntry : stringArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" and ");
            } else {
                stringBuilder.append("[");
            }
            stringBuilder.append("//. contains text \"");
            stringBuilder.append(QueryBuilder.escapeBadChars(currentEntry));
            stringBuilder.append("\" using fuzzy using case insensitive");
        }
        stringBuilder.append("]");
        return stringBuilder.toString();
    }

    public String asSequenceString(IndexerParam indexerParam) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ParameterElement currentEntry : indexerParam.getValues()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(",");
            } else {
                stringBuilder.append("(");
            }
            stringBuilder.append("\"");
            stringBuilder.append(QueryBuilder.escapeBadChars(currentEntry.getXpathString()));
            stringBuilder.append("\"");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    static String escapeBadChars(String inputString) {
        return inputString.replace("&", "&amp;").replace("\"", "&quot;");
    }

    public String getLabelsClause(IndexerParameters indexParameters, String docRootVar) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ParameterElement currentEntry : indexParameters.labelFields.getValues()) {
            stringBuilder.append("for $labelNode in ");
            stringBuilder.append(docRootVar);
            stringBuilder.append(currentEntry.getXpathString());
            stringBuilder.append("\nreturn\ninsert node <kin:Label xmlns:kin=\"http://mpi.nl/tla/kin\">{$labelNode/text()}</kin:Label> after $copyNode/*:Identifier,\n");
        }
        return stringBuilder.toString();
    }

    public String getDatesClause(IndexerParameters indexParameters, String docRootVar) {
        StringBuilder stringBuilder = new StringBuilder();
        for (ParameterElement currentEntry : indexParameters.dateOfBirthField.getValues()) {
            stringBuilder.append("for $dateOfBirthNode in ");
            stringBuilder.append(docRootVar);
            stringBuilder.append(currentEntry.getXpathString());
            stringBuilder.append("\nreturn\ninsert node <kin:DateOfBirth xmlns:kin=\"http://mpi.nl/tla/kin\">{$dateOfBirthNode/text()}</kin:DateOfBirth> after $copyNode/*:Identifier,\n");
        }
        for (ParameterElement currentEntry : indexParameters.dateOfDeathField.getValues()) {
            stringBuilder.append("for $dateOfDeathNode in ");
            stringBuilder.append(docRootVar);
            stringBuilder.append(currentEntry.getXpathString());
            stringBuilder.append("\nreturn\ninsert node <kin:DateOfDeath xmlns:kin=\"http://mpi.nl/tla/kin\">{$dateOfDeathNode/text()}</kin:DateOfDeath> after $copyNode/*:Identifier,\n");
        }
        return stringBuilder.toString();
    }

    public String getSymbolClause(IndexerParameters indexParameters, String docRootVar) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean notFirst = false;
        for (ParameterElement currentEntry : indexParameters.symbolFieldsFields.getValues()) {
            if (notFirst) {
                stringBuilder.append(",\n");
            }
            notFirst = true;
            String trimmedXpath = currentEntry.getXpathString().replaceFirst("^\\*:Kinnate", "");
            stringBuilder.append("if (exists(");
            stringBuilder.append(docRootVar);
            stringBuilder.append(trimmedXpath);
            stringBuilder.append(")) then ");
            stringBuilder.append("insert node <kin:Symbol xmlns:kin=\"http://mpi.nl/tla/kin\">");
            stringBuilder.append(currentEntry.getSelectedValue());
            stringBuilder.append("</kin:Symbol> after $copyNode/*:Identifier ");
            stringBuilder.append("else ()");
        }
        return stringBuilder.toString();
    }

    public String getRelationQuery() {
        return "<Relations>{$entityNode/*:Relations\n}</Relations>";
    }

    public String getEntityQueryReturn(IndexerParameters indexParameters) {
        return "return copy $copyNode := $entityNode\nmodify (\n" + this.getLabelsClause(indexParameters, "root($entityNode)/") + this.getDatesClause(indexParameters, "root($entityNode)/") + this.getSymbolClause(indexParameters, "root($entityNode)/") + ")\n" + "return $copyNode\n";
    }

    public String getEntityByEndPointQuery(DataTypes.RelationType relationType, IndexerParameters indexParameters, String databaseName) {
        return "<Entities> { for $doc in collection('" + databaseName + "') where not (/*:Kinnate/*:Entity/*:Relations/*:Relation/@*:Type = \"" + relationType.name() + "\")\n" + "and not (/*:Kinnate/*:CustomData/*:Type/text() = \"Gedcom Family Group\")\n" + "return let $entityNode := $doc/*:Kinnate/*:Entity\n" + this.getEntityQueryReturn(indexParameters) + "}</Entities>";
    }

    public String getEntityByKeyWordQuery(String keyWords, IndexerParameters indexParameters, String databaseName) {
        return "<Entities> { for $KinnateNode in collection('" + databaseName + "')/*:Kinnate" + this.asContainsString(keyWords) + "\n" + "return let $entityNode := $KinnateNode/*:Entity\n" + this.getEntityQueryReturn(indexParameters) + "}</Entities>";
    }

    public String getEntityWithRelationsQuery(UniqueIdentifier uniqueIdentifier, String[] excludeUniqueIdentifiers, IndexerParameters indexParameters, String databaseName) {
        return "for $entityNode := collection('" + databaseName + "')/*:Kinnate/*:Entity[**/*:Identifier/text() = \"" + uniqueIdentifier.getQueryIdentifier() + "\"]\n" + this.getEntityQueryReturn(indexParameters);
    }

    public String getDeleteQuery(UniqueIdentifier uniqueIdentifier, String databaseName) {
        return "for $identifierNode in collection('" + databaseName + "')/*:Kinnate[*:Entity/*:Identifier/text() = \"" + uniqueIdentifier.getQueryIdentifier() + "\"]" + "return db:delete('" + databaseName + "', fn:substring-after(base-uri($identifierNode), '/'))";
    }

    public String getDatabaseStats(String databaseName) {
        return "concat(count(collection('" + databaseName + "')),':'," + "count(collection('" + databaseName + "')/*:Kinnate/*:Entity/*:Relations/*:Relation))";
    }

    public String getAllFieldNamesQuery(String databaseName) {
        return "for $facetEntry in index:facets('" + databaseName + "')/document-node/element/element[@name='CustomData']/element/@name\n" + "order by lower-case($facetEntry)\n return data($facetEntry)";
    }

    public String getEntityQuery(UniqueIdentifier uniqueIdentifier, IndexerParameters indexParameters, String databaseName) {
        return "for $entityNode in collection('" + databaseName + "')/*:Kinnate/*:Entity[*:Identifier/text() = \"" + uniqueIdentifier.getQueryIdentifier() + "\"]\n" + this.getEntityQueryReturn(indexParameters);
    }

    public String getTermQuery(KinTypeElement queryTerms, String databaseName) {
        StringBuilder stringBuilder = new StringBuilder();
        for (QueryTerm queryTerm : queryTerms.queryTerms) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" and ");
            }
            stringBuilder.append("$entityNode//*/");
            stringBuilder.append(queryTerm.fieldXPath);
            stringBuilder.append("[text() ");
            switch (queryTerm.comparatorType) {
                case Equals: {
                    stringBuilder.append("=");
                    break;
                }
                case Greater: {
                    stringBuilder.append(">");
                    break;
                }
                case Less: {
                    stringBuilder.append("<");
                    break;
                }
                default: {
                    stringBuilder.append("contains text");
                }
            }
            stringBuilder.append(" \"");
            stringBuilder.append(QueryBuilder.escapeBadChars(queryTerm.searchValue));
            stringBuilder.append("\"]");
        }
        return "<IdentifierArray xmlns=\"http://mpi.nl/tla/kin\">{for $entityNode in collection('" + databaseName + "')\n" + "where " + stringBuilder.toString() + "\n" + "return\n" + "$entityNode/*:Kinnate/*:Entity/*:Identifier\n" + "}</IdentifierArray>";
    }
}

