/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.export;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifiedFileSearch {
    private String searchString = "mdi.0";

    public void setSearchType(SearchType searchType) {
        switch (searchType) {
            case cmdi: {
                this.searchString = "cmdi.0";
                break;
            }
            case imdi: {
                this.searchString = "imdi.0";
                break;
            }
            case kmdi: {
                this.searchString = "kmdi.0";
                break;
            }
            case all: {
                this.searchString = "mdi.0";
            }
        }
    }

    public ArrayList<File> getModifiedFiles(File currentDirectory) {
        File[] currentListing;
        ArrayList<File> modifiedFileList = new ArrayList<File>();
        for (File currentFile : currentListing = currentDirectory.listFiles()) {
            if (currentFile.getName().endsWith(this.searchString)) {
                File targetFile = new File(currentFile.getParentFile(), currentFile.getName().replaceAll("mdi\\.0$", "mdi"));
                modifiedFileList.add(targetFile);
            }
            if (currentFile.isFile()) continue;
            modifiedFileList.addAll(this.getModifiedFiles(currentFile));
        }
        return modifiedFileList;
    }

    public void stripHistoryFiles(final File targetFile) {
        String[] historyFileArray = targetFile.getParentFile().list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.matches(targetFile.getName() + "\\.[0-9]+$");
            }
        });
        if (historyFileArray != null) {
            for (String currentHistory : historyFileArray) {
                System.out.println(currentHistory);
                if (!currentHistory.matches("[^\\^/]+mdi\\.[0-9]+$")) continue;
                new File(targetFile.getParentFile(), currentHistory).delete();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SearchType {
        imdi,
        cmdi,
        kmdi,
        all;

    }
}

