/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.gedcomimport;

import java.util.ArrayList;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.gedcomimport.ImportLineStructure;
import nl.mpi.kinnate.kindata.DataTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TipLineStructure
extends ImportLineStructure {
    public TipLineStructure(String lineString, ArrayList<String> gedcomLevelStrings) throws ImportException {
        super(lineString, gedcomLevelStrings);
        String[] lineParts;
        this.isFileHeader = lineString.startsWith("*");
        if (this.isFileHeader) {
            this.currentID = "head";
            this.gedcomLevel = 0;
            lineParts = lineString.substring(1).split(":", 2);
            if (lineParts.length > 1) {
                this.addFieldEntry(lineParts[0], lineParts[1]);
            } else {
                this.addFieldEntry("Comment", lineParts[0]);
            }
        } else {
            lineParts = lineString.split("\t");
            if (lineParts.length < 2) {
                this.incompleteLine = true;
                return;
            }
            this.currentID = lineParts[1];
            this.gedcomLevel = 0;
            if (lineParts[0].equals("1")) {
                if (lineParts.length != 4) {
                    throw new ImportException("Incorrect number of fields in line:\n" + lineString);
                }
                DataTypes.RelationType relationType = DataTypes.RelationType.other;
                if ("0".equals(lineParts[3])) {
                    relationType = DataTypes.RelationType.ancestor;
                } else if ("1".equals(lineParts[3])) {
                    relationType = DataTypes.RelationType.ancestor;
                } else if ("2".equals(lineParts[3])) {
                    relationType = DataTypes.RelationType.union;
                }
                this.addRelationEntry(lineParts[1], lineParts[2], relationType, null);
            } else if (lineParts[0].equals("2")) {
                if (lineParts.length != 7) {
                    throw new ImportException("Incorrect number of fields in line:\n" + lineString);
                }
                if (!lineParts[3].trim().isEmpty()) {
                    this.addFieldEntry(lineParts[2], lineParts[3]);
                }
                if (!lineParts[4].trim().isEmpty()) {
                    this.addFieldEntry(lineParts[2].trim() + "_Place", lineParts[4]);
                }
                if (!lineParts[5].trim().isEmpty()) {
                    this.addFieldEntry(lineParts[2].trim() + "_Date", lineParts[5]);
                }
                if (!lineParts[6].trim().isEmpty()) {
                    this.addFieldEntry(lineParts[2].trim() + "_AlterID", lineParts[6]);
                    this.addRelationEntry(lineParts[1], lineParts[5], DataTypes.RelationType.other, lineParts[2].trim());
                }
            } else if (lineParts[0].equals("0")) {
                if (lineParts.length != 4) {
                    throw new ImportException("Incorrect number of fields in line:\n" + lineString);
                }
                String[] nameParts = lineParts[3].split("/");
                if (nameParts.length == 1) {
                    this.addFieldEntry("Name", nameParts[0]);
                } else {
                    for (int nameCount = 0; nameCount < nameParts.length; ++nameCount) {
                        this.addFieldEntry("Name" + (nameCount + 1), nameParts[nameCount]);
                    }
                }
                if ("0".equals(lineParts[2])) {
                    this.addFieldEntry("Gender", "Male");
                } else if ("1".equals(lineParts[2])) {
                    this.addFieldEntry("Gender", "Female");
                } else if ("2".equals(lineParts[2])) {
                    this.addFieldEntry("Gender", "Unknown");
                } else {
                    this.addFieldEntry("Gender", lineParts[2]);
                }
            } else {
                throw new ImportException("Invalid TIP line type: " + lineString);
            }
        }
        while (gedcomLevelStrings.size() > this.gedcomLevel) {
            gedcomLevelStrings.remove(gedcomLevelStrings.size() - 1);
        }
        if (this.hasCurrentField()) {
            gedcomLevelStrings.add(this.getCurrentField().currentName);
        }
    }

    @Override
    public boolean isRelation() {
        return false;
    }
}

