/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.kintypestrings;

import java.net.URI;
import java.net.URISyntaxException;
import nl.mpi.kinnate.kintypestrings.KinTypeElement;
import nl.mpi.kinnate.kintypestrings.ParserHighlight;
import nl.mpi.kinnate.kintypestrings.QuerySectionParser;

public class MessageStringParser {
    QuerySectionParser querySectionParser;
    KinTypeElement queryElement;
    String messageString = null;
    URI importURI = null;

    public boolean foundQueryCondition() {
        return this.queryElement != null;
    }

    public boolean foundSyntaxError() {
        return this.querySectionParser != null && !this.querySectionParser.foundKinType || this.queryElement.queryTerms == null;
    }

    public KinTypeElement getQueryElement() {
        return this.queryElement;
    }

    public URI getImportURI() {
        return this.importURI;
    }

    public String getMessageString() {
        return this.messageString;
    }

    public void checkForMessages(String consumableString, ParserHighlight parserHighlight) {
        if (consumableString.startsWith("@")) {
            int initialLength = consumableString.length();
            boolean foundKinType = true;
            String errorMessage = null;
            parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Message, initialLength - consumableString.length(), "A message will be shown if the required condition is met");
            if ((consumableString = consumableString.substring(1)).startsWith("ShowMessageIfNotFound")) {
                consumableString = consumableString.substring("ShowMessageIfNotFound".length());
                this.querySectionParser = new QuerySectionParser(consumableString, parserHighlight, foundKinType, errorMessage);
                this.queryElement = new KinTypeElement();
                this.querySectionParser.parseQuerySection(this.queryElement, initialLength);
                consumableString = this.querySectionParser.consumableString;
                parserHighlight = this.querySectionParser.parserHighlight;
                foundKinType = this.querySectionParser.foundKinType;
                errorMessage = this.querySectionParser.errorMessage;
                if (!foundKinType) {
                    parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Error, initialLength - consumableString.length(), errorMessage);
                } else if (this.queryElement.queryTerms == null) {
                    parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Error, initialLength - consumableString.length(), "Incorrect syntax: a query is required eg [search term]");
                } else {
                    parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Message, initialLength - consumableString.length(), "A message will be shown if the required condition is met");
                    String[] messageParts = consumableString.split("\\\"");
                    if (messageParts.length > 1) {
                        this.messageString = messageParts[1];
                    }
                    if (messageParts.length > 2) {
                        String uriSection = messageParts[2];
                        try {
                            this.importURI = new URI(uriSection.trim());
                            if (this.importURI.getScheme() == null || this.importURI.getScheme().length() == 0) {
                                throw new URISyntaxException("", "scheme is required");
                            }
                        }
                        catch (URISyntaxException exception) {
                            parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Error, initialLength - uriSection.length(), "Incorrect URL syntax");
                        }
                    }
                    if (messageParts.length <= 1) {
                        parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Error, initialLength - consumableString.length(), "Incorrect syntax: a message in quotes is required followed by and an optional URL");
                    }
                }
            } else {
                parserHighlight = parserHighlight.addHighlight(ParserHighlight.ParserHighlightType.Error, initialLength - consumableString.length(), "Incorrect syntax");
            }
        }
    }
}

