/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.svg;

import java.net.URI;
import java.net.URISyntaxException;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;
import org.apache.batik.swing.svg.SVGUserAgentGUIAdapter;

public class GraphUserAgent
extends SVGUserAgentGUIAdapter {
    private GraphPanel graphPanel;
    private MessageDialogHandler dialogHandler;
    private ArbilDataNodeLoader dataNodeLoader;

    public GraphUserAgent(GraphPanel parentComponent, MessageDialogHandler dialogHandler, ArbilDataNodeLoader dataNodeLoader) {
        super(parentComponent);
        this.graphPanel = parentComponent;
        this.dialogHandler = dialogHandler;
        this.dataNodeLoader = dataNodeLoader;
    }

    public void displayError(String message) {
        this.dialogHandler.addMessageDialogToQueue(message, "SVG Error");
    }

    public void displayError(Exception exception) {
        BugCatcherManager.getBugCatcher().logError(exception);
    }

    public void displayMessage(String message) {
        this.dialogHandler.addMessageDialogToQueue(message, "SVG Error");
    }

    public void showAlert(String message) {
        this.dialogHandler.addMessageDialogToQueue(message, "SVG Notification");
    }

    public void openLink(String targetUri, boolean newc) {
        this.graphPanel.metadataPanel.removeAllArbilDataNodeRows();
        try {
            ArbilDataNode arbilDataNode = this.dataNodeLoader.getArbilDataNode(null, new URI(targetUri));
            this.graphPanel.metadataPanel.addArbilDataNode(arbilDataNode);
        }
        catch (URISyntaxException urise) {
            BugCatcherManager.getBugCatcher().logError((Exception)urise);
        }
        this.graphPanel.setSelectedIds(new UniqueIdentifier[0]);
        this.graphPanel.metadataPanel.updateEditorPane();
    }
}

