/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JButton;
import javax.swing.JInternalFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.data.ContainerNode;
import nl.mpi.arbil.ui.ArbilNodeSearchPanel;
import nl.mpi.arbil.ui.ArbilSplitPanel;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.kinnate.kindata.VisiblePanelSetting;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.KinDragTransferHandler;
import nl.mpi.kinnate.ui.KinTree;

public class ArchiveEntityLinkerPanel
extends JPanel
implements ActionListener {
    private KinTree archiveTree;
    private JButton nextButton;
    private TreeType treeType;
    private VisiblePanelSetting panelSetting;
    private ArbilTreeHelper treeHelper;
    private ArbilDataNodeLoader dataNodeLoader;
    private ContainerNode rootNode;

    public ArchiveEntityLinkerPanel(VisiblePanelSetting panelSetting, KinDiagramPanel kinDiagramPanel, GraphPanel graphPanel, KinDragTransferHandler dragTransferHandler, TreeType treeType, ArbilTreeHelper treeHelper, ArbilDataNodeLoader dataNodeLoader) {
        this.treeHelper = treeHelper;
        this.dataNodeLoader = dataNodeLoader;
        this.treeType = treeType;
        this.panelSetting = panelSetting;
        this.rootNode = new ContainerNode(null, "", null, new ArbilNode[0]);
        this.archiveTree = new KinTree(kinDiagramPanel, graphPanel, this.rootNode);
        this.setLayout(new BorderLayout());
        JPanel treePanel = new JPanel(new BorderLayout());
        this.add((Component)treePanel, "Center");
        this.nextButton = new JButton("Search Selected");
        this.nextButton.setActionCommand("Search");
        this.nextButton.addActionListener(this);
        treePanel.add((Component)new JScrollPane((Component)((Object)this.archiveTree)), "Center");
        treePanel.add((Component)this.nextButton, "Last");
        this.archiveTree.setTransferHandler(dragTransferHandler);
        this.archiveTree.setDragEnabled(true);
    }

    public void loadTreeNodes() {
        try {
            ArbilDataNode[] allEntities;
            this.treeHelper.loadLocationsList();
            switch (this.treeType) {
                case LocalTree: {
                    allEntities = this.treeHelper.getLocalCorpusNodes();
                    this.setName("Arbil Local Corpus");
                    break;
                }
                case RemoteTree: {
                    allEntities = this.treeHelper.getRemoteCorpusNodes();
                    this.setName("Arbil Remote Corpus");
                    break;
                }
                default: {
                    ArbilDataNode imdiCorporaNode = this.dataNodeLoader.getArbilDataNode(null, new URI("http://corpus1.mpi.nl/IMDI/metadata/IMDI.imdi"));
                    allEntities = new ArbilNode[]{imdiCorporaNode};
                    this.setName("The TLA Language Archive");
                }
            }
            this.rootNode.setChildNodes((ArbilNode[])allEntities);
            this.archiveTree.requestResort();
        }
        catch (URISyntaxException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
        }
    }

    private void getSeachPanel() {
        JPanel searchPanel = new JPanel(new BorderLayout());
        String frameTitle = "Archive Search";
        ArbilTableModel resultsTableModel = new ArbilTableModel(null);
        ArbilTable imdiTable = new ArbilTable(resultsTableModel, frameTitle);
        ArbilSplitPanel imdiSplitPanel = new ArbilSplitPanel(imdiTable);
        JInternalFrame searchFrame = new JInternalFrame();
        searchPanel.add((Component)new ArbilNodeSearchPanel(searchFrame, resultsTableModel, (ArbilNode[])this.archiveTree.getSelectedNodes()), "First");
        searchPanel.add((Component)imdiSplitPanel, "Center");
        JButton closeSearch = new JButton("Close Search");
        closeSearch.setActionCommand("Close Search");
        closeSearch.addActionListener(this);
        searchPanel.add((Component)closeSearch, "Last");
        imdiSplitPanel.setSplitDisplay();
        searchPanel.setName(this.getName() + " Search");
        this.panelSetting.addTargetPanel(searchPanel, true);
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("Search")) {
            this.getSeachPanel();
        }
        if (ae.getActionCommand().equals("Close Search")) {
            this.panelSetting.removeTargetPanel(((Component)ae.getSource()).getParent());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TreeType {
        RemoteTree,
        LocalTree,
        MpiTree;

    }
}

