/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.kindata.DataTypes;
import nl.mpi.kinnate.kindocument.EntityDocument;
import nl.mpi.kinnate.kindocument.EntityMerger;
import nl.mpi.kinnate.kindocument.ImportTranslator;
import nl.mpi.kinnate.kindocument.RelationLinker;
import nl.mpi.kinnate.svg.DataStoreSvg;
import nl.mpi.kinnate.svg.GraphPanel;
import nl.mpi.kinnate.svg.SvgUpdateHandler;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.entityprofiles.ProfileRecord;
import nl.mpi.kinnate.uniqueidentifiers.UniqueIdentifier;

public class GraphPanelContextMenu
extends JPopupMenu
implements ActionListener {
    private KinDiagramPanel kinDiagramPanel;
    private GraphPanel graphPanel;
    private JMenu addEntityMenu;
    private JMenuItem duplicateEntitiesMenu;
    private JMenuItem mergeEntitiesMenu;
    private JMenuItem addRelationEntityMenu;
    private JMenuItem removeRelationEntityMenu;
    private JMenuItem setAsEgoMenuItem;
    private JMenuItem addAsEgoMenuItem;
    private JMenuItem removeEgoMenuItem;
    private JMenuItem addAsRequiredMenuItem;
    private JMenuItem removeRequiredMenuItem;
    private JMenuItem saveFileMenuItem;
    private JMenuItem deleteMenu;
    final JSeparator jSeparator2 = new JSeparator();
    final JSeparator jSeparator3 = new JSeparator();
    private UniqueIdentifier[] selectedIdentifiers = null;
    private Point eventLocation;
    private ArbilDataNodeLoader dataNodeLoader;

    public GraphPanelContextMenu(KinDiagramPanel egoSelectionPanelLocal, final GraphPanel graphPanelLocal, final EntityCollection entityCollection, final ArbilWindowManager arbilWindowManager, ArbilDataNodeLoader dataNodeLoaderL, final SessionStorage sessionStorage) {
        this.kinDiagramPanel = egoSelectionPanelLocal;
        this.graphPanel = graphPanelLocal;
        this.dataNodeLoader = dataNodeLoaderL;
        if (egoSelectionPanelLocal != null) {
            final ActionListener addMenuActionListener = new ActionListener(){

                public void actionPerformed(final ActionEvent evt) {
                    if (!GraphPanelContextMenu.this.kinDiagramPanel.verifyDiagramDataLoaded()) {
                        return;
                    }
                    new Thread(){

                        public void run() {
                            GraphPanelContextMenu.this.kinDiagramPanel.showProgressBar();
                            String nodeType = evt.getActionCommand();
                            try {
                                EntityDocument entityDocument = new EntityDocument(nodeType, new ImportTranslator(true), sessionStorage, entityCollection.getProjectRecord());
                                entityDocument.saveDocument();
                                URI addedEntityUri = entityDocument.getFile().toURI();
                                entityCollection.updateDatabase(entityDocument.getFile().toURI(), entityDocument.getUniqueIdentifier());
                                GraphPanelContextMenu.this.kinDiagramPanel.addRequiredNodes(new UniqueIdentifier[]{entityDocument.getUniqueIdentifier()}, GraphPanelContextMenu.this.eventLocation);
                            }
                            catch (ImportException exception) {
                                GraphPanelContextMenu.this.kinDiagramPanel.clearProgressBar();
                                BugCatcherManager.getBugCatcher().logError((Exception)exception);
                                arbilWindowManager.addMessageDialogToQueue("Failed to create entity: " + exception.getMessage(), "Add Entity");
                            }
                            catch (EntityServiceException exception) {
                                BugCatcherManager.getBugCatcher().logError((Exception)exception);
                                arbilWindowManager.addMessageDialogToQueue(exception.getMessage(), "Update Database");
                            }
                        }
                    }.start();
                }
            };
            this.addEntityMenu = new JMenu("Add");
            this.addEntityMenu.addMenuListener(new MenuListener(){

                public void menuSelected(MenuEvent e) {
                    GraphPanelContextMenu.this.addEntityMenu.removeAll();
                    for (ProfileRecord profileRecord : graphPanelLocal.dataStoreSvg.selectedProfiles) {
                        JMenuItem addMenuItem = new JMenuItem(profileRecord.profileName);
                        addMenuItem.setActionCommand(profileRecord.profileId);
                        addMenuItem.addActionListener(addMenuActionListener);
                        GraphPanelContextMenu.this.addEntityMenu.add(addMenuItem);
                    }
                }

                public void menuDeselected(MenuEvent e) {
                }

                public void menuCanceled(MenuEvent e) {
                }
            });
            this.add(this.addEntityMenu);
            JMenu shapeSubMenu = new JMenu("Add Geometry");
            for (SvgUpdateHandler.GraphicsTypes graphicsTypes : SvgUpdateHandler.GraphicsTypes.values()) {
                JMenuItem addLabel = new JMenuItem("Add " + graphicsTypes.name());
                addLabel.setActionCommand(graphicsTypes.name());
                shapeSubMenu.add(addLabel);
                if (SvgUpdateHandler.GraphicsTypes.Polyline.equals((Object)graphicsTypes)) {
                    addLabel.setEnabled(false);
                }
                addLabel.addActionListener(this);
            }
            this.add(shapeSubMenu);
            this.deleteMenu = new JMenuItem("Delete selected from project");
            this.deleteMenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    int entityCount = 0;
                    for (UniqueIdentifier uniqueIdentifier : GraphPanelContextMenu.this.selectedIdentifiers) {
                        if (uniqueIdentifier.isGraphicsIdentifier() || uniqueIdentifier.isTransientIdentifier()) continue;
                        ++entityCount;
                    }
                    boolean doDelete = false;
                    if (entityCount == 0) {
                        doDelete = true;
                    } else if (0 == arbilWindowManager.showDialogBox(entityCount + " entities will be deleted from the current project", "Delete Entity", 2, 2)) {
                        doDelete = true;
                    }
                    if (doDelete) {
                        new Thread(new Runnable(){

                            public void run() {
                                GraphPanelContextMenu.this.kinDiagramPanel.showProgressBar();
                                ArrayList<UniqueIdentifier> affectedIdentifiers = new ArrayList<UniqueIdentifier>();
                                for (UniqueIdentifier uniqueIdentifier : GraphPanelContextMenu.this.selectedIdentifiers) {
                                    if (uniqueIdentifier.isGraphicsIdentifier()) {
                                        ((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.svgUpdateHandler.deleteGraphics(uniqueIdentifier);
                                        continue;
                                    }
                                    if (uniqueIdentifier.isTransientIdentifier()) {
                                        GraphPanelContextMenu.this.kinDiagramPanel.clearProgressBar();
                                        throw new UnsupportedOperationException("Cannot delete transient entities.");
                                    }
                                    affectedIdentifiers.add(uniqueIdentifier);
                                }
                                UniqueIdentifier[] affectedIdentifiersArray = affectedIdentifiers.toArray(new UniqueIdentifier[0]);
                                try {
                                    RelationLinker relationLinker = new RelationLinker(sessionStorage, (MessageDialogHandler)arbilWindowManager, entityCollection);
                                    relationLinker.deleteEntity(affectedIdentifiersArray);
                                }
                                catch (ImportException exception) {
                                    arbilWindowManager.addMessageDialogToQueue("Failed to delete: " + exception.getMessage(), GraphPanelContextMenu.this.mergeEntitiesMenu.getText());
                                }
                                GraphPanelContextMenu.this.kinDiagramPanel.removeRequiredNodes(affectedIdentifiersArray);
                                GraphPanelContextMenu.this.kinDiagramPanel.removeEgoNodes(affectedIdentifiersArray);
                                GraphPanelContextMenu.this.kinDiagramPanel.clearProgressBar();
                            }
                        }).start();
                    }
                }
            });
            this.add(this.deleteMenu);
            this.mergeEntitiesMenu = new JMenuItem("Merge Selected Entities");
            this.mergeEntitiesMenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    String messageString = "The selected entites will be merged,\nAll relations will be preserved and " + (GraphPanelContextMenu.this.selectedIdentifiers.length - 1) + " entities will be deleted.\n";
                    if (0 == arbilWindowManager.showDialogBox(messageString = messageString + "Do you wish to continue?", "Merge Entities", 2, 2)) {
                        new Thread(new Runnable(){

                            public void run() {
                                GraphPanelContextMenu.this.kinDiagramPanel.showProgressBar();
                                try {
                                    EntityMerger entityMerger = new EntityMerger(sessionStorage, (MessageDialogHandler)arbilWindowManager, entityCollection);
                                    UniqueIdentifier leadMergedEntity = entityMerger.mergeEntities(GraphPanelContextMenu.this.selectedIdentifiers);
                                    GraphPanelContextMenu.this.dataNodeLoader.requestReload(GraphPanelContextMenu.this.dataNodeLoader.getArbilDataNode(null, leadMergedEntity.getFileInProject(GraphPanelContextMenu.this.kinDiagramPanel.getEntityCollection().getProjectRecord()).toURI()));
                                    GraphPanelContextMenu.this.kinDiagramPanel.entityRelationsChanged(entityMerger.getAffectedIdentifiersArray());
                                    GraphPanelContextMenu.this.kinDiagramPanel.removeRequiredNodes(entityMerger.getDeletedIdentifiersArray());
                                }
                                catch (ImportException exception) {
                                    arbilWindowManager.addMessageDialogToQueue("Failed to merge: " + exception.getMessage(), GraphPanelContextMenu.this.mergeEntitiesMenu.getText());
                                }
                                catch (EntityServiceException exception) {
                                    arbilWindowManager.addMessageDialogToQueue("Failed to merge: " + exception.getMessage(), GraphPanelContextMenu.this.mergeEntitiesMenu.getText());
                                }
                                GraphPanelContextMenu.this.kinDiagramPanel.clearProgressBar();
                            }
                        }).start();
                    }
                }
            });
            this.add(this.mergeEntitiesMenu);
            this.duplicateEntitiesMenu = new JMenuItem("Duplicate Selected Entities");
            this.duplicateEntitiesMenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    new Thread(new Runnable(){

                        public void run() {
                            GraphPanelContextMenu.this.kinDiagramPanel.showProgressBar();
                            try {
                                UniqueIdentifier[] duplicateEntities = new EntityMerger(sessionStorage, (MessageDialogHandler)arbilWindowManager, entityCollection).duplicateEntities(GraphPanelContextMenu.this.selectedIdentifiers);
                                GraphPanelContextMenu.this.kinDiagramPanel.entityRelationsChanged(GraphPanelContextMenu.this.selectedIdentifiers);
                                GraphPanelContextMenu.this.kinDiagramPanel.addRequiredNodes(duplicateEntities, GraphPanelContextMenu.this.eventLocation);
                            }
                            catch (ImportException exception) {
                                arbilWindowManager.addMessageDialogToQueue("Failed to duplicate: " + exception.getMessage(), GraphPanelContextMenu.this.duplicateEntitiesMenu.getText());
                            }
                            catch (EntityServiceException exception) {
                                arbilWindowManager.addMessageDialogToQueue("Failed to duplicate: " + exception.getMessage(), GraphPanelContextMenu.this.duplicateEntitiesMenu.getText());
                            }
                            GraphPanelContextMenu.this.kinDiagramPanel.clearProgressBar();
                        }
                    }).start();
                }
            });
            this.add(this.duplicateEntitiesMenu);
            this.addRelationEntityMenu = new JMenu("Add Relation");
            this.add(this.addRelationEntityMenu);
            for (Enum enum_ : DataTypes.RelationType.values()) {
                JMenuItem addRelationEntityMenuItem = new JMenuItem(enum_.name());
                addRelationEntityMenuItem.setActionCommand(enum_.name());
                addRelationEntityMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(final ActionEvent evt) {
                        new Thread(new Runnable(){

                            public void run() {
                                GraphPanelContextMenu.this.kinDiagramPanel.showProgressBar();
                                try {
                                    UniqueIdentifier[] affectedIdentifiers = new RelationLinker(sessionStorage, (MessageDialogHandler)arbilWindowManager, entityCollection).linkEntities(GraphPanelContextMenu.this.selectedIdentifiers, DataTypes.RelationType.valueOf(evt.getActionCommand()), null, null);
                                    GraphPanelContextMenu.this.kinDiagramPanel.entityRelationsChanged(affectedIdentifiers);
                                }
                                catch (ImportException exception) {
                                    arbilWindowManager.addMessageDialogToQueue("Failed to create relation: " + exception.getMessage(), GraphPanelContextMenu.this.addRelationEntityMenu.getText());
                                }
                                GraphPanelContextMenu.this.kinDiagramPanel.clearProgressBar();
                            }
                        }).start();
                    }
                });
                this.addRelationEntityMenu.add(addRelationEntityMenuItem);
            }
            this.removeRelationEntityMenu = new JMenu("Remove Relations");
            this.add(this.removeRelationEntityMenu);
            String actionString = "Remove relations between selected";
            JMenuItem removeRelationEntityMenuItem = new JMenuItem(actionString);
            removeRelationEntityMenuItem.setActionCommand(actionString);
            removeRelationEntityMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    new Thread(new Runnable(){

                        public void run() {
                            GraphPanelContextMenu.this.kinDiagramPanel.showProgressBar();
                            try {
                                new RelationLinker(sessionStorage, (MessageDialogHandler)arbilWindowManager, entityCollection).unlinkEntities(GraphPanelContextMenu.this.graphPanel, GraphPanelContextMenu.this.selectedIdentifiers);
                                GraphPanelContextMenu.this.kinDiagramPanel.entityRelationsChanged(GraphPanelContextMenu.this.selectedIdentifiers);
                            }
                            catch (ImportException exception) {
                                arbilWindowManager.addMessageDialogToQueue("Failed to remove relations: " + exception.getMessage(), GraphPanelContextMenu.this.removeRelationEntityMenu.getText());
                            }
                            GraphPanelContextMenu.this.kinDiagramPanel.clearProgressBar();
                        }
                    }).start();
                }
            });
            this.removeRelationEntityMenu.add(removeRelationEntityMenuItem);
            this.add(new JSeparator());
        }
        this.setAsEgoMenuItem = new JMenuItem("Set as Ego (list will be cleared)");
        this.setAsEgoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.kinDiagramPanel.setEgoNodes(GraphPanelContextMenu.this.selectedIdentifiers);
            }
        });
        this.add(this.setAsEgoMenuItem);
        this.addAsEgoMenuItem = new JMenuItem("Add to ego list");
        this.addAsEgoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.kinDiagramPanel.addEgoNodes(GraphPanelContextMenu.this.selectedIdentifiers);
            }
        });
        this.add(this.addAsEgoMenuItem);
        this.removeEgoMenuItem = new JMenuItem("Remove from ego list");
        this.removeEgoMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.kinDiagramPanel.removeEgoNodes(GraphPanelContextMenu.this.selectedIdentifiers);
            }
        });
        this.add(this.removeEgoMenuItem);
        this.add(this.jSeparator2);
        this.addAsRequiredMenuItem = new JMenuItem("Attach to diagram");
        this.addAsRequiredMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.kinDiagramPanel.addRequiredNodes(GraphPanelContextMenu.this.selectedIdentifiers, null);
            }
        });
        this.add(this.addAsRequiredMenuItem);
        this.removeRequiredMenuItem = new JMenuItem("Release from diagram");
        this.removeRequiredMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.kinDiagramPanel.removeRequiredNodes(GraphPanelContextMenu.this.selectedIdentifiers);
            }
        });
        this.add(this.removeRequiredMenuItem);
        this.add(this.jSeparator3);
        JMenuItem resetZoomMenuItem = new JMenuItem("Reset Zoom");
        resetZoomMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GraphPanelContextMenu.this.graphPanel.resetZoom();
            }
        });
        this.add(resetZoomMenuItem);
        JMenuItem resetLayoutMenuItem = new JMenuItem("Reset Layout");
        resetLayoutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (!GraphPanelContextMenu.this.kinDiagramPanel.verifyDiagramDataLoaded()) {
                    return;
                }
                GraphPanelContextMenu.this.graphPanel.resetLayout(true);
            }
        });
        this.add(resetLayoutMenuItem);
        JMenuItem searchEntityServiceMenuItem = new JMenuItem("Search Entity Service");
        searchEntityServiceMenuItem.setToolTipText("Search the entity database for entities matching the current kin terms and populate he diagram with the results");
        searchEntityServiceMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
            }
        });
        searchEntityServiceMenuItem.setEnabled(false);
        this.add(searchEntityServiceMenuItem);
        this.saveFileMenuItem = new JMenuItem();
        this.saveFileMenuItem.setText("Save All Data Changes");
        this.saveFileMenuItem.setEnabled(false);
        this.saveFileMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                new Thread(new Runnable(){

                    public void run() {
                        GraphPanelContextMenu.this.kinDiagramPanel.showProgressBar();
                        try {
                            arbilWindowManager.stopEditingInCurrentWindow();
                            GraphPanelContextMenu.this.dataNodeLoader.saveNodesNeedingSave(true);
                        }
                        catch (Exception ex) {
                            BugCatcherManager.getBugCatcher().logError(ex);
                        }
                        GraphPanelContextMenu.this.kinDiagramPanel.clearProgressBar();
                    }
                }).start();
            }
        });
        this.add(this.saveFileMenuItem);
    }

    public void show(Component cmpnt, int i, int i1) {
        boolean showNonTransientMenus;
        this.eventLocation = new Point(i, i1);
        this.selectedIdentifiers = this.graphPanel.getSelectedIds();
        int nonTransientNodeCount = 0;
        int transientNodeCount = 0;
        int graphicsIdentifierCount = 0;
        for (UniqueIdentifier uniqueIdentifier : this.selectedIdentifiers) {
            if (uniqueIdentifier.isGraphicsIdentifier()) {
                ++graphicsIdentifierCount;
                continue;
            }
            if (uniqueIdentifier.isTransientIdentifier()) {
                ++transientNodeCount;
                continue;
            }
            ++nonTransientNodeCount;
        }
        if (this.graphPanel.dataStoreSvg.diagramMode != DataStoreSvg.DiagramMode.FreeForm) {
            this.duplicateEntitiesMenu.setEnabled(nonTransientNodeCount > 0);
            this.removeRelationEntityMenu.setEnabled(nonTransientNodeCount > 1);
            this.mergeEntitiesMenu.setEnabled(nonTransientNodeCount > 1);
            this.addRelationEntityMenu.setEnabled(nonTransientNodeCount > 1);
            this.setAsEgoMenuItem.setEnabled(nonTransientNodeCount > 0);
            this.addAsEgoMenuItem.setEnabled(nonTransientNodeCount > 0);
            this.removeEgoMenuItem.setEnabled(nonTransientNodeCount > 0);
            this.addAsRequiredMenuItem.setEnabled(nonTransientNodeCount > 0);
            this.removeRequiredMenuItem.setEnabled(nonTransientNodeCount > 0);
            showNonTransientMenus = true;
        } else {
            showNonTransientMenus = false;
        }
        this.removeRelationEntityMenu.setVisible(showNonTransientMenus);
        this.mergeEntitiesMenu.setVisible(showNonTransientMenus);
        this.duplicateEntitiesMenu.setVisible(showNonTransientMenus);
        this.addRelationEntityMenu.setVisible(showNonTransientMenus);
        this.setAsEgoMenuItem.setVisible(showNonTransientMenus);
        this.addAsEgoMenuItem.setVisible(showNonTransientMenus);
        this.removeEgoMenuItem.setVisible(showNonTransientMenus);
        this.addAsRequiredMenuItem.setVisible(showNonTransientMenus);
        this.removeRequiredMenuItem.setVisible(showNonTransientMenus);
        this.addEntityMenu.setVisible(showNonTransientMenus);
        this.jSeparator2.setVisible(showNonTransientMenus);
        this.jSeparator3.setVisible(showNonTransientMenus);
        this.deleteMenu.setEnabled(nonTransientNodeCount + graphicsIdentifierCount > 0 && transientNodeCount == 0);
        this.saveFileMenuItem.setEnabled(this.dataNodeLoader.nodesNeedSave());
        super.show(cmpnt, i, i1);
    }

    public void actionPerformed(final ActionEvent e) {
        if (!this.kinDiagramPanel.verifyDiagramDataLoaded()) {
            return;
        }
        new Thread(new Runnable(){

            public void run() {
                GraphPanelContextMenu.this.kinDiagramPanel.showProgressBar();
                ((GraphPanelContextMenu)GraphPanelContextMenu.this).graphPanel.svgUpdateHandler.addGraphics(SvgUpdateHandler.GraphicsTypes.valueOf(e.getActionCommand()), GraphPanelContextMenu.this.eventLocation);
                GraphPanelContextMenu.this.kinDiagramPanel.clearProgressBar();
            }
        }).start();
    }
}

