/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

public class ImportSamplesFileMenu
extends JMenu
implements ActionListener {
    private AbstractDiagramManager diagramWindowManager;
    private MessageDialogHandler dialogHandler;
    private Component parentComponent;

    public ImportSamplesFileMenu(AbstractDiagramManager diagramWindowManager, MessageDialogHandler dialogHandler, Component parentComponent) {
        this.diagramWindowManager = diagramWindowManager;
        this.parentComponent = parentComponent;
        this.dialogHandler = dialogHandler;
        this.addSampleToMenu("Gedcom Simple File (small sample of three individuals)", "/gedcomsamples/wiki-test-ged.ged");
        this.addSampleToMenu("Gedcom Torture File (only for testing GEDOM compliance)", "/TestGED/TGC55C.ged");
        this.addSampleToMenu("European Royalty (royal92.ged)", "/gedcomsamples/royal92.ged");
    }

    private void addSampleToMenu(String menuText, String sampleFileString) {
        JMenuItem currentMenuItem = new JMenuItem(menuText);
        currentMenuItem.setActionCommand(sampleFileString);
        currentMenuItem.addActionListener(this);
        this.add(currentMenuItem);
    }

    public void actionPerformed(ActionEvent e) {
        SavePanel currentSavePanel = this.diagramWindowManager.getCurrentSavePanel(this.parentComponent);
        try {
            if (currentSavePanel instanceof KinDiagramPanel) {
                KinDiagramPanel diagramPanel = (KinDiagramPanel)currentSavePanel;
                this.diagramWindowManager.openJarImportPanel(e.getActionCommand(), diagramPanel, diagramPanel.getEntityCollection());
            } else {
                this.dialogHandler.addMessageDialogToQueue("Cannot import into this type of window\n" + e.getActionCommand(), "Import Sample Data");
            }
        }
        catch (ImportException exception1) {
            this.dialogHandler.addMessageDialogToQueue(exception1.getMessage() + "\n" + e.getActionCommand(), "Import Sample Data");
        }
    }
}

