/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.EventQueue;
import java.awt.Rectangle;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.flap.plugin.PluginBugCatcher;
import nl.mpi.flap.plugin.PluginDialogHandler;
import nl.mpi.flap.plugin.PluginSessionStorage;
import nl.mpi.kinnate.KinOathVersion;
import nl.mpi.kinnate.KinnateArbilInjector;
import nl.mpi.kinnate.entityindexer.EntityCollection;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.gedcomimport.ImportException;
import nl.mpi.kinnate.plugins.export.MigrationWizard;
import nl.mpi.kinnate.projects.ProjectManager;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;
import nl.mpi.kinnate.ui.window.WindowedDiagramManager;

public class MainFrame
extends JFrame {
    public MainFrame() {
        this.initComponents();
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.pack();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                final ApplicationVersionManager versionManager = new ApplicationVersionManager((ApplicationVersion)new KinOathVersion());
                KinnateArbilInjector injector = new KinnateArbilInjector();
                injector.injectHandlers(versionManager);
                final ArbilWindowManager windowManager = injector.getWindowManager();
                final SessionStorage sessionStorage = injector.getSessionStorage();
                final ProjectManager projectManager = new ProjectManager(sessionStorage, windowManager);
                final WindowedDiagramManager abstractDiagramManager = new WindowedDiagramManager(versionManager, windowManager, sessionStorage, injector.getDataNodeLoader(), injector.getTreeHelper(), projectManager);
                try {
                    boolean databaseDirectoryOk = false;
                    while (!databaseDirectoryOk) {
                        try {
                            String storedDatabasePath = sessionStorage.loadString("KinOathDatabaseDirectory");
                            File databaseDirectory = storedDatabasePath == null ? sessionStorage.getApplicationSettingsDirectory() : new File(storedDatabasePath);
                            EntityCollection.setGlobalDatabasePath(databaseDirectory);
                            databaseDirectoryOk = true;
                        }
                        catch (EntityServiceException entityServiceException) {
                            File[] databaseDirectorySelection;
                            String kinOath_Database_Directory = "KinOath Database Directory";
                            if (!windowManager.showConfirmDialogBox("The KinOath database could not be created. Do you want to choose another location?", "KinOath Database Directory")) {
                                System.exit(-1);
                            }
                            if ((databaseDirectorySelection = windowManager.showDirectorySelectBox("KinOath Database Directory", false)) == null || databaseDirectorySelection.length == 0) {
                                System.exit(-1);
                            }
                            sessionStorage.saveString("KinOathDatabaseDirectory", databaseDirectorySelection[0].toString());
                        }
                    }
                    final KinDiagramPanel initialDiagram = abstractDiagramManager.newDiagram(new Rectangle(0, 0, 640, 480), null);
                    ((AbstractDiagramManager)abstractDiagramManager).createApplicationWindow();
                    windowManager.setMessagesCanBeShown(true);
                    new Thread(){

                        public void run() {
                            ApplicationVersion applicationVersion = versionManager.getApplicationVersion();
                            File oldAppExportFile = new MigrationWizard((PluginBugCatcher)BugCatcherManager.getBugCatcher(), (PluginDialogHandler)windowManager, (PluginSessionStorage)sessionStorage).checkAndOfferMigration(Integer.parseInt(applicationVersion.currentMajor), Integer.parseInt(applicationVersion.currentMinor));
                            if (oldAppExportFile != null) {
                                try {
                                    abstractDiagramManager.openImportPanel(oldAppExportFile, initialDiagram, projectManager.getEntityCollectionForProject(projectManager.getDefaultProject(sessionStorage)));
                                }
                                catch (ImportException exception) {
                                    windowManager.addMessageDialogToQueue(exception.getMessage() + "\n" + oldAppExportFile.getAbsolutePath(), "Import Existing Data");
                                }
                                catch (EntityServiceException exception) {
                                    windowManager.addMessageDialogToQueue(exception.getMessage() + "\n" + oldAppExportFile.getAbsolutePath(), "Import Existing Data");
                                }
                            }
                        }
                    }.start();
                }
                catch (EntityServiceException entityServiceException) {
                    System.out.println(entityServiceException.getMessage());
                    JOptionPane.showMessageDialog(null, "Failed to create a new diagram: " + entityServiceException.getMessage(), "Launch Diagram Error", -1);
                    System.exit(-1);
                }
                versionManager.checkForUpdate();
            }
        });
    }
}

