/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.xml.bind.JAXBException;
import nl.mpi.kinnate.projects.ProjectManager;
import nl.mpi.kinnate.projects.ProjectRecord;

public class ProjectPreviewPanel
extends JPanel
implements PropertyChangeListener,
HierarchyListener {
    private final JLabel projectTitle;
    private final JTextField projectTitleField;
    private final JLabel projectDescription;
    private final JTextField projectDescriptionField;
    private final JLabel lastChangeDate;
    private final JLabel entityCount;
    private final JLabel relationCount;
    private final ProjectManager projectManager;
    private JFileChooser fileChooser = null;

    public ProjectPreviewPanel(ProjectManager projectManager, boolean isEditable) {
        super(new BorderLayout());
        this.projectManager = projectManager;
        JPanel labelsPanel = new JPanel(new GridLayout(5, 2));
        this.projectTitle = new JLabel();
        this.projectDescription = new JLabel();
        this.projectTitleField = new JTextField();
        this.projectDescriptionField = new JTextField();
        this.lastChangeDate = new JLabel();
        this.entityCount = new JLabel();
        this.relationCount = new JLabel();
        labelsPanel.add(new JLabel("Project Title"));
        if (isEditable) {
            labelsPanel.add(this.projectTitleField);
        } else {
            labelsPanel.add(this.projectTitle);
        }
        labelsPanel.add(new JLabel("Project Description"));
        if (isEditable) {
            labelsPanel.add(this.projectDescriptionField);
        } else {
            labelsPanel.add(this.projectDescription);
        }
        labelsPanel.add(new JLabel("Entity Count"));
        labelsPanel.add(this.entityCount);
        labelsPanel.add(new JLabel("Relation Count"));
        labelsPanel.add(this.relationCount);
        labelsPanel.add(new JLabel("Last Changed"));
        labelsPanel.add(this.lastChangeDate);
        this.add((Component)labelsPanel, "North");
        this.addHierarchyListener(this);
    }

    public void setProjectRecord(ProjectRecord projectRecord) {
        SimpleDateFormat dateFormat = new SimpleDateFormat();
        this.projectTitle.setText(projectRecord.getProjectName());
        this.projectDescription.setText(projectRecord.getProjectDescription());
        Date lastChangeDate1 = projectRecord.getLastChangeDate();
        if (lastChangeDate1 != null) {
            this.lastChangeDate.setText(dateFormat.format(lastChangeDate1));
        } else {
            this.lastChangeDate.setText("");
        }
        this.entityCount.setText(Integer.toString(projectRecord.getEntityCount()));
        this.relationCount.setText(Integer.toString(projectRecord.getRelationCount()));
    }

    public void clearProjectRecord() {
        this.projectTitle.setText("");
        this.projectDescription.setText("");
        this.lastChangeDate.setText("");
        this.entityCount.setText("");
        this.relationCount.setText("");
    }

    public void propertyChange(PropertyChangeEvent changeEvent) {
        if ("directoryChanged".equals(changeEvent.getPropertyName())) {
            this.clearProjectRecord();
        } else if ("SelectedFileChangedProperty".equals(changeEvent.getPropertyName())) {
            try {
                File selectedFile = (File)changeEvent.getNewValue();
                if (selectedFile != null) {
                    ProjectRecord projectRecord = this.projectManager.loadProjectRecord(selectedFile);
                    if (projectRecord == null) {
                        this.clearProjectRecord();
                    }
                    this.setProjectRecord(projectRecord);
                } else {
                    this.clearProjectRecord();
                }
            }
            catch (JAXBException exception) {
                this.clearProjectRecord();
            }
        }
    }

    public void hierarchyChanged(HierarchyEvent he) {
        if (this.fileChooser == null) {
            for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!(parent instanceof JFileChooser)) continue;
                this.fileChooser = (JFileChooser)parent;
                this.fileChooser.addPropertyChangeListener(this);
            }
        }
    }
}

