/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import nl.mpi.arbil.ArbilVersion;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.ApplicationVersion;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.ArbilBugCatcher;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.kinnate.SavePanel;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.ui.KinDiagramPanel;
import nl.mpi.kinnate.ui.KinOathHelp;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;
import org.xml.sax.SAXException;

public class HelpMenu
extends JMenu {
    private static final ResourceBundle menus = ResourceBundle.getBundle("nl/mpi/kinoath/localisation/Menus");
    JFrame helpWindow = null;

    public HelpMenu(final AbstractDiagramManager diagramWindowManager, final ArbilWindowManager dialogHandler, final SessionStorage sessionStorage, final ApplicationVersionManager versionManager, final Component parentComponent) {
        this.setText(menus.getString("HELP"));
        JMenuItem aboutMenuItem = new JMenuItem(menus.getString("ABOUT"));
        aboutMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ApplicationVersion appVersion = versionManager.getApplicationVersion();
                String messageString = menus.getString("KINOATH IS AN APPLICATION FOR  KINSHIP AND ARCHIVING.") + MessageFormat.format(menus.getString("KINOATH VERSION: {0}.{1}.{2}"), appVersion.currentMajor, appVersion.currentMinor, appVersion.currentRevision) + appVersion.lastCommitDate + MessageFormat.format(menus.getString("COMPILE DATE: {0}"), appVersion.compileDate) + MessageFormat.format(menus.getString("ARBIL VERSION: {0}.{1}.{2}"), new ArbilVersion().currentMajor, new ArbilVersion().currentMinor, new ArbilVersion().currentRevision) + MessageFormat.format(menus.getString("JAVA VERSION: {0} BY {1}"), System.getProperty("java.version"), System.getProperty("java.vendor"));
                dialogHandler.addMessageDialogToQueue(messageString, MessageFormat.format(menus.getString("ABOUT {0}"), versionManager.getApplicationVersion().applicationTitle));
            }
        });
        this.add(aboutMenuItem);
        JMenuItem helpMenuItem = new JMenuItem(menus.getString("INTERNAL HELP"));
        helpMenuItem.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        helpMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (HelpMenu.this.helpWindow == null) {
                        HelpMenu.this.helpWindow = diagramWindowManager.createHelpWindow(menus.getString("INTERNAL HELP"), (Component)((Object)new KinOathHelp()), new Rectangle(600, 400));
                    } else {
                        HelpMenu.this.helpWindow.setVisible(true);
                        HelpMenu.this.helpWindow.toFront();
                    }
                }
                catch (IOException ex) {
                    dialogHandler.addMessageDialogToQueue(MessageFormat.format(menus.getString("COULD NOT START THE HELP SYSTEM:{0}"), ex.getMessage()), "Internal Help");
                    BugCatcherManager.getBugCatcher().logError((Exception)ex);
                }
                catch (SAXException ex) {
                    dialogHandler.addMessageDialogToQueue(MessageFormat.format(menus.getString("COULD NOT START THE HELP SYSTEM:{0}"), ex.getMessage()), "Internal Help");
                    BugCatcherManager.getBugCatcher().logError((Exception)ex);
                }
            }
        });
        helpMenuItem.setEnabled(true);
        this.add(helpMenuItem);
        JMenuItem arbilWebsiteMenuItem = new JMenuItem(menus.getString("KINOATH WEBSITE"));
        arbilWebsiteMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    dialogHandler.openFileInExternalApplication(new URI("http://tla.mpi.nl/tools/tla-tools/kinoath"));
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.add(arbilWebsiteMenuItem);
        JMenuItem arbilOnlineManualMenuItem = new JMenuItem(menus.getString("KINOATH ONLINE MANUAL"));
        arbilOnlineManualMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    dialogHandler.openFileInExternalApplication(new URI("http://www.mpi.nl/corpus/html/kinoath/index.html"));
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.add(arbilOnlineManualMenuItem);
        JMenuItem arbilForumMenuItem = new JMenuItem(menus.getString("KINOATH FORUM (WEBSITE)"));
        arbilForumMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    dialogHandler.openFileInExternalApplication(new URI("http://tla.mpi.nl/forums/software/kinoath"));
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.add(arbilForumMenuItem);
        final JMenuItem viewErrorLogMenuItem = new JMenuItem(menus.getString("VIEW ERROR LOG"));
        viewErrorLogMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    dialogHandler.openFileInExternalApplication(ArbilBugCatcher.getLogFile((SessionStorage)sessionStorage, (ApplicationVersion)versionManager.getApplicationVersion()).toURI());
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.add(viewErrorLogMenuItem);
        JMenuItem reindexFilesMenuItem = new JMenuItem(menus.getString("REINDEX ALL FILES FOR THIS PROJECT"));
        reindexFilesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (dialogHandler.showConfirmDialogBox(menus.getString("THIS WILL REINDEX ALL FILES IN THE PROJECT, THIS MAY TAKE SOME TIME, DO YOU WANT TO PROCEED?"), menus.getString("REINDEX ALL FILES"))) {
                    new Thread(new Runnable(){

                        public void run() {
                            SavePanel currentSavePanel = diagramWindowManager.getCurrentSavePanel(parentComponent);
                            try {
                                if (currentSavePanel instanceof KinDiagramPanel) {
                                    KinDiagramPanel diagramPanel = (KinDiagramPanel)currentSavePanel;
                                    diagramPanel.showProgressBar();
                                    diagramPanel.getEntityCollection().recreateDatabase();
                                }
                                dialogHandler.addMessageDialogToQueue(menus.getString("REINDEXING COMPLETE."), menus.getString("REINDEX ALL FILES"));
                            }
                            catch (EntityServiceException exception) {
                                dialogHandler.addMessageDialogToQueue(exception.getMessage(), "Database Error");
                            }
                            if (currentSavePanel instanceof KinDiagramPanel) {
                                ((KinDiagramPanel)currentSavePanel).clearProgressBar();
                            }
                        }
                    }).start();
                }
            }
        });
        this.add(reindexFilesMenuItem);
        JMenuItem checkForUpdatesMenuItem = new JMenuItem(menus.getString("CHECK FOR UPDATES"));
        checkForUpdatesMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                try {
                    if (!versionManager.forceUpdateCheck()) {
                        ApplicationVersion appVersion = versionManager.getApplicationVersion();
                        String versionString = appVersion.currentMajor + "." + appVersion.currentMinor + "." + appVersion.currentRevision;
                        dialogHandler.addMessageDialogToQueue(MessageFormat.format(menus.getString("NO UPDATES FOUND, CURRENT VERSION IS {0}"), versionString), menus.getString("CHECK FOR UPDATES"));
                    }
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
        this.add(checkForUpdatesMenuItem);
        this.addMenuListener(new MenuListener(){

            public void menuCanceled(MenuEvent evt) {
            }

            public void menuDeselected(MenuEvent evt) {
            }

            public void menuSelected(MenuEvent evt) {
                viewErrorLogMenuItem.setEnabled(ArbilBugCatcher.getLogFile((SessionStorage)sessionStorage, (ApplicationVersion)versionManager.getApplicationVersion()).exists());
            }
        });
    }
}

