/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.menu;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.kinnate.entityindexer.EntityServiceException;
import nl.mpi.kinnate.ui.window.AbstractDiagramManager;

public class SamplesFileMenu
extends JMenu
implements ActionListener {
    private static final ResourceBundle menus = ResourceBundle.getBundle("nl/mpi/kinoath/localisation/Menus");
    private final AbstractDiagramManager diagramWindowManager;
    private final MessageDialogHandler dialogHandler;
    private final Component parentComponent;

    public SamplesFileMenu(AbstractDiagramManager diagramWindowManager, MessageDialogHandler dialogHandler, Component parentComponent) {
        this.diagramWindowManager = diagramWindowManager;
        this.dialogHandler = dialogHandler;
        this.parentComponent = parentComponent;
        this.addSampleToMenu(menus.getString("FREEFORM DIAGRAM SYNTAX"), "FreeformDiagramSyntax.svg");
        this.addSampleToMenu(menus.getString("QUERY DIAGRAM SYNTAX"), "QueryDiagramSyntax.svg");
        this.addSampleToMenu(menus.getString("HAWAIIAN KIN TERMS"), "HawaiianKinTerms.svg");
        this.addSampleToMenu(menus.getString("JAPANESE KIN TERMS"), "JapaneseKinTerms.svg");
        this.addSampleToMenu(menus.getString("SWEDISH KIN TERMS"), "SwedishKinTerms.svg");
        this.addSampleToMenu(menus.getString("CUSTOM SYMBOLS"), "CustomEntitySymbols.svg");
        this.addSampleToMenu(menus.getString("NAMED TRANSIENT ENTITIES"), "NamedTransientEntities.svg");
        this.addSampleToMenu(menus.getString("MATRIMONIAL RING EXAMPLES"), "MatrimonialRings.svg");
        this.addSampleToMenu(menus.getString("CHARLES II OF SPAIN"), "Charles_II_of_Spain.svg");
        this.addSampleToMenu(menus.getString("HAEMOPHILIA IN EUROPEAN ROYALTY"), "HaemophiliaEuropeanRoyalty.svg");
    }

    private void addSampleToMenu(String menuText, String sampleFileString) {
        String currentFilePath = SamplesFileMenu.class.getResource("/svgsamples/" + sampleFileString).toString();
        JMenuItem currentMenuItem = new JMenuItem(menuText);
        currentMenuItem.setActionCommand(currentFilePath);
        currentMenuItem.addActionListener(this);
        this.add(currentMenuItem);
    }

    public void actionPerformed(ActionEvent e) {
        try {
            URI sampleFile = new URI(e.getActionCommand());
            if (e.getSource() instanceof JMenuItem) {
                String sampleName = ((JMenuItem)e.getSource()).getText();
                Dimension parentSize = this.parentComponent.getSize();
                Point parentLocation = this.parentComponent.getLocation();
                int offset = 10;
                Rectangle windowRectangle = new Rectangle(parentLocation.x + offset, parentLocation.y + offset, parentSize.width - offset, parentSize.height - offset);
                this.diagramWindowManager.openDiagram(sampleName, sampleFile, false, windowRectangle);
            }
        }
        catch (URISyntaxException exception) {
            BugCatcherManager.getBugCatcher().logError((Exception)exception);
            this.dialogHandler.addMessageDialogToQueue(menus.getString("FAILED TO LOAD SAMPLE"), menus.getString("SAMPLE DIAGRAM"));
        }
        catch (EntityServiceException entityServiceException) {
            this.dialogHandler.addMessageDialogToQueue(MessageFormat.format(menus.getString("FAILED TO LOAD SAMPLE: {0}"), entityServiceException.getMessage()), "Open Diagram Error");
        }
    }
}

