/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.kinnate.ui.relationsettings;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import javax.swing.DefaultCellEditor;
import javax.swing.JColorChooser;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ColourCellEditor
extends DefaultCellEditor
implements ChangeListener {
    private static final ResourceBundle widgets = ResourceBundle.getBundle("nl/mpi/kinoath/localisation/Widgets");
    private AbstractColorChooserPanel colourPickerPanel;
    final JColorChooser colourChooser;
    final JPopupMenu popupMenu;
    final JPanel editorPanel = new JPanel();
    private String cellValue = null;
    private Color currentColour = null;

    public ColourCellEditor(final JTable table) {
        super(new JTextField());
        this.colourChooser = new JColorChooser();
        this.colourPickerPanel = this.colourChooser.getChooserPanels()[0];
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.colourPickerPanel);
        this.colourChooser.setPreviewPanel(new JPanel());
        this.colourChooser.getSelectionModel().addChangeListener(this);
        this.editorPanel.addMouseListener(new MouseListener(){

            public void mouseClicked(MouseEvent e) {
                ColourCellEditor.this.popupMenu.show(table, e.getX(), e.getY());
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseReleased(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }
        });
    }

    public Object getCellEditorValue() {
        return this.cellValue;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        System.out.println("getTableCellEditorComponent");
        try {
            this.currentColour = Color.decode(value.toString());
            this.editorPanel.setBackground(this.currentColour);
            this.cellValue = value.toString();
        }
        catch (NumberFormatException exception) {
            this.currentColour = Color.GRAY;
            this.editorPanel.setBackground(this.currentColour);
            this.cellValue = "#" + Integer.toHexString(Color.GRAY.getRGB()).substring(2);
        }
        this.colourChooser.setColor(this.currentColour);
        return this.editorPanel;
    }

    public void stateChanged(ChangeEvent e) {
        if (this.colourChooser.getColor() != null && this.currentColour != this.colourChooser.getColor()) {
            Color selectedColor = this.colourChooser.getColor();
            this.cellValue = "#" + Integer.toHexString(selectedColor.getRGB()).substring(2);
            this.editorPanel.setBackground(selectedColor);
            this.colourChooser.setColor(null);
            this.popupMenu.setVisible(false);
        }
    }
}

