/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.db_tool;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.handle.apps.db_tool.HandleValuePanel;
import net.handle.awt.AwtUtil;
import net.handle.hdllib.HandleValue;

public class HandleInfoPanel
extends JPanel
implements ActionListener,
ListSelectionListener {
    private JList valueList;
    private DefaultListModel valueListModel = new DefaultListModel();
    private JButton addValueButton;
    private JButton remValueButton;
    private JButton upValueButton;
    private JButton downValueButton;
    private HandleValuePanel valuePanel;
    private HandleValue currentValue = null;

    public HandleInfoPanel() {
        super(new GridBagLayout());
        this.valueList = new JList(this.valueListModel);
        this.addValueButton = new JButton("Add");
        this.remValueButton = new JButton("Remove");
        this.upValueButton = new JButton("^");
        this.downValueButton = new JButton("v");
        this.valuePanel = new HandleValuePanel();
        boolean x = false;
        boolean y = false;
        JPanel tmpPanel = new JPanel(new GridBagLayout());
        tmpPanel.add((Component)new JScrollPane(this.valueList), AwtUtil.getConstraints(0, 0, 1.0, 1.0, 5, 1, true, true));
        tmpPanel.add((Component)this.addValueButton, AwtUtil.getConstraints(0, 1, 1.0, 0.0, 1, 1, true, true));
        tmpPanel.add((Component)this.remValueButton, AwtUtil.getConstraints(1, 1, 1.0, 0.0, 1, 1, true, true));
        tmpPanel.add((Component)this.upValueButton, AwtUtil.getConstraints(3, 1, 1.0, 0.0, 1, 1, true, true));
        tmpPanel.add((Component)this.downValueButton, AwtUtil.getConstraints(4, 1, 1.0, 0.0, 1, 1, true, true));
        this.add((Component)new JLabel("Values: ", 2), AwtUtil.getConstraints(0, 0, 0.0, 0.0, 1, 1, true, true));
        this.add((Component)tmpPanel, AwtUtil.getConstraints(0, 1, 1.0, 1.0, 2, 1, true, true));
        this.add((Component)new JLabel(" "), AwtUtil.getConstraints(0, 2, 1.0, 0.0, 2, 1, true, true));
        this.add((Component)this.valuePanel, AwtUtil.getConstraints(0, 3, 1.0, 0.0, 2, 1, true, true));
        this.valueList.addListSelectionListener(this);
        this.addValueButton.addActionListener(this);
        this.remValueButton.addActionListener(this);
        this.upValueButton.addActionListener(this);
        this.downValueButton.addActionListener(this);
        this.listValueSelected();
    }

    public void setHandleValues(HandleValue[] newValues) {
        this.valueListModel.clear();
        if (newValues != null) {
            for (int i = 0; i < newValues.length; ++i) {
                this.valueListModel.addElement(newValues[i]);
            }
        }
    }

    public HandleValue[] getHandleValues() {
        this.listValueSelected();
        HandleValue[] rootValues = new HandleValue[this.valueListModel.size()];
        for (int i = 0; i < this.valueListModel.size(); ++i) {
            rootValues[i] = (HandleValue)this.valueListModel.elementAt(i);
        }
        return rootValues;
    }

    private void listValueSelected() {
        int newIndex;
        if (this.currentValue != null) {
            this.valuePanel.getHandleValue(this.currentValue);
        }
        if ((newIndex = this.valueList.getSelectedIndex()) < 0 || newIndex >= this.valueListModel.size()) {
            this.valuePanel.setEnabled(false);
            this.currentValue = null;
        } else {
            HandleValue selValue = (HandleValue)this.valueListModel.elementAt(newIndex);
            if (selValue != this.currentValue) {
                System.err.println("new value selected: " + selValue);
                this.currentValue = selValue;
                this.valuePanel.setEnabled(true);
                this.valuePanel.setHandleValue(this.currentValue);
            }
        }
    }

    private void evtAddValue() {
        HandleValue newValue = new HandleValue();
        this.valueListModel.addElement(newValue);
        this.valueList.setSelectedIndex(this.valueListModel.size() - 1);
        this.listValueSelected();
    }

    private void evtRemValue() {
        int idx = this.valueList.getSelectedIndex();
        if (idx < 0) {
            return;
        }
        this.valueListModel.removeElementAt(idx);
        this.listValueSelected();
    }

    private void evtUpValue() {
        int idx = this.valueList.getSelectedIndex();
        if (idx <= 0) {
            return;
        }
        Object value = this.valueListModel.elementAt(idx);
        this.valueListModel.removeElementAt(idx);
        this.valueListModel.insertElementAt(value, idx - 1);
        this.valueList.setSelectedIndex(idx - 1);
    }

    private void evtDownValue() {
        int idx = this.valueList.getSelectedIndex();
        if (idx < 0 || idx == this.valueListModel.size() - 1) {
            return;
        }
        Object value = this.valueListModel.elementAt(idx);
        this.valueListModel.removeElementAt(idx);
        this.valueListModel.insertElementAt(value, idx + 1);
        this.valueList.setSelectedIndex(idx + 1);
    }

    public void valueChanged(ListSelectionEvent evt) {
        if (evt.getSource() == this.valueList) {
            this.listValueSelected();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.addValueButton) {
            this.evtAddValue();
        } else if (src == this.remValueButton) {
            this.evtRemValue();
        } else if (src == this.upValueButton) {
            this.evtUpValue();
        } else if (src == this.downValueButton) {
            this.evtDownValue();
        }
    }
}

