/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.hadmin;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.handle.apps.gui.hadmin.HandleTool;
import net.handle.apps.gui.jutil.HelpPanel;
import net.handle.awt.AwtUtil;
import net.handle.awt.GenericDialog;
import net.handle.hdllib.Common;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.GetSiteInfoResponse;
import net.handle.hdllib.Util;

public class HomeNAWindow
extends JDialog
implements ActionListener {
    private JTextField naField;
    private JTextField addressField;
    private JTextField portField;
    private JButton okButton;
    private JButton cancelButton;
    private JComboBox protocolChoice;
    private JButton changeAuthButton;
    private JButton helpButton;
    private HandleTool tool;

    public HomeNAWindow(HandleTool tool) {
        super(tool, "Home Naming Authority", false);
        this.tool = tool;
        this.naField = new JTextField("0.NA/YOUR_NAMING_AUTHORITY", 20);
        this.naField.setScrollOffset(0);
        this.addressField = new JTextField("Your server address");
        this.addressField.setScrollOffset(0);
        this.portField = new JTextField("2641", 6);
        this.okButton = new JButton("Ok");
        this.cancelButton = new JButton("Cancel");
        this.changeAuthButton = new JButton("Authentication");
        this.helpButton = new JButton("Help");
        this.protocolChoice = new JComboBox();
        this.protocolChoice.addItem("TCP");
        this.protocolChoice.addItem("UDP");
        this.protocolChoice.addItem("HTTP");
        int x = 0;
        int y = 0;
        JPanel p = new JPanel(new GridBagLayout());
        p.add((Component)this.helpButton, AwtUtil.getConstraints(x, y++, 1.0, 0.0, 2, 1, false, false));
        p.add((Component)this.changeAuthButton, AwtUtil.getConstraints(x, y++, 1.0, 0.0, 2, 1, false, false));
        p.add((Component)new JLabel("Primary server address: ", 4), AwtUtil.getConstraints(x, y, 0.0, 1.0, 1, 1, true, false));
        p.add((Component)this.addressField, AwtUtil.getConstraints(x + 1, y++, 1.0, 1.0, 1, 1, true, false));
        p.add((Component)new JLabel("Primary server port: ", 4), AwtUtil.getConstraints(x, y, 0.0, 1.0, 1, 1, true, false));
        p.add((Component)this.portField, AwtUtil.getConstraints(x + 1, y++, 1.0, 1.0, 1, 1, true, false));
        p.add((Component)new JLabel("Naming authority handle: ", 4), AwtUtil.getConstraints(x, y, 0.0, 1.0, 1, 1, true, false));
        p.add((Component)this.naField, AwtUtil.getConstraints(x + 1, y++, 1.0, 1.0, 1, 1, true, false));
        p.add((Component)new JLabel("Interface/Protocol: ", 4), AwtUtil.getConstraints(x, y, 0.0, 1.0, 1, 1, true, false));
        p.add((Component)this.protocolChoice, AwtUtil.getConstraints(x + 1, y++, 1.0, 1.0, 1, 1, true, false));
        JPanel buttonPanel = new JPanel(new GridBagLayout());
        buttonPanel.add((Component)this.okButton, AwtUtil.getConstraints(0, 0, 1.0, 1.0, 1, 1, false, false));
        buttonPanel.add((Component)this.cancelButton, AwtUtil.getConstraints(1, 0, 1.0, 1.0, 1, 1, false, false));
        p.add((Component)buttonPanel, AwtUtil.getConstraints(x, y++, 1.0, 0.0, 2, 1, true, true));
        this.getContentPane().add(p);
        this.changeAuthButton.addActionListener(this);
        this.okButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.helpButton.addActionListener(this);
        this.pack();
        this.setSize(this.getPreferredSize());
        AwtUtil.setWindowPosition((Window)this, tool);
    }

    public void actionPerformed(ActionEvent evt) {
        Object src = evt.getSource();
        if (src == this.okButton) {
            if (this.homeNA()) {
                this.setVisible(false);
            }
        } else if (src == this.cancelButton) {
            this.setVisible(false);
        } else if (src == this.changeAuthButton) {
            this.tool.changeAuthentication();
        } else if (src == this.helpButton) {
            HelpPanel.show(this.tool, "/net/handle/apps/gui/help/en_en", "home_na.html");
        }
    }

    public void setVisible(boolean val) {
        super.setVisible(val);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean homeNA() {
        try {
            svrAddr = InetAddress.getByName(this.addressField.getText().trim());
            svrPort = Integer.parseInt(this.portField.getText().trim());
            naHandle = Util.encodeString(this.naField.getText().trim());
            if (!Util.startsWithCI(naHandle, Common.NA_HANDLE_PREFIX)) {
                throw new Exception("Error: Naming authority handles must start with '" + Util.decodeString(Common.NA_HANDLE_PREFIX) + "'");
            }
            siReq = new GenericRequest(Common.BLANK_HANDLE, 2, null);
            siReq.certify = true;
            response = null;
            try {
                this.tool.resolver.setCheckSignatures(false);
                switch (this.protocolChoice.getSelectedIndex()) {
                    case 0: {
                        response = this.tool.resolver.sendHdlTcpRequest(siReq, svrAddr, svrPort);
                        ** break;
lbl16:
                        // 1 sources

                        break;
                    }
                    case 1: {
                        response = this.tool.resolver.sendHdlUdpRequest(siReq, svrAddr, svrPort);
                        ** break;
lbl20:
                        // 1 sources

                        break;
                    }
                    case 2: {
                        response = this.tool.resolver.sendHttpRequest(siReq, svrAddr, svrPort);
                        ** break;
lbl24:
                        // 1 sources

                        break;
                    }
                    default: {
                        throw new Exception("No protocol selected");
                    }
                }
            }
            finally {
                this.tool.resolver.setCheckSignatures(true);
            }
            siteInfo = null;
            if (response == null || response.responseCode != 1) {
                throw new Exception("Unable to retrieve site information from server");
            }
            siteInfo = ((GetSiteInfoResponse)response).siteInfo;
            if (!siteInfo.isPrimary) {
                throw new Exception("Given server is not a primary server.");
            }
            authInfo = this.tool.getAuthentication();
            if (authInfo == null) {
                return false;
            }
            homeNAReq = new GenericRequest(naHandle, 300, authInfo);
            homeNAReq.majorProtocolVersion = (byte)2;
            homeNAReq.minorProtocolVersion = 0;
            homeNAReq.certify = true;
            for (i = 0; i < siteInfo.servers.length; ++i) {
                response = this.tool.resolver.sendRequestToServer(homeNAReq, siteInfo.servers[i]);
                if (response.responseCode == 1) continue;
                throw new Exception(String.valueOf(response));
            }
            GenericDialog.askQuestion("Success", "The naming authority was successfully homed on\nall servers within the given site.", 0, this);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            GenericDialog.askQuestion("Error", "Error: " + e + "\nPlease try again", 0, this);
            return false;
        }
    }
}

