/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.gui.jutil;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Document;
import net.handle.apps.gui.jutil.MyButton;
import net.handle.awt.AwtUtil;

public class HelpPanel
extends JScrollPane
implements HyperlinkListener {
    protected String titleStr = null;
    protected JEditorPane html = new JEditorPane();
    protected Font font;
    protected URL baseURL;
    protected Document doc = null;
    protected String dir = null;

    public HelpPanel(String dir, String inputFile) {
        if (!dir.endsWith("/")) {
            dir = dir + '/';
        }
        this.dir = dir;
        try {
            this.baseURL = this.getClass().getResource(dir + inputFile);
            this.html.setPage(this.baseURL);
        }
        catch (Exception e) {
            this.baseURL = this.getClass().getResource(dir + "intro.html");
            try {
                this.html.setPage(this.baseURL);
            }
            catch (Exception e1) {
                e1.printStackTrace(System.err);
                this.html.setText(" Not Found");
            }
        }
        this.html.setEditable(false);
        this.html.addHyperlinkListener(this);
        this.html.setMargin(new Insets(10, 10, 10, 10));
        JViewport vp = this.getViewport();
        vp.add(this.html);
        this.setPreferredSize(new Dimension(640, 700));
        this.setMinimumSize(new Dimension(640, 700));
    }

    public void hyperlinkUpdate(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            String newURL = e.getDescription();
            try {
                URL newBaseURL = new URL(this.baseURL, newURL);
                this.linkActived(newBaseURL);
                if (newBaseURL != null) {
                    this.baseURL = newBaseURL;
                } else {
                    newBaseURL = new URL(this.baseURL, "intro.html");
                    if (newBaseURL != null) {
                        this.baseURL = newBaseURL;
                    }
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
                System.err.println("load file: " + this.baseURL);
            }
        }
    }

    protected void linkActived(URL u) {
        Cursor c = this.html.getCursor();
        Cursor waitCursor = Cursor.getPredefinedCursor(3);
        this.html.setCursor(waitCursor);
        SwingUtilities.invokeLater(new PageLoader(u, c));
    }

    public static void show(JFrame parent, String dir, String inputFile) {
        HelpPanel hp = new HelpPanel(dir, inputFile);
        HelpWindow hw = new HelpWindow(parent, hp);
        hw.setVisible(true);
    }

    public static void main(String[] args) {
        final JFrame f = new JFrame();
        MyButton a = new MyButton("oooo");
        a.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HelpPanel.show(f, "/net/handle/apps/gui/help/en_en", "createhandle.html");
            }
        });
        Container c = f.getContentPane();
        JPanel p = new JPanel();
        p.add(a);
        c.add(p);
        f.setSize(200, 200);
        f.pack();
        f.setVisible(true);
    }

    private static class HelpWindow
    extends JDialog
    implements ActionListener {
        private JButton doneButton;

        HelpWindow(JFrame parent, HelpPanel helpPanel) {
            super(parent, "Help", false);
            JPanel mainPanel = new JPanel(new GridBagLayout());
            mainPanel.setBorder(new EmptyBorder(2, 2, 5, 2));
            helpPanel.setBorder(new EmptyBorder(0, 0, 5, 0));
            this.doneButton = new JButton("Close");
            mainPanel.add((Component)helpPanel, AwtUtil.getConstraints(0, 1, 1.0, 1.0, 1, 1, true, true));
            mainPanel.add((Component)this.doneButton, AwtUtil.getConstraints(0, 3, 1.0, 0.0, 1, 1, false, false));
            this.getContentPane().add(mainPanel);
            this.doneButton.addActionListener(this);
            this.setSize(this.getPreferredSize());
            this.setLocation(50, 50);
        }

        public void actionPerformed(ActionEvent evt) {
            this.setVisible(false);
        }
    }

    protected class PageLoader
    implements Runnable {
        URL url;
        Cursor cursor;

        PageLoader(URL u, Cursor c) {
            this.url = u;
            this.cursor = c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (this.url == null) {
                HelpPanel.this.html.setCursor(this.cursor);
                Container parent = HelpPanel.this.html.getParent();
                parent.repaint();
            } else {
                try {
                    HelpPanel.this.doc = HelpPanel.this.html.getDocument();
                    HelpPanel.this.html.setPage(this.url);
                }
                catch (IOException e) {
                    e.printStackTrace(System.err);
                    HelpPanel.this.html.setDocument(HelpPanel.this.doc);
                }
                finally {
                    this.url = null;
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }
}

