/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.test;

import java.io.File;
import java.io.FileInputStream;
import java.util.Hashtable;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.Configuration;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.Interface;
import net.handle.hdllib.SiteInfo;
import net.handle.util.StreamTable;

public class ServerTest {
    private static final String HDL_TCP_CONFIG = "hdl_tcp_config";
    private static final String HDL_HTTP_CONFIG = "hdl_http_config";
    private static final String HDL_UDP_CONFIG = "hdl_udp_config";
    private static final String BIND_ADDRESS = "bind_address";
    private static final String BIND_PORT = "bind_port";
    private static final String SITE_INFO_FILE = "siteinfo.bin";
    private static String TCPBindAddress;
    private static String TCPBindPort;
    private static String HTTPBindAddress;
    private static String HTTPBindPort;
    private static String UDPBindAddress;
    private static String UDPBindPort;
    private static Hashtable hdlTCP;
    private static Hashtable hdlHTTP;
    private static Hashtable hdlUDP;
    private static HandleResolver resolver;
    private static Configuration config;

    public ServerTest(StreamTable config, File configDir) {
        if (config.containsKey(HDL_TCP_CONFIG)) {
            hdlTCP = (StreamTable)config.get(HDL_TCP_CONFIG);
            TCPBindAddress = String.valueOf(hdlTCP.get(BIND_ADDRESS));
            TCPBindPort = String.valueOf(hdlTCP.get(BIND_PORT));
        }
        if (config.containsKey(HDL_HTTP_CONFIG)) {
            hdlHTTP = (StreamTable)config.get(HDL_HTTP_CONFIG);
            HTTPBindAddress = String.valueOf(hdlHTTP.get(BIND_ADDRESS));
            HTTPBindPort = String.valueOf(hdlHTTP.get(BIND_PORT));
        }
        if (config.containsKey(HDL_UDP_CONFIG)) {
            hdlUDP = (StreamTable)config.get(HDL_UDP_CONFIG);
            UDPBindAddress = String.valueOf(hdlUDP.get(BIND_ADDRESS));
            UDPBindPort = String.valueOf(hdlUDP.get(BIND_PORT));
        }
        try {
            SiteInfo site = new SiteInfo();
            File siteInfoFile = new File(configDir, SITE_INFO_FILE);
            if (!siteInfoFile.exists() || !siteInfoFile.canRead()) {
                System.err.println("Missing or inaccessible site info file: " + siteInfoFile.getAbsolutePath());
                System.exit(-1);
            }
            byte[] siteInfoBuf = new byte[(int)siteInfoFile.length()];
            new FileInputStream(siteInfoFile).read(siteInfoBuf);
            Encoder.decodeSiteInfoRecord(siteInfoBuf, 0, site);
            for (int j = 0; j < site.servers.length; ++j) {
                System.out.println("SERVER: " + site.servers[j].getAddressString());
                for (int k = 0; k < site.servers[j].interfaces.length; ++k) {
                    Interface serverInterface = site.servers[j].interfaces[k];
                    try {
                        GenericRequest req = new GenericRequest(Common.BLANK_HANDLE, 2, null);
                        AbstractResponse response = resolver.sendRequestToInterface(req, site.servers[j], serverInterface);
                        System.out.print(Interface.protocolName(serverInterface.protocol));
                        System.out.println(":" + serverInterface.port + "\t\t\t***PASS***");
                        continue;
                    }
                    catch (HandleException t) {
                        System.err.println("Server: " + site.servers[j].getAddressString());
                        System.err.print(Interface.protocolName(serverInterface.protocol));
                        System.err.print(":" + serverInterface.port + "\t\t\t***FAIL***");
                        System.err.println("  " + HandleException.getCodeStr(t.getCode()));
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Invalid site/server specification");
            System.err.println("Test Failed");
            System.exit(-1);
        }
    }

    static {
        resolver = new HandleResolver();
        config = Configuration.defaultConfiguration();
    }
}

