/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.tools;

import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.security.PrivateKey;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.AuthenticationInfo;
import net.handle.hdllib.Common;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.GenericRequest;
import net.handle.hdllib.GetSiteInfoResponse;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.Interface;
import net.handle.hdllib.PublicKeyAuthenticationInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class BackupServer {
    private AuthenticationInfo authInfo = null;
    private InetAddress svrAddress;
    private int svrPort;
    private static byte svrProtocol;
    private static HandleResolver resolver;

    public static void main(String[] argv) throws Exception {
        if (argv.length != 6) {
            System.err.println("Usage: java net.handle.apps.tools.BackupServer [admin-hdl] [admin-idx] [privkey] [svr-address] [svr-port] [svr-protocol]");
            System.exit(-1);
        }
        if (argv[5].equals("UDP")) {
            svrProtocol = 0;
        } else if (argv[5].equals("TCP")) {
            svrProtocol = 1;
        } else if (argv[5].equals("HTTP")) {
            svrProtocol = (byte)2;
        }
        BackupServer.resolver.traceMessages = true;
        AuthenticationInfo auth = BackupServer.createAuth(argv[0].toUpperCase(), argv[1], argv[2]);
        BackupServer bs = new BackupServer(auth);
        bs.doBackup(argv[3], argv[4], svrProtocol, auth);
    }

    public BackupServer(AuthenticationInfo auth) {
        this.authInfo = auth;
    }

    private static AuthenticationInfo createAuth(String adminHdl, String adminIdx, String privatekey) throws Exception {
        File f = new File(privatekey);
        FileInputStream fs = new FileInputStream(f);
        byte[] key = new byte[(int)f.length()];
        int n = 0;
        while (n < key.length) {
            key[n++] = (byte)fs.read();
        }
        fs.read(key);
        byte[] seckey = null;
        if (Util.requiresSecretKey(key)) {
            seckey = Util.getPassphrase("Please enter your passphrase:");
        }
        key = Util.decrypt(key, seckey);
        PrivateKey privkey = Util.getPrivateKeyFromBytes(key, 0);
        return new PublicKeyAuthenticationInfo(adminHdl.getBytes("UTF8"), Integer.parseInt(adminIdx), privkey);
    }

    public void doBackup(String addr, String port, byte svrProtocol, AuthenticationInfo auth) {
        try {
            InetAddress svrAddr = InetAddress.getByName(addr);
            int svrPort = Integer.parseInt(port);
            GenericRequest siReq = new GenericRequest(Common.BLANK_HANDLE, 2, null);
            AbstractResponse response = null;
            System.err.println("\nGetting site values for: " + addr + "..");
            switch (svrProtocol) {
                case 0: {
                    response = resolver.sendHdlUdpRequest(siReq, svrAddr, svrPort);
                    break;
                }
                case 1: {
                    response = resolver.sendHdlTcpRequest(siReq, svrAddr, svrPort);
                    break;
                }
                case 2: {
                    response = resolver.sendHttpRequest(siReq, svrAddr, svrPort);
                    break;
                }
                default: {
                    throw new Exception("No protocol specified");
                }
            }
            SiteInfo siteInfo = null;
            if (response == null || response.responseCode != 1) {
                throw new Exception("Unable to retrieve site information from server.");
            }
            siteInfo = ((GetSiteInfoResponse)response).siteInfo;
            if (!siteInfo.isPrimary) {
                throw new Exception("Given server is not a primary server.");
            }
            if (auth == null) {
                System.err.println("Authentication value is null. Please try again.");
            }
            GenericRequest backupReq = new GenericRequest(Common.BLANK_HANDLE, 1003, auth);
            if (siteInfo.majorProtocolVersion == 5 && siteInfo.minorProtocolVersion == 0 || siteInfo.majorProtocolVersion < 2 || siteInfo.majorProtocolVersion == 2 && siteInfo.minorProtocolVersion < 1) {
                backupReq.majorProtocolVersion = siteInfo.majorProtocolVersion;
                backupReq.minorProtocolVersion = siteInfo.minorProtocolVersion;
            } else {
                backupReq.majorProtocolVersion = (byte)2;
                backupReq.minorProtocolVersion = 1;
            }
            backupReq.certify = true;
            String respStr = null;
            response = null;
            block7: for (int i = 0; i < siteInfo.servers.length; ++i) {
                if (!siteInfo.servers[i].getInetAddress().equals(svrAddr)) continue;
                for (int j = 0; j < siteInfo.servers[i].interfaces.length; ++j) {
                    Interface interf = siteInfo.servers[i].interfaces[j];
                    if (interf.port != svrPort || interf.protocol != svrProtocol) continue;
                    System.err.println("\nSending backup request to server: " + siteInfo.servers[i] + " ..");
                    response = resolver.sendRequestToServer(backupReq, siteInfo.servers[i]);
                    if (response == null) {
                        respStr = "There was no response to the server backup request.\n";
                    } else {
                        if (response.responseCode == 1) {
                            System.err.println("\nThe server is performing backup.\n");
                            continue block7;
                        }
                        respStr = response instanceof ErrorResponse ? String.valueOf(response) : response.getClass().getName() + "( " + String.valueOf(response.responseCode) + "): " + AbstractMessage.getResponseCodeMessage(response.responseCode);
                    }
                    System.err.println("Can not process the backup request for server: " + siteInfo.servers[i] + "\n" + response);
                    System.exit(-1);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error backing up server:\n" + e.getMessage() + "\nTry again please.");
            e.printStackTrace(System.err);
        }
    }

    static {
        resolver = new HandleResolver();
    }
}

