/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.tools;

import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileInputStream;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.border.Border;
import net.handle.apps.gui.jwidget.SiteDataJPanel;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.HandleValue;

public class SiteInfoEditor {
    static String USAGE = "Usage: java net.handle.apps.tools.SiteInfoEditor <siteinfo file | NA handle>";

    public static void main(String[] argv) {
        JFrame frame = new JFrame("Site Info Editor");
        frame.setJMenuBar(new JMenuBar());
        JMenu menu = new JMenu("File");
        JMenuItem i = new JMenuItem("Exit");
        i.addActionListener(new AbstractAction("Exit"){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        menu.add(i);
        frame.getJMenuBar().add(menu);
        SiteDataJPanel p = new SiteDataJPanel(true, true);
        frame.getContentPane().add(p);
        Border border = BorderFactory.createEmptyBorder(15, 15, 15, 15);
        p.setBorder(border);
        frame.pack();
        frame.setVisible(true);
        frame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
        if (argv.length > 0) {
            if (argv[0].startsWith("--h") || argv[0].startsWith("-h")) {
                System.err.println(USAGE);
                System.exit(-1);
            }
            if (argv[0].toUpperCase().startsWith("0.NA")) {
                String[] s = new String[]{"HS_SITE"};
                try {
                    HandleValue[] v = new HandleResolver().resolveHandle(argv[0], s, null);
                    if (v == null || v.length == 0) {
                        throw new Exception("HS_SITE not found.");
                    }
                    p.setValueData(v[0].getData());
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(frame, "Can't load NA " + argv[0] + ": " + e, "Error", 0);
                }
            } else {
                try {
                    File f = new File(argv[0]);
                    byte[] buf = new byte[(int)f.length()];
                    new FileInputStream(f).read(buf);
                    p.setValueData(buf);
                }
                catch (Exception e) {
                    JOptionPane.showMessageDialog(frame, "Can't load file " + argv[0] + ": " + e, "Error", 0);
                }
            }
        }
    }
}

