/*
 * Decompiled with CFR 0.152.
 */
package net.handle.apps.tools;

import java.io.File;
import java.util.Enumeration;
import net.handle.hdllib.SiteInfo;
import net.handle.jdb.DBHash;

public class SplitServer {
    private DBHash[] destDBs;
    private DBHash origDB;
    private int numDBs;

    public static void main(String[] argv) throws Exception {
        if (argv.length < 3) {
            System.err.println("usage: java net.handle.apps.tools.SplitServer <sourcefile> <destdir1> <destdir2> ...");
            return;
        }
        SplitServer splitServer = new SplitServer(argv);
        splitServer.doit();
        splitServer.cleanup();
    }

    SplitServer(String[] argv) throws Exception {
        File origFile = new File(argv[0]);
        if (!origFile.canRead()) {
            throw new Exception("Unable to read database file: " + origFile);
        }
        System.err.println("loading source DB...");
        this.origDB = new DBHash(origFile, 5000, 1000);
        this.numDBs = argv.length - 1;
        this.destDBs = new DBHash[this.numDBs];
        for (int i = 0; i < this.destDBs.length; ++i) {
            System.err.println("loading dest db: " + argv[i + 1]);
            this.destDBs[i] = new DBHash(new File(argv[i + 1], "handles.jdb"), 5000, 1000);
        }
    }

    final void doit() throws Exception {
        for (int i = 0; i < this.destDBs.length; ++i) {
            this.destDBs[i].deleteAllRecords();
        }
        Enumeration enumeration = this.origDB.getEnumerator();
        byte[][] record = null;
        while (enumeration.hasMoreElements()) {
            record = (byte[][])enumeration.nextElement();
            this.destDBs[SiteInfo.determineServerNum(record[0], 2, this.numDBs)].setValue(record[0], record[1]);
        }
    }

    void cleanup() throws Exception {
        this.origDB.close();
        for (int i = 0; i < this.destDBs.length; ++i) {
            this.destDBs[i].close();
        }
    }
}

