/*
 * Decompiled with CFR 0.152.
 */
package net.handle.dnslib;

import java.io.File;
import java.util.Date;
import java.util.Enumeration;
import net.handle.dnslib.DNSMessage;
import net.handle.jdb.DBHash;

public class DNSCache
implements Runnable {
    private String messageDBFile = "dns_cache.jdb";
    private DBHash messageTable = null;
    private Thread cacheThread = null;
    private static final long defaultTTL = 86400L;
    private static DNSCache staticInstance = null;

    public static synchronized DNSCache getInstance(String cacheFile) throws Exception {
        if (staticInstance == null) {
            staticInstance = new DNSCache(cacheFile);
        }
        return staticInstance;
    }

    public DNSCache(String cacheFile) throws Exception {
        this.messageDBFile = cacheFile;
        this.messageTable = new DBHash(new File(this.messageDBFile), 2000, 1000);
        this.cacheThread = new Thread(this);
        this.cacheThread.start();
    }

    public DNSMessage getDNSMessage(String dnsName, int dnsType, int dnsClass) throws Exception {
        dnsName = dnsName.toUpperCase();
        try {
            byte[] tmp = dnsName.toUpperCase().getBytes();
            byte[] bkey = new byte[tmp.length + 4];
            System.arraycopy(tmp, 0, bkey, 0, tmp.length);
            bkey[tmp.length + 0] = (byte)((dnsType & 0xFF00) >> 8);
            bkey[tmp.length + 1] = (byte)(dnsType & 0xFF);
            bkey[tmp.length + 2] = (byte)((dnsClass & 0xFF00) >> 8);
            bkey[tmp.length + 3] = (byte)(dnsClass & 0xFF);
            byte[] results = this.messageTable.getValue(bkey);
            if (results != null) {
                return new DNSMessage(results, 0, results.length - 8);
            }
        }
        catch (Exception e) {
            System.err.println("Exception getting dns message: " + e);
            e.printStackTrace(System.err);
        }
        return null;
    }

    public void setMessageData(String dnsName, int dnsType, int dnsClass, DNSMessage dnsMessage) throws Exception {
        dnsName = dnsName.toUpperCase();
        byte[] tmp = dnsName.getBytes();
        byte[] bkey = new byte[tmp.length + 4];
        System.arraycopy(tmp, 0, bkey, 0, tmp.length);
        bkey[tmp.length + 0] = (byte)((dnsType & 0xFF00) >> 8);
        bkey[tmp.length + 1] = (byte)(dnsType & 0xFF);
        bkey[tmp.length + 2] = (byte)((dnsClass & 0xFF00) >> 8);
        bkey[tmp.length + 3] = (byte)(dnsClass & 0xFF);
        byte[] tmpMessage = dnsMessage.getPacketBuffer();
        byte[] message = new byte[tmpMessage.length + 8];
        System.arraycopy(tmpMessage, 0, message, 0, tmpMessage.length);
        long currentTime = new Date().getTime() / 1000L;
        int dateoffset = tmpMessage.length;
        message[dateoffset + 0] = (byte)(currentTime >>> 56 & 0xFFL);
        message[dateoffset + 1] = (byte)(currentTime >>> 48 & 0xFFL);
        message[dateoffset + 2] = (byte)(currentTime >>> 40 & 0xFFL);
        message[dateoffset + 3] = (byte)(currentTime >>> 32 & 0xFFL);
        message[dateoffset + 4] = (byte)(currentTime >>> 24 & 0xFFL);
        message[dateoffset + 5] = (byte)(currentTime >>> 16 & 0xFFL);
        message[dateoffset + 6] = (byte)(currentTime >>> 8 & 0xFFL);
        message[dateoffset + 7] = (byte)(currentTime & 0xFFL);
        this.messageTable.setValue(bkey, message);
        this.sync();
    }

    public void sync() {
    }

    private void purgeOldRecords() {
        try {
            Enumeration enumeration = this.messageTable.getEnumerator();
            while (enumeration.hasMoreElements()) {
                try {
                    byte[][] keydata = (byte[][])enumeration.nextElement();
                    byte[] key = keydata[0];
                    byte[] data = keydata[1];
                    DNSMessage message = new DNSMessage(data, 0, data.length - 8);
                    if (message.answers == null || message.answers.length <= 0) {
                        this.messageTable.deleteValue(key);
                        continue;
                    }
                    int dateoffset = data.length - 8;
                    long currentTime = new Date().getTime() / 1000L;
                    long insertionTime = ((long)data[dateoffset + 0] & 0xFFL) << 56 | ((long)data[dateoffset + 1] & 0xFFL) << 48 | ((long)data[dateoffset + 2] & 0xFFL) << 40 | ((long)data[dateoffset + 3] & 0xFFL) << 32 | ((long)data[dateoffset + 4] & 0xFFL) << 24 | ((long)data[dateoffset + 5] & 0xFFL) << 16 | ((long)data[dateoffset + 6] & 0xFFL) << 8 | (long)data[dateoffset + 7] & 0xFFL;
                    long minTimeout = message.answers[0].ttl;
                    for (int i = 1; i < message.answers.length; ++i) {
                        if (minTimeout >= (long)message.answers[i].ttl) continue;
                        minTimeout = message.answers[i].ttl;
                    }
                    if (insertionTime + minTimeout >= currentTime) continue;
                    this.messageTable.deleteValue(key);
                    this.sync();
                }
                catch (Exception e) {
                    System.err.println("Exception checking record TTL: " + e);
                    e.printStackTrace(System.err);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Exception scanning records to purge: " + e);
            e.printStackTrace(System.err);
        }
    }

    public void run() {
        while (true) {
            try {
                this.purgeOldRecords();
            }
            catch (Throwable t) {
                System.err.println("Exception in cache thread: " + t);
                t.printStackTrace(System.err);
            }
            try {
                Thread.currentThread();
                Thread.sleep(60000L);
                continue;
            }
            catch (Throwable t) {
                System.err.println("Exception in cache thread: " + t);
                t.printStackTrace(System.err);
                continue;
            }
            break;
        }
    }

    public void shutdown() {
        try {
            this.messageTable.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

