/*
 * Decompiled with CFR 0.152.
 */
package net.handle.dnslib;

import java.io.PrintStream;
import java.util.Hashtable;
import net.handle.dnslib.DNSQuestion;
import net.handle.dnslib.DNSResourceRecord;

public class DNSMessage {
    public static final byte OP_QUERY = 0;
    public static final byte OP_IQUERY = 1;
    public static final byte OP_STATUS = 2;
    public static final byte RC_OK = 0;
    public static final byte RC_FORMAT_ERROR = 2;
    public static final byte RC_NAME_ERROR = 3;
    public static final byte RC_NOT_IMPLEMENTED = 4;
    public static final byte RC_REFUSED = 5;
    public static final int TYPE_A = 1;
    public static final int TYPE_NS = 2;
    public static final int TYPE_MD = 3;
    public static final int TYPE_MF = 4;
    public static final int TYPE_CNAME = 5;
    public static final int TYPE_SOA = 6;
    public static final int TYPE_MB = 7;
    public static final int TYPE_MG = 8;
    public static final int TYPE_MR = 9;
    public static final int TYPE_NULL = 10;
    public static final int TYPE_WKS = 11;
    public static final int TYPE_PTR = 12;
    public static final int TYPE_HINFO = 13;
    public static final int TYPE_MINFO = 14;
    public static final int TYPE_MX = 15;
    public static final int TYPE_TXT = 16;
    public static final int CLASS_IN = 1;
    public static final int CLASS_CS = 2;
    public static final int CLASS_CH = 3;
    public static final int CLASS_HS = 4;
    public char id;
    public boolean isQuery;
    public byte opcode;
    public boolean authAnswer;
    public boolean truncated;
    public boolean recursionDesired;
    public boolean recursionAvailable;
    public byte responseCode;
    public DNSQuestion[] questions;
    public DNSResourceRecord[] answers;
    public DNSResourceRecord[] nameServers;
    public DNSResourceRecord[] additionalResources;
    private byte[] packetBuffer = null;

    public DNSMessage() {
    }

    public DNSMessage(byte[] buf, int offset, int length) {
        int i;
        this.packetBuffer = new byte[length];
        System.arraycopy(buf, offset, this.packetBuffer, 0, length);
        this.id = (char)((buf[offset++] & 0xFF) << 8);
        this.id = (char)(this.id | buf[offset++] & 0xFF);
        this.isQuery = (buf[offset] & 0x80) != 0;
        this.opcode = (byte)(buf[offset] >>> 3 & 0xF);
        this.authAnswer = (buf[offset] & 4) != 0;
        this.truncated = (buf[offset] & 2) != 0;
        this.recursionDesired = (buf[offset++] & 1) != 0;
        this.recursionAvailable = (buf[offset] & 0x80) != 0;
        this.responseCode = (byte)(buf[offset++] & 0xF);
        int numQ = (buf[offset++] & 0xFF) << 8;
        if ((numQ |= buf[offset++] & 0xFF) < 0 || numQ > 256) {
            System.err.println("Error:  invalid number of questions: " + numQ);
            return;
        }
        int numA = (buf[offset++] & 0xFF) << 8;
        if ((numA |= buf[offset++] & 0xFF) < 0 || numA > 256) {
            System.err.println("Error:  invalid number of answers: " + numA);
            return;
        }
        int numNS = (buf[offset++] & 0xFF) << 8;
        if ((numNS |= buf[offset++] & 0xFF) < 0 || numNS > 256) {
            System.err.println("Error:  invalid number of NS's: " + numNS);
            return;
        }
        int numAR = (buf[offset++] & 0xFF) << 8;
        if ((numAR |= buf[offset++] & 0xFF) < 0 || numAR > 256) {
            System.err.println("Error:  invalid number of additional resources: " + numAR);
            return;
        }
        this.questions = new DNSQuestion[numQ];
        this.answers = new DNSResourceRecord[numA];
        this.nameServers = new DNSResourceRecord[numNS];
        this.additionalResources = new DNSResourceRecord[numAR];
        for (i = 0; i < numQ; ++i) {
            this.questions[i] = new DNSQuestion();
            offset += this.questions[i].decode(buf, offset);
        }
        for (i = 0; i < numA; ++i) {
            this.answers[i] = new DNSResourceRecord();
            offset += this.answers[i].decode(buf, offset);
        }
        for (i = 0; i < numNS; ++i) {
            this.nameServers[i] = new DNSResourceRecord();
            offset += this.nameServers[i].decode(buf, offset);
        }
        for (i = 0; i < numAR; ++i) {
            this.additionalResources[i] = new DNSResourceRecord();
            offset += this.additionalResources[i].decode(buf, offset);
        }
    }

    public void setDirty() {
        this.packetBuffer = null;
    }

    public synchronized byte[] getPacketBuffer() {
        if (this.packetBuffer != null) {
            return this.packetBuffer;
        }
        return this.buildPacketBuffer();
    }

    public synchronized byte[] buildPacketBuffer() {
        if (this.questions == null) {
            this.questions = new DNSQuestion[0];
        }
        if (this.answers == null) {
            this.answers = new DNSResourceRecord[0];
        }
        if (this.nameServers == null) {
            this.nameServers = new DNSResourceRecord[0];
        }
        if (this.additionalResources == null) {
            this.additionalResources = new DNSResourceRecord[0];
        }
        int msgSize = 1024;
        this.packetBuffer = new byte[msgSize];
        Hashtable nameTable = new Hashtable();
        try {
            int i;
            int loc = 0;
            this.packetBuffer[loc++] = (byte)((this.id & 0xFF00) >> 8);
            this.packetBuffer[loc++] = (byte)(this.id & 0xFF);
            this.packetBuffer[loc++] = (byte)((this.isQuery ? 128 : 0) | (this.opcode & 0xF) << 3 | (this.authAnswer ? 4 : 0) | (this.truncated ? 2 : 0) | (this.recursionDesired ? 1 : 0));
            this.packetBuffer[loc++] = (byte)((this.recursionAvailable ? 128 : 0) | this.responseCode & 0xF);
            this.packetBuffer[loc++] = (byte)((this.questions.length & 0xFF00) >> 8);
            this.packetBuffer[loc++] = (byte)(this.questions.length & 0xFF);
            this.packetBuffer[loc++] = (byte)((this.answers.length & 0xFF00) >> 8);
            this.packetBuffer[loc++] = (byte)(this.answers.length & 0xFF);
            this.packetBuffer[loc++] = (byte)((this.nameServers.length & 0xFF00) >> 8);
            this.packetBuffer[loc++] = (byte)(this.nameServers.length & 0xFF);
            this.packetBuffer[loc++] = (byte)((this.additionalResources.length & 0xFF00) >> 8);
            this.packetBuffer[loc++] = (byte)(this.additionalResources.length & 0xFF);
            for (i = 0; i < this.questions.length; ++i) {
                loc += this.questions[i].encode(this.packetBuffer, loc, nameTable);
            }
            for (i = 0; i < this.answers.length; ++i) {
                loc += this.answers[i].encode(this.packetBuffer, loc, nameTable);
            }
            for (i = 0; i < this.nameServers.length; ++i) {
                loc += this.nameServers[i].encode(this.packetBuffer, loc, nameTable);
            }
            for (i = 0; i < this.additionalResources.length; ++i) {
                loc += this.additionalResources[i].encode(this.packetBuffer, loc, nameTable);
            }
        }
        catch (IndexOutOfBoundsException e) {
            this.packetBuffer[2] = (byte)(this.packetBuffer[2] | 2);
        }
        return this.packetBuffer;
    }

    public void printValues(PrintStream out) {
        int i;
        out.println(" id=" + this.id);
        out.println(" isQuery=" + this.isQuery);
        out.println(" opcode=" + this.opcode);
        out.println(" authAnswer=" + this.authAnswer);
        out.println(" truncated=" + this.truncated);
        out.println(" recursionDesired=" + this.recursionDesired);
        out.println(" recursionAvailable=" + this.recursionAvailable);
        out.println(" responseCode=" + this.responseCode);
        out.println(" QUESTIONS:");
        for (i = 0; i < this.questions.length; ++i) {
            this.questions[i].printValues(out);
        }
        out.println(" ANSWERS:");
        for (i = 0; i < this.answers.length; ++i) {
            this.answers[i].printValues(out);
        }
        out.println(" NAMESERVERS:");
        for (i = 0; i < this.nameServers.length; ++i) {
            this.nameServers[i].printValues(out);
        }
        out.println(" ADDITIONAL RESOURCES:");
        for (i = 0; i < this.additionalResources.length; ++i) {
            this.additionalResources[i].printValues(out);
        }
    }
}

