/*
 * Decompiled with CFR 0.152.
 */
package net.handle.dnslib;

import java.util.Hashtable;
import java.util.Vector;
import net.handle.dnslib.DNSResolver;
import net.handle.dnslib.DNSResourceData;
import net.handle.dnslib.DNSResourceRecord;

public class DNSResourceSOAData
extends DNSResourceData {
    protected String[] pnsName;
    protected String[] rName;
    protected long serial;
    protected long refresh;
    protected long retry;
    protected long expire;
    protected long minimum;

    public DNSResourceSOAData() {
        this.pnsName = new String[0];
        this.rName = new String[0];
        this.serial = 0L;
        this.refresh = 86400L;
        this.retry = 3600L;
        this.expire = 172800L;
        this.minimum = 3600L;
    }

    public DNSResourceSOAData(byte[] data, int offset, int length) {
        this.decodeData(data, offset, length);
    }

    public void decodeData(byte[] data, int offset, int length) {
        int i;
        Vector names = new Vector();
        offset += DNSResourceRecord.readNameFromPointer(data, offset, names);
        this.pnsName = new String[names.size()];
        for (i = 0; i < this.pnsName.length; ++i) {
            this.pnsName[i] = (String)names.elementAt(i);
        }
        names.removeAllElements();
        offset += DNSResourceRecord.readNameFromPointer(data, offset, names);
        this.rName = new String[names.size()];
        for (i = 0; i < this.rName.length; ++i) {
            this.rName[i] = (String)names.elementAt(i);
        }
        this.serial = 0L;
        this.serial |= (long)((data[offset++] & 0xFF) << 24);
        this.serial |= (long)((data[offset++] & 0xFF) << 16);
        this.serial |= (long)((data[offset++] & 0xFF) << 8);
        this.serial |= (long)(data[offset++] & 0xFF);
        this.refresh = (data[offset++] & 0xFF) << 24;
        this.refresh |= (long)((data[offset++] & 0xFF) << 16);
        this.refresh |= (long)((data[offset++] & 0xFF) << 8);
        this.refresh |= (long)(data[offset++] & 0xFF);
        this.retry = (data[offset++] & 0xFF) << 24;
        this.retry |= (long)((data[offset++] & 0xFF) << 16);
        this.retry |= (long)((data[offset++] & 0xFF) << 8);
        this.retry |= (long)(data[offset++] & 0xFF);
        this.expire = (data[offset++] & 0xFF) << 24;
        this.expire |= (long)((data[offset++] & 0xFF) << 16);
        this.expire |= (long)((data[offset++] & 0xFF) << 8);
        this.expire |= (long)(data[offset++] & 0xFF);
        this.minimum = (data[offset++] & 0xFF) << 24;
        this.minimum |= (long)((data[offset++] & 0xFF) << 16);
        this.minimum |= (long)((data[offset++] & 0xFF) << 8);
        this.minimum |= (long)(data[offset++] & 0xFF);
    }

    public int encodeData(byte[] data, int location, Hashtable nameTable) {
        int origLoc = location;
        location += DNSResourceRecord.writeNameToPointer(this.pnsName, data, location, nameTable);
        location += DNSResourceRecord.writeNameToPointer(this.rName, data, location, nameTable);
        data[location++] = (byte)((this.serial & 0xFFFFFFFFFF000000L) >> 24);
        data[location++] = (byte)((this.serial & 0xFF0000L) >> 16);
        data[location++] = (byte)((this.serial & 0xFF00L) >> 8);
        data[location++] = (byte)(this.serial & 0xFFL);
        data[location++] = (byte)((this.refresh & 0xFFFFFFFFFF000000L) >> 24);
        data[location++] = (byte)((this.refresh & 0xFF0000L) >> 16);
        data[location++] = (byte)((this.refresh & 0xFF00L) >> 8);
        data[location++] = (byte)(this.refresh & 0xFFL);
        data[location++] = (byte)((this.retry & 0xFFFFFFFFFF000000L) >> 24);
        data[location++] = (byte)((this.retry & 0xFF0000L) >> 16);
        data[location++] = (byte)((this.retry & 0xFF00L) >> 8);
        data[location++] = (byte)(this.retry & 0xFFL);
        data[location++] = (byte)((this.expire & 0xFFFFFFFFFF000000L) >> 24);
        data[location++] = (byte)((this.expire & 0xFF0000L) >> 16);
        data[location++] = (byte)((this.expire & 0xFF00L) >> 8);
        data[location++] = (byte)(this.expire & 0xFFL);
        data[location++] = (byte)((this.minimum & 0xFFFFFFFFFF000000L) >> 24);
        data[location++] = (byte)((this.minimum & 0xFF0000L) >> 16);
        data[location++] = (byte)((this.minimum & 0xFF00L) >> 8);
        data[location++] = (byte)(this.minimum & 0xFFL);
        return location - origLoc;
    }

    public String toString() {
        return "primary NS: " + DNSResolver.convertDNSNameToString(this.pnsName) + "\n   contact: " + DNSResolver.convertDNSNameToString(this.rName) + "\n    serial: " + this.serial + "\n   refresh: " + this.refresh + "\n     retry: " + this.retry + "\n    expire: " + this.expire + "\n   minimum: " + this.minimum;
    }
}

