/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.PublicKey;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.Interface;
import net.handle.hdllib.Util;

public class ServerInfo {
    public int serverId;
    public byte[] ipAddress;
    public byte[] publicKey;
    public Interface[] interfaces;
    private String addrString = null;

    public Interface interfaceWithProtocol(int desiredProtocol, AbstractRequest req) {
        for (int i = 0; i < this.interfaces.length; ++i) {
            if (this.interfaces[i].protocol != desiredProtocol || !this.interfaces[i].canHandleRequest(req)) continue;
            return this.interfaces[i];
        }
        return null;
    }

    public InetAddress getInetAddress() throws UnknownHostException {
        return InetAddress.getByName(this.getAddressString());
    }

    public String getAddressString() {
        int i;
        if (this.addrString != null) {
            return this.addrString;
        }
        StringBuffer sb = new StringBuffer();
        if (this.ipAddress == null) {
            return "";
        }
        boolean ipv6 = false;
        int IPV6_ONLY = 12;
        for (i = 0; i < IPV6_ONLY; ++i) {
            if (this.ipAddress[i] == 0) continue;
            ipv6 = true;
            break;
        }
        if (ipv6) {
            for (i = 0; i < this.ipAddress.length; i += 2) {
                if (sb.length() > 0) {
                    sb.append(':');
                }
                sb.append(Util.decodeHexString(this.ipAddress, i, i + 2, false));
            }
        } else {
            for (i = IPV6_ONLY; i < this.ipAddress.length; ++i) {
                if (sb.length() > 0) {
                    sb.append('.');
                }
                sb.append(0xFF & this.ipAddress[i]);
            }
        }
        this.addrString = sb.toString();
        return this.addrString;
    }

    public String toString() {
        return String.valueOf(this.serverId) + ' ' + this.getAddressString();
    }

    public PublicKey getPublicKey() throws Exception {
        return Util.getPublicKeyFromBytes(this.publicKey, 0);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ServerInfo)) {
            return false;
        }
        ServerInfo info = (ServerInfo)obj;
        if (this.serverId != info.serverId) {
            return false;
        }
        if (!Util.equals(info.ipAddress, this.ipAddress)) {
            return false;
        }
        if (this.interfaces == null && info.interfaces == null) {
            return true;
        }
        if (this.interfaces == null && info.interfaces != null) {
            return false;
        }
        if (this.interfaces != null && info.interfaces == null) {
            return false;
        }
        if (this.interfaces.length != info.interfaces.length) {
            return false;
        }
        for (int i = 0; i < this.interfaces.length; ++i) {
            if (this.interfaces[i].equals(info.interfaces[i])) continue;
            return false;
        }
        return true;
    }
}

