/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib;

import java.io.File;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.Vector;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.HandleResolver;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.ServerInfo;
import net.handle.hdllib.SiteInfo;
import net.handle.hdllib.Util;

public class SessionTester {
    private HandleResolver resolver;
    private static int testerCount = 0;
    private long startTime;
    private long endTime;
    private int successes = 0;
    private int failures = 0;
    static /* synthetic */ Class class$net$handle$hdllib$ResolutionResponse;

    public static void main(String[] argv) throws Exception {
        if (argv.length < 1) {
            System.err.println("Usage:  java net.handle.hdllib.SessionTester <handle> <#queries/thread> <#threads> <site_info_file>");
            return;
        }
        String handle = argv[0];
        int queries = argv.length > 1 ? Integer.parseInt(argv[1]) : 1000;
        int threads = argv.length > 2 ? Integer.parseInt(argv[2]) : 20;
        File siteInfoFile = argv.length > 3 ? new File(argv[3]) : null;
        HandleResolver resolver = new HandleResolver();
        SessionTester tester = new SessionTester(resolver);
        System.err.println("Site info file: " + siteInfoFile);
        if (siteInfoFile != null) {
            byte[] buf = new byte[(int)siteInfoFile.length()];
            int r = 0;
            FileInputStream fin = new FileInputStream(siteInfoFile);
            for (int n = 0; n < buf.length && (r = fin.read(buf, n, buf.length - n)) >= 0; n += r) {
            }
            SiteInfo site = new SiteInfo();
            Encoder.decodeSiteInfoRecord(buf, 0, site);
            resolver.getConfiguration().setCacheSites(new SiteInfo[]{site});
            resolver.getConfiguration().setResolutionMethod(1);
        }
        tester.doTests(handle, queries, threads);
    }

    public SessionTester(HandleResolver resolver) {
        this.resolver = resolver;
    }

    public void doTests(String handle, int queries, int threads) throws Exception {
        int i;
        this.resolver.traceMessages = true;
        ResolutionRequest req = new ResolutionRequest(Util.encodeString(handle), null, null, null);
        req.ignoreRestrictedValues = true;
        AbstractResponse response = this.resolver.processRequest(req);
        System.err.println("got response: " + response);
        if (!(response instanceof ResolutionResponse)) {
            System.err.println(" aborting tests");
            return;
        }
        System.err.println(" number of values: " + ((ResolutionResponse)response).values.length);
        Vector<SubTester> testers = new Vector<SubTester>();
        Vector<Thread> threadV = new Vector<Thread>();
        System.err.println("\nQuerying " + handle + " with " + threads + " threads, each performing " + queries + " queries");
        this.resolver.traceMessages = false;
        for (i = 0; i < threads; ++i) {
            SubTester t = new SubTester(this.resolver, handle, queries, i, threads);
            testers.addElement(t);
            Thread th = new Thread(t);
            threadV.addElement(th);
            ++testerCount;
        }
        this.startTime = System.currentTimeMillis();
        for (i = 0; i < threads; ++i) {
            ((Thread)threadV.elementAt(i)).start();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class SubTester
    implements Runnable {
        private ResolutionRequest req;
        private ServerInfo server;
        private InetAddress addr;
        private HandleResolver resolver;
        private SiteInfo[] sites;
        private int threadNum;
        private int queries;
        private int numThreads;

        public SubTester(HandleResolver resolver, String handle, int queries, int threadNum, int numThreads) throws Exception {
            this.resolver = resolver;
            this.queries = queries;
            this.threadNum = threadNum;
            this.numThreads = numThreads;
            this.req = new ResolutionRequest(Util.encodeString(handle), null, null, null);
            this.sites = resolver.findLocalSites(this.req);
        }

        public void run() {
            for (int i = 0; i < this.queries; ++i) {
                try {
                    AbstractResponse resp = this.resolver.processRequest(this.req);
                    if (resp.getClass() == (class$net$handle$hdllib$ResolutionResponse == null ? SessionTester.class$("net.handle.hdllib.ResolutionResponse") : class$net$handle$hdllib$ResolutionResponse)) {
                        SessionTester.this.successes++;
                        continue;
                    }
                    System.err.println("Error: " + this.threadNum + ':' + i + ": got unexpected response: " + resp);
                    SessionTester.this.failures++;
                    continue;
                }
                catch (Exception e) {
                    SessionTester.this.failures++;
                    System.err.println("Error: " + this.threadNum + ':' + i + ": " + e);
                }
            }
            testerCount--;
            if (testerCount == 0) {
                SessionTester.this.endTime = System.currentTimeMillis();
                long time = SessionTester.this.endTime - SessionTester.this.startTime;
                System.err.println("  milliseconds: " + time + "\n" + "  seconds: " + time / 1000L + "\n" + "  req/second: " + (double)(this.numThreads * this.queries) / (double)time * 1000.0 + "\n" + "  successes: " + SessionTester.this.successes + "\n" + "  failures: " + SessionTester.this.failures);
            }
        }
    }
}

