/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib4;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import net.handle.hdllib4.HandleException;
import net.handle.hdllib4.QueryOptions;
import net.handle.hdllib4.XdrDecoder;
import net.handle.hdllib4.XdrEncoder;
import net.handle.hdllib4.XdrEncodingException;

public class HandleRequestPacket {
    public long version;
    public long sessionTag;
    public long command;
    public long sequenceNumber;
    public long numberOfPackets;
    public long errorCode;
    public long bodyLength;
    public String handle;
    public QueryOptions options;
    public long[] typesWanted;
    public int returnPort;
    public byte[] returnAddress;

    public HandleRequestPacket(byte[] buf, int offset, int length) throws IOException, XdrEncodingException, UnsupportedEncodingException {
        XdrDecoder decoder = new XdrDecoder(buf, offset, length);
        this.version = decoder.readUnsignedInt();
        this.sessionTag = decoder.readUnsignedInt();
        this.command = decoder.readUnsignedInt();
        this.sequenceNumber = decoder.readUnsignedInt();
        this.numberOfPackets = decoder.readUnsignedInt();
        this.errorCode = decoder.readUnsignedInt();
        this.bodyLength = decoder.readUnsignedInt();
        this.handle = new String(decoder.readByteArray(), "UTF8");
        this.options = new QueryOptions(decoder);
        this.typesWanted = decoder.readUIntArray();
        this.returnPort = (int)decoder.readUnsignedInt();
        this.returnAddress = decoder.readByteArray();
    }

    public HandleRequestPacket(InputStream in) throws IOException, XdrEncodingException, UnsupportedEncodingException {
        XdrDecoder decoder = new XdrDecoder(in);
        this.version = decoder.readUnsignedInt();
        this.sessionTag = decoder.readUnsignedInt();
        this.command = decoder.readUnsignedInt();
        this.sequenceNumber = decoder.readUnsignedInt();
        this.numberOfPackets = decoder.readUnsignedInt();
        this.errorCode = decoder.readUnsignedInt();
        this.bodyLength = decoder.readUnsignedInt();
        this.handle = new String(decoder.readByteArray(), "UTF8");
        this.options = new QueryOptions(decoder);
        this.typesWanted = decoder.readUIntArray();
        this.returnPort = (int)decoder.readUnsignedInt();
        this.returnAddress = decoder.readByteArray();
    }

    public HandleRequestPacket(long sessionTag, long command, long sequenceNumber, long numberOfPackets, int errorCode, String handle, QueryOptions options, long[] typesWanted, int returnPort, byte[] returnAddress) {
        this.version = 1L;
        this.sessionTag = sessionTag;
        this.command = command;
        this.sequenceNumber = sequenceNumber;
        this.numberOfPackets = numberOfPackets;
        this.errorCode = errorCode;
        this.handle = handle;
        this.options = options;
        this.typesWanted = typesWanted;
        this.returnPort = returnPort;
        this.returnAddress = returnAddress;
    }

    public byte[] buildRequest() throws HandleException {
        XdrEncoder bodyEncoder = new XdrEncoder(512);
        try {
            bodyEncoder.writeByteArray(this.handle.getBytes("UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new HandleException(7, "unable to encode UTF8 string");
        }
        if (this.options == null) {
            QueryOptions.writeNullOptions(bodyEncoder);
        } else {
            this.options.writeXdr(bodyEncoder);
        }
        if (this.typesWanted == null) {
            bodyEncoder.writeUIntArray(new long[0]);
        } else {
            bodyEncoder.writeUIntArray(this.typesWanted);
        }
        bodyEncoder.writeUInt(this.returnPort);
        if (this.returnAddress == null) {
            bodyEncoder.writeByteArray(new byte[0]);
        } else {
            bodyEncoder.writeByteArray(this.returnAddress);
        }
        byte[] body = bodyEncoder.getCurrentBuffer();
        this.bodyLength = body.length;
        XdrEncoder encoder = new XdrEncoder(512);
        encoder.writeUInt(this.version);
        encoder.writeUInt(this.sessionTag);
        encoder.writeUInt(this.command);
        encoder.writeUInt(this.sequenceNumber);
        encoder.writeUInt(this.numberOfPackets);
        encoder.writeUInt(this.errorCode);
        encoder.writeUInt(this.bodyLength);
        encoder.writeBytes(body);
        return encoder.getCurrentBuffer();
    }

    public void printValues(PrintStream out) {
        int i;
        out.println("sessionTag: " + this.sessionTag);
        out.println("command: " + this.command);
        out.println("sequenceNumber: " + this.sequenceNumber);
        out.println("numberOfPackets: " + this.numberOfPackets);
        out.println("errorCode: " + this.errorCode);
        out.println("bodyLength: " + this.bodyLength);
        out.println("Handle: " + this.handle);
        out.println("options " + this.options);
        if (this.typesWanted != null) {
            out.print("typesWanted: ");
            for (i = 0; i < this.typesWanted.length; ++i) {
                out.print(" " + this.typesWanted[i]);
            }
            out.println("");
        } else {
            out.println("typesWanted: " + this.typesWanted);
        }
        out.println("returnPort: " + this.returnPort);
        if (this.returnAddress != null) {
            out.print("returnAddress: ");
            for (i = 0; i < this.returnAddress.length; ++i) {
                out.print(" " + this.returnAddress[i]);
            }
            out.println("");
        } else {
            out.println("returnAddress: " + this.returnAddress);
        }
    }
}

