/*
 * Decompiled with CFR 0.152.
 */
package net.handle.hdllib4;

import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Vector;
import net.handle.hdllib4.Codes;
import net.handle.hdllib4.HandleElement;
import net.handle.hdllib4.HandleElementSet;
import net.handle.hdllib4.HandleResolutionInfo;
import net.handle.hdllib4.HandleResponsePacket;
import net.handle.hdllib4.InvalidPacketException;
import net.handle.hdllib4.RawResponsePacket;
import net.handle.hdllib4.ResponsePacketBody;
import net.handle.hdllib4.ResponsePacketHeader;
import net.handle.hdllib4.XdrDecoder;
import net.handle.hdllib4.XdrEncoder;

public class HandleResponse {
    private ResponsePacketBody[] packets = null;
    private int numberOfPackets = -1;
    private HandleElementSet elements = null;
    private boolean dirty = true;
    public String handle;
    public long version;
    public long sessionTag;
    public long command;
    public int errorCode;
    public boolean requestWasForwarded = false;
    public byte[] redirectedHandleServer;
    public long udpPortNumber;
    public long tcpPortNumber;
    public long expectedVersion;
    public String diagnostic;

    public static HandleElementSet getHandleElements(ResponsePacketBody[] packetBodies) {
        HandleElementSet elementSet = new HandleElementSet();
        int pnum = 0;
        while (pnum < packetBodies.length) {
            ResponsePacketBody packet;
            if ((packet = packetBodies[pnum++]) == null) continue;
            try {
                XdrDecoder decoder = new XdrDecoder(packet.getData());
                long typeOfData = decoder.readUnsignedInt();
                long dataLength = decoder.readInt();
                long offset = 0L;
                if (dataLength < 0L) {
                    offset = decoder.readUnsignedInt();
                }
                if (dataLength > 65536L) {
                    if (!HandleResolutionInfo.DEBUG) continue;
                    HandleResolutionInfo.out.println("Error:  Handle value too large (>65536)");
                    continue;
                }
                if (dataLength > 468L) {
                    boolean lastPartLength = false;
                    int bytesRead = 0;
                    HandleElement element = new HandleElement(typeOfData, new byte[(int)dataLength]);
                    byte[] tempBuf = decoder.readBytes(468);
                    System.arraycopy(tempBuf, 0, element.handleValue, (int)offset, tempBuf.length);
                    bytesRead += tempBuf.length;
                    while (bytesRead < element.handleValue.length && (packet = packetBodies[pnum++]) != null) {
                        decoder = new XdrDecoder(packet.getData());
                        typeOfData = decoder.readUnsignedInt();
                        dataLength = decoder.readInt() * -1;
                        offset = decoder.readUnsignedInt();
                        tempBuf = decoder.readBytes((int)Math.min((long)decoder.getRemainingByteCount(), dataLength - offset));
                        System.arraycopy(tempBuf, 0, element.handleValue, (int)offset, tempBuf.length);
                        bytesRead += tempBuf.length;
                    }
                    if (packet == null) continue;
                    elementSet.addHandleElement(element);
                    int i = 1;
                    while ((long)i < packet.getNumberOfDataItems()) {
                        typeOfData = decoder.readUnsignedInt();
                        dataLength = decoder.readInt();
                        offset = 0L;
                        if (dataLength < 0L) {
                            offset = decoder.readUnsignedInt();
                        }
                        element = new HandleElement(typeOfData, new byte[(int)dataLength]);
                        element.handleValue = decoder.readBytes((int)dataLength);
                        elementSet.addHandleElement(element);
                        ++i;
                    }
                    continue;
                }
                if (dataLength < 0L) continue;
                boolean itemOffset = false;
                int i = 0;
                while ((long)i < packet.getNumberOfDataItems()) {
                    if (i != 0) {
                        typeOfData = decoder.readUnsignedInt();
                        dataLength = decoder.readInt();
                    }
                    byte[] data = decoder.readBytes((int)dataLength);
                    elementSet.addHandleElement(new HandleElement(typeOfData, data));
                    ++i;
                }
            }
            catch (Exception e) {
                System.err.println("Error assembling packets: " + e);
                e.printStackTrace(System.err);
            }
        }
        return elementSet;
    }

    public RawResponsePacket[] getRawPacketBodies() {
        RawResponsePacket[] rawPackets = new RawResponsePacket[this.packets.length];
        boolean pnum = false;
        for (int i = 0; i < this.packets.length; ++i) {
            ResponsePacketBody packet = this.packets[i];
            if (packet == null) {
                rawPackets[i] = null;
                continue;
            }
            byte[] data = packet.getData();
            if (data != null) {
                try {
                    XdrDecoder decoder = new XdrDecoder(data);
                    long typeOfData = decoder.readUnsignedInt();
                    rawPackets[i] = new RawResponsePacket(typeOfData, packet.encodePacketBody());
                }
                catch (InvalidPacketException e) {
                    rawPackets[i] = null;
                }
                catch (IOException e) {
                    rawPackets[i] = null;
                }
                continue;
            }
            rawPackets[i] = null;
        }
        return rawPackets;
    }

    /*
     * Unable to fully structure code
     */
    public static RawResponsePacket[] getPacketBodies(long[] objectFlags, HandleElement[] hElements) throws InvalidPacketException {
        numPackaged = 0;
        packetBodies = new Vector<RawResponsePacket>();
        elements = new HandleElement[hElements.length];
        System.arraycopy(hElements, 0, elements, 0, hElements.length);
        try {
            md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidPacketException("MD5 algorithm missing");
        }
        ofEncoder = new XdrEncoder(484);
        if (objectFlags == null) {
            ofEncoder.writeUIntArray(new long[0]);
        } else {
            ofEncoder.writeUIntArray(objectFlags);
        }
        objectFlagEncoding = ofEncoder.getCurrentBuffer();
        ofEncoder = null;
        while (true) lbl-1000:
        // 4 sources

        {
            for (firstElement = 0; firstElement < elements.length && elements[firstElement] == null; ++firstElement) {
            }
            if (firstElement >= elements.length) break;
            currentElement = elements[firstElement];
            currentType = currentElement.handleType;
            currentLength = currentElement.handleValue.length;
            elements[firstElement] = null;
            if (objectFlagEncoding.length + 8 + 4 + currentElement.handleValue.length > 468) {
                HandleResponse.splitPacket(objectFlagEncoding, currentElement, packetBodies);
                ++numPackaged;
                ** continue;
            }
            packet = new XdrEncoder(484);
            packet.writeBytes(objectFlagEncoding);
            numItemsPosition = packet.getPosition();
            numItems = 1;
            packet.writeUInt(numItems);
            packet.writeUInt(currentElement.handleType);
            packet.writeInt(currentElement.handleValue.length);
            packet.writeBytes(currentElement.handleValue);
            ++numPackaged;
            freeSpace = 468 - packet.getPosition();
            for (elementNum = 0; elementNum < elements.length && freeSpace > 0; ++elementNum) {
                if (elements[elementNum] == null) continue;
                element = elements[elementNum];
                if (element.handleType != currentType || element.handleValue.length + 4 + 4 > freeSpace) continue;
                packet.writeUInt(element.handleType);
                packet.writeInt(element.handleValue.length);
                packet.writeBytes(element.handleValue);
                elements[elementNum] = null;
                ++numPackaged;
                freeSpace = 468 - packet.getPosition();
                ++numItems;
            }
            if (numItems != 1) {
                tmpPosition = packet.getPosition();
                packet.setPosition(numItemsPosition);
                packet.writeUInt(numItems);
                packet.setPosition(tmpPosition);
            }
            justBody = packet.getCurrentBuffer();
            checksum = md5Digest.digest(justBody);
            packet.writeBytes(checksum);
            packetBodies.addElement(new RawResponsePacket(currentType, packet.getCurrentBuffer()));
        }
        bodies = new RawResponsePacket[packetBodies.size()];
        for (i = 0; i < bodies.length; ++i) {
            bodies[i] = (RawResponsePacket)packetBodies.elementAt(i);
        }
        return bodies;
    }

    /*
     * WARNING - void declaration
     */
    public static void splitPacket(byte[] objectFlagEncoding, HandleElement element, Vector packetBodies) throws InvalidPacketException {
        int packetDataLength;
        boolean firstPacket = true;
        try {
            MessageDigest md5Digest = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidPacketException("MD5 algorithm missing");
        }
        for (int dataOffset = 0; dataOffset < element.handleValue.length; dataOffset += packetDataLength) {
            void var5_5;
            XdrEncoder packet = new XdrEncoder(484);
            packet.writeBytes(objectFlagEncoding);
            packet.writeUInt(1L);
            packet.writeUInt(element.handleType);
            if (firstPacket) {
                packet.writeUInt(element.handleValue.length);
                firstPacket = false;
            } else {
                packet.writeInt(-1 * (element.handleValue.length - dataOffset));
                packet.writeUInt(dataOffset);
            }
            int packetPosition = packet.getPosition();
            packetDataLength = Math.min(468 - packetPosition, element.handleValue.length - dataOffset);
            packet.writeBytes(element.handleValue, dataOffset, packetDataLength);
            byte[] justBody = packet.getCurrentBuffer();
            byte[] checksum = var5_5.digest(justBody);
            packet.writeBytes(checksum);
            packetBodies.addElement(new RawResponsePacket(element.handleType, packet.getCurrentBuffer()));
        }
    }

    public synchronized void addPacket(HandleResponsePacket packet) {
        if (this.packets == null) {
            this.initializePackets(packet);
        }
        this.packets[(int)packet.packetHeader.sequenceNumber - 1] = packet.packetBody;
        if (packet.packetHeader.errorCode != 0) {
            this.setErrorInfo(packet);
        }
        this.dirty = true;
    }

    private void initializePackets(HandleResponsePacket packet) {
        if (packet.packetHeader.numberOfPackets > 256) {
            if (HandleResolutionInfo.DEBUG) {
                HandleResolutionInfo.out.println("Error:  Invalid number of packets (>256)");
            }
            return;
        }
        ResponsePacketHeader header = packet.packetHeader;
        this.numberOfPackets = header.numberOfPackets;
        this.packets = new ResponsePacketBody[this.numberOfPackets];
        for (int i = 0; i < this.numberOfPackets; ++i) {
            this.packets[i] = null;
        }
        this.version = header.version;
        this.sessionTag = header.sessionTag;
        this.command = header.command;
        this.errorCode = header.errorCode;
    }

    private void setErrorInfo(HandleResponsePacket packet) {
        try {
            ResponsePacketBody packetBody = packet.packetBody;
            if (this.errorCode == 4) {
                this.redirectedHandleServer = packetBody.getRedirectedHandleServer();
                this.udpPortNumber = packetBody.getUdpPortNumber();
                this.tcpPortNumber = packetBody.getTcpPortNumber();
            } else if (this.errorCode == 6) {
                this.redirectedHandleServer = packetBody.getRedirectedHandleServer();
            } else if (this.errorCode == 2) {
                this.expectedVersion = packetBody.getExpectedVersion();
            } else if (this.errorCode == 3) {
                this.diagnostic = packetBody.getDiagnostic();
            } else if (this.errorCode == 1) {
                this.diagnostic = packetBody.getDiagnostic();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized HandleElementSet getPackagedData() {
        if (this.elements != null && !this.dirty) {
            return this.elements;
        }
        if (this.packets == null) {
            return null;
        }
        this.elements = HandleResponse.getHandleElements(this.packets);
        return this.elements;
    }

    public void printValues() {
        HandleResolutionInfo.out.println("Version: " + this.version);
        HandleResolutionInfo.out.println("sessionTag: " + this.sessionTag);
        HandleResolutionInfo.out.println("command: " + this.command);
        HandleResolutionInfo.out.println("numberOfPackets: " + this.numberOfPackets);
        HandleResolutionInfo.out.println("errorCode: " + this.errorCode + " " + Codes.getHPCodeDescription(this.errorCode));
        if (this.errorCode == 0) {
            HandleElementSet elementSet = this.getPackagedData();
            if (elementSet != null) {
                HandleResolutionInfo.out.println("\nHandle Items:");
                Enumeration enumeration = elementSet.getElements();
                while (enumeration.hasMoreElements()) {
                    ((HandleElement)enumeration.nextElement()).printValues();
                }
                HandleResolutionInfo.out.print('\n');
            }
        } else if (this.errorCode == 4) {
            HandleResolutionInfo.out.println("redirectedHandleServer: " + this.redirectedHandleServer);
            HandleResolutionInfo.out.println("udpPortNumber: " + this.udpPortNumber);
            HandleResolutionInfo.out.println("tcpPortNumber: " + this.tcpPortNumber);
        } else if (this.errorCode == 6) {
            HandleResolutionInfo.out.println("redirectedHandleServer: " + this.redirectedHandleServer);
        } else if (this.errorCode == 2) {
            HandleResolutionInfo.out.println("expectedVersion: " + this.expectedVersion);
        } else if (this.errorCode == 3) {
            HandleResolutionInfo.out.println("diagnostic: " + this.diagnostic);
        } else if (this.errorCode == 1) {
            HandleResolutionInfo.out.println("diagnostic: " + this.diagnostic);
        }
    }

    public boolean haveSomePackets() {
        return this.packets != null;
    }

    public boolean haveAllPackets() {
        if (this.packets == null) {
            return false;
        }
        for (int i = 0; i < this.numberOfPackets; ++i) {
            if (this.packets[i] != null) continue;
            return false;
        }
        return true;
    }
}

