/*
 * Decompiled with CFR 0.152.
 */
package net.handle.security.provider;

import com.sun.crypto.provider.SunJCE;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.Security;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import net.handle.security.HdlSecurityProvider;

public final class SunJceHdlSecurityProvider
extends HdlSecurityProvider {
    private static MessageDigest md5digest = null;
    private static MessageDigest sha1digest = null;
    Cipher rsaCipher;

    public SunJceHdlSecurityProvider() throws Exception {
        int i = Security.insertProviderAt(new SunJCE(), 1);
    }

    public byte[] encrypt_DES_ECB_PKCS5(byte[] cleartext, int offset, int len, byte[] secretKey) throws Exception {
        DESKeySpec spec = new DESKeySpec(SunJceHdlSecurityProvider.md5hash(secretKey, 0, secretKey.length));
        SecretKey key = SecretKeyFactory.getInstance("DES").generateSecret(spec);
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        cipher.init(1, key);
        return cipher.doFinal(cleartext, offset, len);
    }

    public byte[] decrypt_DES_ECB_PKCS5(byte[] ciphertext, int offset, int len, byte[] secretKey) throws Exception {
        DESKeySpec spec = new DESKeySpec(SunJceHdlSecurityProvider.md5hash(secretKey, 0, secretKey.length));
        SecretKey key = SecretKeyFactory.getInstance("DES").generateSecret(spec);
        Cipher cipher = Cipher.getInstance("DES/ECB/PKCS5Padding");
        cipher.init(2, key);
        return cipher.doFinal(ciphertext, offset, len);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] md5hash(byte[] bytesToHash, int offset, int len) throws Exception {
        if (md5digest == null) {
            md5digest = MessageDigest.getInstance("MD5");
        }
        MessageDigest messageDigest = md5digest;
        synchronized (messageDigest) {
            md5digest.reset();
            md5digest.update(bytesToHash, offset, len);
            byte[] toReturn = md5digest.digest();
            md5digest.reset();
            return toReturn;
        }
    }

    public byte[] getDESKeyFromDH(DHPublicKey pub, DHPrivateKey priv) throws Exception {
        KeyFactory kf = KeyFactory.getInstance("DH");
        DHParameterSpec dhSpec = priv.getParams();
        DHPrivateKeySpec privSpec = new DHPrivateKeySpec(priv.getX(), dhSpec.getP(), dhSpec.getG());
        dhSpec = pub.getParams();
        DHPublicKeySpec pubSpec = new DHPublicKeySpec(pub.getY(), dhSpec.getP(), dhSpec.getG());
        KeyAgreement ka = KeyAgreement.getInstance("DH");
        ka.init(kf.generatePrivate(privSpec));
        ka.doPhase(kf.generatePublic(pubSpec), true);
        SecretKey secretKey = ka.generateSecret("DES");
        return secretKey.getEncoded();
    }

    public KeyPair generateDHKeyPair(int keySize) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("DH");
        kpg.initialize(keySize);
        KeyPair kp = kpg.generateKeyPair();
        return kp;
    }

    public KeyPair generateDHKeyPair(BigInteger p, BigInteger g) throws Exception {
        KeyPairGenerator kpg = KeyPairGenerator.getInstance("DH");
        kpg.initialize(new DHParameterSpec(p, g));
        KeyPair kp = kpg.generateKeyPair();
        return kp;
    }
}

