/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import net.handle.server.DBTxn;

public class DBTransactionLog {
    public static final byte SET_HDL_VALUE = 0;
    public static final byte DELETE_HDL_VALUE = 1;
    public static final byte SET_NA_VALUE = 2;
    public static final byte DELETE_NA_VALUE = 3;
    public static final byte DELETE_EVERYTHING = 4;
    private File logFile;
    private BufferedOutputStream log;
    private static final byte NEWLINE = 110;

    public DBTransactionLog(File logFile) throws Exception {
        this.logFile = logFile;
        this.openWriter();
    }

    private final void openWriter() throws Exception {
        this.log = new BufferedOutputStream(new FileOutputStream(this.logFile.getAbsolutePath(), true));
    }

    public synchronized void reset() throws Exception {
        System.err.println("Resetting transaction log...");
        this.log.close();
        this.logFile.delete();
        this.openWriter();
        System.err.println("Done resetting transaction queue");
    }

    public synchronized void log(byte action, byte[] key, byte[] val) throws Exception {
        DBTxn txn = new DBTxn(action, key, val, System.currentTimeMillis());
        this.log.write(txn.getLogBytes());
        this.log.flush();
    }

    public void finalize() {
        this.shutdown();
    }

    public synchronized void shutdown() {
        try {
            this.log.close();
        }
        catch (Throwable e) {
            System.err.println("Error shutting down transaction log: " + e);
            e.printStackTrace(System.err);
        }
    }
}

