/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.File;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleStorage;
import net.handle.server.JDBHandleStorage;
import net.handle.server.SQLHandleStorage;
import net.handle.util.StreamTable;

public abstract class HandleStorageFactory {
    public static final String STORAGE_TYPE = "storage_type";
    public static final String STORAGE_CLASS = "storage_class";
    public static final String CUSTOM_STORAGE_CONFIG = "storage_config";
    public static final String SQL_CONFIG = "sql_settings";

    public static HandleStorage getStorage(File serverDir, StreamTable config, boolean isPrimary) throws Exception {
        HandleStorage storage = null;
        String storageType = config.getStr(STORAGE_TYPE, "").toUpperCase().trim();
        if (storageType.equals("SQL")) {
            StreamTable sqlConfig = (StreamTable)config.get(SQL_CONFIG);
            if (sqlConfig == null) {
                throw new HandleException(0, "Missing sql_settings section in config file");
            }
            storage = new SQLHandleStorage();
            storage.init(sqlConfig);
            return storage;
        }
        if (storageType.equalsIgnoreCase("BDBJE")) {
            StreamTable configCopy = (StreamTable)config.deepClone();
            configCopy.put("serverDir", serverDir.getAbsolutePath());
            storage = (HandleStorage)Class.forName("net.handle.server.bdbje.BDBJEHandleStorage").newInstance();
            storage.init(configCopy);
            return storage;
        }
        if (storageType.equals("CUSTOM")) {
            Object obj;
            String storageClassName = String.valueOf(config.get(STORAGE_CLASS)).trim();
            Class<?> storageClass = Class.forName(storageClassName);
            StreamTable cfgTable = (StreamTable)config.get(CUSTOM_STORAGE_CONFIG);
            if (cfgTable == null) {
                cfgTable = new StreamTable();
            }
            if ((obj = storageClass.newInstance()) instanceof HandleStorage) {
                storage = (HandleStorage)obj;
                cfgTable.put("serverDir", serverDir.getAbsolutePath());
                storage.init(cfgTable);
                return storage;
            }
            throw new HandleException(0, "Custom storage class " + storageClassName + " does not implement the HandleStorage interface");
        }
        storage = new JDBHandleStorage(serverDir, isPrimary);
        storage.init(config);
        return storage;
    }
}

