/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.Socket;
import java.net.URLEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import net.handle.hdllib.AbstractMessage;
import net.handle.hdllib.AbstractRequest;
import net.handle.hdllib.AbstractResponse;
import net.handle.hdllib.Common;
import net.handle.hdllib.Encoder;
import net.handle.hdllib.ErrorResponse;
import net.handle.hdllib.HandleException;
import net.handle.hdllib.HandleValue;
import net.handle.hdllib.MessageEnvelope;
import net.handle.hdllib.ParameterParser;
import net.handle.hdllib.ParameterSet;
import net.handle.hdllib.ResolutionRequest;
import net.handle.hdllib.ResolutionResponse;
import net.handle.hdllib.ResponseMessageCallback;
import net.handle.hdllib.Util;
import net.handle.server.AbstractServer;
import net.handle.server.HandleServer;
import net.handle.server.Main;
import net.handle.server.RequestHandler;
import net.handle.server.RequestHandlerPool;
import net.handle.server.ServerSideSessionInfo;
import net.handle.util.HTTPCookie;
import net.handle.util.StringUtils;

public class HdlHttpRequestHandler
implements Runnable,
RequestHandler,
ResponseMessageCallback {
    private static final int DEFAULT_MAX_MESSAGE_LENGTH = 1024;
    public static final int MF_HDL = 0;
    public static final int MF_HTML = 1;
    private Socket socket = null;
    private long recvTime;
    private AbstractRequest currentHdlRequest;
    private String currentHtmlLogAccessHdl;
    private String currentHtmlLogAccessType;
    private AbstractServer server;
    private HdlHttpRequestHandler handler;
    private HtmlResponder htmlResponder;
    private Main main;
    private boolean showHtmlPage = true;
    private boolean authRequest = false;
    private boolean suppressRedirect = false;
    private boolean followAliases = false;
    private int aliasCount = 5;
    private int responseType;
    private int requestType;
    private String redirectSuffix = "";
    private String currentHdl = "";
    private boolean sfxEnabled = false;
    private String sfxCookieName = null;
    private boolean suppressSFXRedirect = false;
    private boolean sfxAwareClient = false;
    private String sfxBaseURL = null;
    private String sfxID = null;
    private HTTPCookie cookies = new HTTPCookie();
    private Thread handlerThread;
    private boolean isRunning = false;
    private boolean isActive = true;
    private int invocations = 0;
    private boolean logAccesses = false;
    private RequestHandlerPool handlerPool = null;
    private MessageEnvelope envelope = new MessageEnvelope();
    private Hashtable headers = new Hashtable();
    private byte[] envelopeBuf = new byte[20];
    private byte[] messageBuf = new byte[1024];
    public static final String ACCESS_TYPE = "HTTP:HDL";
    public static final String ACCESS_TYPE_SFX = "HTTP:HDL:SFX";
    public static final byte[] MSG_INVALID_MSG_SIZE = Util.encodeString("Invalid message length");
    public static final byte[] MSG_INVALID_REQUEST = Util.encodeString("Invalid request");
    private static final String HTTP_ACCEPT_HDR = "ACCEPT";
    private static final String HTTP_CONTENT_TYPE_HDR = "CONTENT-TYPE";
    private static final String HTTP_HOST_HDR = "HOST";
    private static final String HDL = "hdl";
    private static final String HDL_TYPE = "type";
    private static final String AUTH_FLAG = "auth";
    private static final String SUPPRESS_REDIRECT = "noredirect";
    private static final String DONT_FOLLOW_ALIASES = "ignore_aliases";
    private static final String URLAPPEND = "urlappend";
    private static String queryPageDefault = null;
    private static Vector errorPageDefault = null;
    private static Vector responsePageDefault = null;
    private static Hashtable virtualHostsPages = null;
    private static final int VIRTUAL_HOST_QUERY_PAGE_IDX = 0;
    private static final int VIRTUAL_HOST_ERROR_PAGE_IDX = 1;
    private static final int VIRTUAL_HOST_RESPONSE_PAGE_IDX = 2;
    private static final String VIRTUAL_HOST_HOSTNAME = "hostname";
    private static final String VIRTUAL_HOST_QUERY_PAGE = "query_page";
    private static final String VIRTUAL_HOST_ERROR_PAGE = "error_page";
    private static final String VIRTUAL_HOST_RESPONSE_PAGE = "response_page";
    private String queryPage = null;
    private Vector errorPage = new Vector();
    private Vector responsePage = new Vector();
    private static final String HANDLE_TOKEN = "HANDLE_TOKEN";
    private static final String TRACE_TOKEN = "TRACE_TOKEN";
    private static final String ERROR_TOKEN = "ERROR_TOKEN";
    private static final String VALUES_TOKEN = "VALUES_TOKEN";
    private int resolutionError = 0;
    private static final int ERROR_SERVICE_NOTFOUND = 1;
    private static final int ERROR_CANNOT_CONNECT_SERVER = 3;
    private static final int ERROR_HANDLE_NOT_EXIST = 2;
    private static final int ERROR_VALUES_NOT_FOUND = 4;
    private static final int ERROR_UNKNOWN = 100;
    private Exception originalException = null;
    private static final String DOI_PROTOCOL = "doi:";
    private static final String HDL_PROTOCOL = "hdl:";
    private static final int DOI_PROTOCOL_LENGTH = 4;

    public HdlHttpRequestHandler(Main main, RequestHandlerPool handlerPool, boolean logAccesses, String sfxCookieName, String queryPageFile, String responsePageFile, String errorPageFile, Vector virtualHosts) {
        if (queryPageDefault == null) {
            this.loadHTML(queryPageFile, responsePageFile, errorPageFile, virtualHosts);
        }
        this.init(main, handlerPool, logAccesses, sfxCookieName);
    }

    public HdlHttpRequestHandler(Main main, RequestHandlerPool handlerPool, boolean logAccesses, String sfxCookieName) {
        if (queryPageDefault == null) {
            this.loadHTML(null, null, null, null);
        }
        this.init(main, handlerPool, logAccesses, sfxCookieName);
    }

    private void init(Main main, RequestHandlerPool handlerPool, boolean logAccesses, String sfxCookieName) {
        this.main = main;
        this.server = main.getServer();
        this.handler = this;
        this.handlerPool = handlerPool;
        this.htmlResponder = new HtmlResponder();
        this.logAccesses = logAccesses;
        this.sfxEnabled = sfxCookieName != null;
        this.sfxCookieName = sfxCookieName;
        this.handlerThread = new Thread(this);
        this.handlerThread.start();
    }

    private void loadHTML(String queryPageFile, String responsePageFile, String errorPageFile, Vector virtualHosts) {
        queryPageDefault = this.loadQueryPage(queryPageFile, "default");
        errorPageDefault = this.loadErrorPage(errorPageFile, "default");
        responsePageDefault = this.loadResponsePage(responsePageFile, "default");
        virtualHostsPages = new Hashtable();
        for (int i = 0; virtualHosts != null && i < virtualHosts.size(); ++i) {
            Hashtable ht = (Hashtable)virtualHosts.elementAt(i);
            String hostname = (String)ht.get(VIRTUAL_HOST_HOSTNAME);
            if (hostname == null || hostname.length() == 0) {
                System.err.println("The vitual host name missing in the configuration!");
                continue;
            }
            String virtualQuery = this.loadQueryPage((String)ht.get(VIRTUAL_HOST_QUERY_PAGE), hostname);
            Vector virtualError = this.loadErrorPage((String)ht.get(VIRTUAL_HOST_ERROR_PAGE), hostname);
            Vector virtualResponse = this.loadResponsePage((String)ht.get(VIRTUAL_HOST_RESPONSE_PAGE), hostname);
            if (virtualQuery == null || virtualQuery.length() <= 0 || virtualError == null || virtualResponse == null) continue;
            Vector<Object> virtualPages = new Vector<Object>();
            virtualPages.insertElementAt(virtualQuery, 0);
            virtualPages.insertElementAt(virtualError, 1);
            virtualPages.insertElementAt(virtualResponse, 2);
            virtualHostsPages.put(hostname.trim(), virtualPages);
        }
    }

    private String loadStream(InputStream in) throws Exception {
        int len;
        byte[] b = new byte[1024];
        StringBuffer sb = new StringBuffer();
        while ((len = in.read(b)) != -1) {
            sb.append(new String(b).substring(0, len));
        }
        return sb.toString();
    }

    private String loadQueryPage(String queryPageFile, String whichhost) {
        String queryPage;
        try {
            InputStream in = queryPageFile != null ? new FileInputStream(queryPageFile) : this.getClass().getResourceAsStream("/net/handle/server/html/query.html");
            queryPage = this.loadStream(in);
        }
        catch (Exception e) {
            queryPage = "Page not found!";
            System.err.println("Error loading query page for " + whichhost + " host!");
        }
        return queryPage;
    }

    private Vector loadErrorPage(String errorPageFile, String whichhost) {
        InputStream in = null;
        Vector<String> errorPage = new Vector<String>();
        try {
            in = errorPageFile != null ? new FileInputStream(errorPageFile) : this.getClass().getResourceAsStream("/net/handle/server/html/error.html");
            String s = this.loadStream(in);
            int pos = 0;
            int next = 0;
            while (pos < s.length()) {
                next = s.indexOf("${", pos);
                if (next == -1) {
                    errorPage.addElement(s.substring(pos));
                    break;
                }
                errorPage.addElement(s.substring(pos, next));
                if (s.startsWith("${ERROR}", next)) {
                    errorPage.addElement(ERROR_TOKEN);
                    pos = next + 8;
                    continue;
                }
                if (s.startsWith("${HANDLE}", next)) {
                    errorPage.addElement(HANDLE_TOKEN);
                    pos = next + 9;
                    continue;
                }
                if (s.startsWith("${TRACE}", next)) {
                    errorPage.addElement(TRACE_TOKEN);
                    pos = next + 8;
                    continue;
                }
                if (!s.startsWith("${", next)) continue;
                int posRightP = s.indexOf("}", next + 2);
                String token = "";
                token = posRightP != -1 ? s.substring(next, posRightP + 1) : "${";
                if (token.length() > 2) {
                    errorPage.addElement(token.substring(2, token.length() - 1));
                    pos = next + token.length();
                    continue;
                }
                pos = next + 2;
            }
        }
        catch (Exception e) {
            errorPage.removeAllElements();
            errorPage.addElement("Page not found!");
            System.err.println("Error loading error page for " + whichhost + " host!");
        }
        return errorPage;
    }

    private Vector loadResponsePage(String responsePageFile, String whichhost) {
        Vector<String> responsePage = new Vector<String>();
        try {
            InputStream in = responsePageFile != null ? new FileInputStream(responsePageFile) : this.getClass().getResourceAsStream("/net/handle/server/html/response.html");
            String s = this.loadStream(in);
            int pos = 0;
            int next = 0;
            while (pos < s.length()) {
                next = s.indexOf("${", pos);
                if (next == -1) {
                    responsePage.addElement(s.substring(pos));
                    break;
                }
                responsePage.addElement(s.substring(pos, next));
                if (s.startsWith("${HANDLE}", next)) {
                    responsePage.addElement(HANDLE_TOKEN);
                    pos = next + 9;
                    continue;
                }
                if (s.startsWith("${VALUES}", next)) {
                    responsePage.addElement(VALUES_TOKEN);
                    pos = next + 9;
                    continue;
                }
                if (!s.startsWith("${", next)) continue;
                int posRightP = s.indexOf("}", next + 2);
                String token = "";
                token = posRightP != -1 ? s.substring(next, posRightP + 1) : "${";
                if (token.length() > 2) {
                    responsePage.addElement(token.substring(2, token.length() - 1));
                    pos = next + token.length();
                    continue;
                }
                pos = next + 2;
            }
        }
        catch (Exception e) {
            responsePage.removeAllElements();
            responsePage.addElement("Page not found!");
            System.err.println("Error loading response page for " + whichhost + " host!");
        }
        return responsePage;
    }

    public RequestHandler newHandler() {
        return new HdlHttpRequestHandler(this.main, this.handlerPool, this.logAccesses, this.sfxCookieName);
    }

    public int getInvocationCount() {
        return this.invocations;
    }

    public void deactivate() {
        this.isActive = false;
        this.resetState();
    }

    public void resetState() {
        this.isRunning = false;
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public synchronized void serviceRequest(Socket socket, long recvTime) {
        this.socket = socket;
        this.recvTime = recvTime;
        this.isRunning = true;
        ++this.invocations;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (true) {
            block48: {
                block49: {
                    block39: {
                        block46: {
                            block47: {
                                block37: {
                                    block35: {
                                        block45: {
                                            block36: {
                                                if (!this.isActive) {
                                                    return;
                                                }
                                                this.authRequest = false;
                                                this.showHtmlPage = true;
                                                this.suppressRedirect = false;
                                                this.followAliases = false;
                                                this.aliasCount = 5;
                                                this.suppressSFXRedirect = false;
                                                this.sfxAwareClient = false;
                                                this.sfxBaseURL = null;
                                                this.sfxID = null;
                                                this.headers.clear();
                                                this.cookies.clear();
                                                this.resolutionError = 0;
                                                this.originalException = null;
                                                this.redirectSuffix = "";
                                                this.queryPage = null;
                                                this.errorPage = null;
                                                this.responsePage = null;
                                                this.currentHtmlLogAccessHdl = "NA";
                                                this.currentHtmlLogAccessType = "HTTP:HDL";
                                                this.currentHdlRequest = null;
                                                var1_1 = this;
                                                synchronized (var1_1) {
                                                    while (!this.isRunning && this.isActive) {
                                                        try {
                                                            this.wait();
                                                            if (this.isRunning) continue;
                                                            this.main.logError(75, "hdl-http error: invalid handler thread state");
                                                        }
                                                        catch (Exception e) {
                                                            this.main.logError(75, String.valueOf(this.getClass()) + "Got exception: " + e);
                                                        }
                                                    }
                                                    if (!this.isActive) continue;
                                                }
                                                in = null;
                                                try {
                                                    try {
                                                        block38: {
                                                            block42: {
                                                                block41: {
                                                                    in = new DataInputStream(new BufferedInputStream(this.socket.getInputStream(), 512));
                                                                    firstLine = in.readLine();
                                                                    if (firstLine == null) break block41;
                                                                    if (firstLine.trim().length() > 0) break block42;
                                                                }
                                                                var12_13 = null;
                                                                if (in == null) break block35;
                                                                break block36;
                                                            }
                                                            spcIdx = firstLine.indexOf(32);
                                                            if (spcIdx < 0) {
                                                                break block37;
                                                            }
                                                            while (true) {
                                                                if ((line = in.readLine()) == null) {
                                                                    throw new HandleException(6, "Unexpected end of headers");
                                                                }
                                                                if (line.length() <= 0) {
                                                                    this.responseType = this.determineResponseType((String)this.headers.get("ACCEPT"));
                                                                    this.requestType = this.determineRequestType((String)this.headers.get("CONTENT-TYPE"));
                                                                    hostname = (String)this.headers.get("HOST");
                                                                    if (hostname != null) {
                                                                        break;
                                                                    }
                                                                    break block38;
                                                                }
                                                                colIdx = line.indexOf(58);
                                                                if (colIdx >= 0) {
                                                                    headerKey = line.substring(0, colIdx).toUpperCase();
                                                                    headerVal = line.substring(colIdx + 1);
                                                                } else {
                                                                    headerKey = line.toUpperCase();
                                                                    headerVal = "";
                                                                }
                                                                if (this.sfxEnabled && headerKey.equals("COOKIE")) {
                                                                    this.cookies.parseRequestHeader(headerVal);
                                                                }
                                                                this.headers.put(headerKey, headerVal);
                                                            }
                                                            if (hostname.length() > 0) {
                                                                idxPort = hostname.indexOf(":");
                                                                hostNameWoPort = idxPort != -1 ? hostname.substring(0, idxPort) : hostname;
                                                                if (HdlHttpRequestHandler.virtualHostsPages.containsKey(hostNameWoPort = hostNameWoPort.trim())) {
                                                                    this.queryPage = (String)((Vector)HdlHttpRequestHandler.virtualHostsPages.get(hostNameWoPort)).elementAt(0);
                                                                    this.errorPage = (Vector)((Vector)HdlHttpRequestHandler.virtualHostsPages.get(hostNameWoPort)).elementAt(1);
                                                                    this.responsePage = (Vector)((Vector)HdlHttpRequestHandler.virtualHostsPages.get(hostNameWoPort)).elementAt(2);
                                                                }
                                                            }
                                                        }
                                                        if (this.queryPage == null || this.queryPage.length() == 0 || this.errorPage == null || this.errorPage.size() == 0 || this.responsePage == null || this.responsePage.size() == 0) {
                                                            this.queryPage = HdlHttpRequestHandler.queryPageDefault;
                                                            this.errorPage = HdlHttpRequestHandler.errorPageDefault;
                                                            this.responsePage = HdlHttpRequestHandler.responsePageDefault;
                                                        }
                                                        switch (this.requestType) {
                                                            case 0: {
                                                                this.handleHdlRequest(in);
                                                                ** break;
                                                            }
                                                            case 1: {
                                                                this.handleHtmlRequest(firstLine, in);
                                                                ** break;
                                                            }
                                                        }
                                                        this.handleResponse(new ErrorResponse(0, 2, HdlHttpRequestHandler.MSG_INVALID_REQUEST));
                                                        break block39;
                                                    }
                                                    catch (Throwable e) {
                                                        this.main.logError(75, String.valueOf(this.getClass()) + ": Exception processing request: " + e);
                                                        var12_13 = null;
                                                        if (in != null) {
                                                            try {
                                                                in.close();
                                                            }
                                                            catch (Throwable e) {
                                                                // empty catch block
                                                            }
                                                            in = null;
                                                        }
                                                        this.handlerPool.returnHandler(this);
                                                        continue;
                                                    }
                                                }
                                                catch (Throwable var11_15) {
                                                    block43: {
                                                        block44: {
                                                            var12_13 = null;
                                                            if (in == null) break block43;
                                                            ** try [egrp 4[TRYBLOCK] [11 : 798->805)] { 
lbl115:
                                                            // 1 sources

                                                            in.close();
                                                            break block44;
lbl117:
                                                            // 1 sources

                                                            catch (Throwable e) {
                                                                // empty catch block
                                                            }
                                                        }
                                                        in = null;
                                                    }
                                                    this.handlerPool.returnHandler(this);
                                                    throw var11_15;
                                                }
                                            }
                                            ** try [egrp 4[TRYBLOCK] [11 : 798->805)] { 
lbl126:
                                            // 1 sources

                                            in.close();
                                            break block45;
lbl128:
                                            // 1 sources

                                            catch (Throwable e) {
                                                // empty catch block
                                            }
                                        }
                                        in = null;
                                    }
                                    this.handlerPool.returnHandler(this);
                                    continue;
                                }
                                var12_13 = null;
                                if (in == null) break block46;
                                ** try [egrp 4[TRYBLOCK] [11 : 798->805)] { 
lbl139:
                                // 1 sources

                                in.close();
                                break block47;
lbl141:
                                // 1 sources

                                catch (Throwable e) {
                                    // empty catch block
                                }
                            }
                            in = null;
                        }
                        this.handlerPool.returnHandler(this);
                        continue;
                    }
                    var12_13 = null;
                    if (in == null) break block48;
                    ** try [egrp 4[TRYBLOCK] [11 : 798->805)] { 
lbl152:
                    // 1 sources

                    in.close();
                    break block49;
lbl154:
                    // 1 sources

                    catch (Throwable e) {
                        // empty catch block
                    }
                }
                in = null;
            }
            this.handlerPool.returnHandler(this);
        }
    }

    private final void handleHtmlRequest(String firstLine, InputStream in) throws Exception {
        boolean n = false;
        this.followAliases = true;
        String method = StringUtils.fieldIndex(firstLine, ' ', 0).trim().toUpperCase();
        try {
            if (method.equals("GET") || method.equals("HEAD")) {
                this.authRequest = false;
                this.showHtmlPage = method.equals("GET");
                this.suppressRedirect = false;
                String uri = StringUtils.fieldIndex(firstLine, ' ', 1).trim();
                if (uri.startsWith("/")) {
                    uri = uri.substring(1).trim();
                }
                if (uri.length() <= 0) {
                    this.handleResponse(null);
                    return;
                }
                if (uri.startsWith("openurl?")) {
                    this.doOpenURLResolution(uri.substring(8));
                } else {
                    this.doResolution(uri);
                }
            } else {
                int ich;
                this.showHtmlPage = true;
                this.authRequest = false;
                this.suppressRedirect = false;
                int contentLength = 0;
                if (this.headers.containsKey("CONTENT-LENGTH")) {
                    contentLength = Integer.parseInt(((String)this.headers.get("CONTENT-LENGTH")).trim());
                } else {
                    this.handleResponse(null);
                }
                StringBuffer sb = new StringBuffer();
                for (int i = 0; i < contentLength && (ich = in.read()) >= 0; ++i) {
                    sb.append((char)ich);
                }
                String postData = sb.toString();
                Vector<String> typeVect = null;
                int idx = -1;
                while (true) {
                    String paramValue;
                    String paramName;
                    int tmpIdx;
                    String pairData;
                    int eqIndex;
                    if ((eqIndex = (pairData = (tmpIdx = postData.indexOf(38, idx + 1)) < 0 ? postData.substring(idx + 1) : postData.substring(idx + 1, tmpIdx)).indexOf(61)) < 0) {
                        paramName = StringUtils.decodeURL(pairData);
                        paramValue = "";
                    } else {
                        paramName = StringUtils.decodeURL(pairData.substring(0, eqIndex));
                        paramValue = StringUtils.decodeURL(pairData.substring(eqIndex + 1));
                    }
                    if (paramName.equals(HDL)) {
                        this.currentHdl = paramValue;
                        this.currentHdl = this.currentHdl.trim();
                        if (this.currentHdl.length() >= 4 && (this.currentHdl.substring(0, 4).equalsIgnoreCase(DOI_PROTOCOL) || this.currentHdl.substring(0, 4).equalsIgnoreCase(HDL_PROTOCOL))) {
                            this.currentHdl = this.currentHdl.substring(4);
                        }
                    } else if (paramName.equals(HDL_TYPE)) {
                        if (typeVect == null) {
                            typeVect = new Vector<String>();
                        }
                        typeVect.addElement(paramValue);
                    } else if (paramName.equals(AUTH_FLAG)) {
                        this.authRequest = true;
                    } else if (paramName.equals(SUPPRESS_REDIRECT)) {
                        this.suppressRedirect = true;
                    } else if (paramName.equals(DONT_FOLLOW_ALIASES)) {
                        this.followAliases = false;
                    }
                    if (tmpIdx < 0) break;
                    idx = tmpIdx;
                }
                if (this.currentHdl == null || this.currentHdl.length() <= 0) {
                    this.handleResponse(null);
                    return;
                }
                Object typesWanted = null;
                if (typeVect != null && typeVect.size() > 0) {
                    typesWanted = new byte[typeVect.size()][];
                }
                for (int i = 0; typesWanted != null && i < ((byte[][])typesWanted).length; ++i) {
                    typesWanted[i] = Util.encodeString((String)typeVect.elementAt(i));
                }
                int[] indexesWanted = null;
                this.currentHtmlLogAccessHdl = this.currentHdl;
                this.currentHtmlLogAccessType = ACCESS_TYPE;
                ResolutionRequest req = new ResolutionRequest(Util.encodeString(this.currentHdl), (byte[][])typesWanted, indexesWanted, null);
                req.recursive = true;
                req.authoritative = this.authRequest;
                this.server.processRequest(req, this.htmlResponder);
            }
        }
        catch (Exception e) {
            this.originalException = e;
            this.resolutionError = 100;
            if (e instanceof HandleException) {
                HandleException he = (HandleException)e;
                if (he.getCode() == 2) {
                    this.resolutionError = 1;
                } else if (he.getCode() == 7) {
                    this.resolutionError = 3;
                }
            }
            this.handleResponse(null);
        }
    }

    private final void doOpenURLResolution(String openURLQuery) throws Exception {
        Hashtable<String, String> params = new Hashtable<String, String>();
        int ampIdx = -1;
        do {
            int sectionStart;
            String section;
            int eqIdx;
            if ((eqIdx = (section = (ampIdx = openURLQuery.indexOf(38, sectionStart = ampIdx + 1)) < 0 ? openURLQuery.substring(sectionStart) : openURLQuery.substring(sectionStart, ampIdx)).indexOf(61)) < 0) {
                params.put(StringUtils.decodeURLIgnorePlus(section), "");
                continue;
            }
            params.put(StringUtils.decodeURLIgnorePlus(section.substring(0, eqIdx)), StringUtils.decodeURLIgnorePlus(section.substring(eqIdx + 1)));
        } while (ampIdx >= 0);
        String hdl = (String)params.get("id");
        if (hdl == null) {
            hdl = "";
        }
        if (hdl.startsWith(HDL_PROTOCOL) || hdl.startsWith(DOI_PROTOCOL)) {
            hdl = hdl.substring(4);
        }
        this.currentHdl = hdl;
        if (this.sfxEnabled && this.cookies.containsCookie(this.sfxCookieName)) {
            this.sfxBaseURL = this.cookies.getCookieVal(this.sfxCookieName);
            this.sfxAwareClient = this.sfxBaseURL != null;
            this.sfxID = hdl.trim();
            this.suppressSFXRedirect = params.containsKey("nosfx");
        }
        if (this.sfxAwareClient && !this.suppressSFXRedirect) {
            this.currentHtmlLogAccessHdl = hdl + "|" + this.sfxBaseURL;
            this.currentHtmlLogAccessType = ACCESS_TYPE_SFX;
        } else {
            this.currentHtmlLogAccessHdl = hdl;
            this.currentHtmlLogAccessType = ACCESS_TYPE;
        }
        ResolutionRequest req = new ResolutionRequest(Util.encodeString(hdl), null, null, null);
        req.recursive = true;
        this.server.processRequest(req, this.htmlResponder);
    }

    private final void doResolution(String handle) throws Exception {
        String[] urlappend;
        String[] followAli;
        String[] authReq;
        String[] noredirect;
        ParameterSet parameters = ParameterParser.parseHandleURI(handle);
        String[] paramArr = parameters.getHandleParametersByName(HDL_TYPE);
        this.currentHdl = parameters.handle;
        if (this.currentHdl.length() >= 4 && (this.currentHdl.substring(0, 4).equalsIgnoreCase(DOI_PROTOCOL) || this.currentHdl.substring(0, 4).equalsIgnoreCase(HDL_PROTOCOL))) {
            this.currentHdl = this.currentHdl.substring(4);
        }
        if (this.sfxEnabled) {
            Enumeration hdrs = this.headers.keys();
            while (hdrs.hasMoreElements()) {
                String key = (String)hdrs.nextElement();
                if (!key.equals("COOKIE")) continue;
                this.cookies.parseRequestHeader(((String)this.headers.get(key)).trim());
            }
            if (this.cookies.containsCookie(this.sfxCookieName)) {
                this.sfxBaseURL = this.cookies.getCookieVal(this.sfxCookieName);
                this.sfxAwareClient = this.sfxBaseURL != null;
                this.sfxID = handle.trim();
                this.suppressSFXRedirect = parameters.containsHandleParameter("nosfx");
            }
        }
        Object typesWanted = null;
        if (paramArr != null && paramArr.length > 0) {
            typesWanted = new byte[paramArr.length][];
            for (int i = 0; i < ((byte[][])typesWanted).length; ++i) {
                typesWanted[i] = Util.encodeString(paramArr[i]);
            }
        }
        String[] indexes = parameters.getHandleParametersByName("index");
        int[] indexesWanted = null;
        if (indexes != null && indexes.length > 0) {
            indexesWanted = new int[indexes.length];
            for (int i = 0; i < indexes.length; ++i) {
                try {
                    indexesWanted[i] = Integer.parseInt(indexes[i]);
                    continue;
                }
                catch (Exception e) {
                    indexesWanted[i] = 0;
                }
            }
        }
        if ((noredirect = parameters.getHandleParametersByName(SUPPRESS_REDIRECT)) != null && noredirect.length > 0) {
            this.suppressRedirect = true;
        }
        if ((authReq = parameters.getHandleParametersByName(AUTH_FLAG)) != null && authReq.length > 0) {
            this.authRequest = true;
        }
        if ((followAli = parameters.getHandleParametersByName(DONT_FOLLOW_ALIASES)) != null && followAli.length > 0) {
            this.followAliases = false;
        }
        if (this.sfxAwareClient && !this.suppressSFXRedirect) {
            this.currentHtmlLogAccessHdl = handle + "|" + this.sfxBaseURL;
            this.currentHtmlLogAccessType = ACCESS_TYPE_SFX;
        } else {
            this.currentHtmlLogAccessHdl = handle;
            this.currentHtmlLogAccessType = ACCESS_TYPE;
        }
        ResolutionRequest req = new ResolutionRequest(Util.encodeString(this.currentHdl), (byte[][])typesWanted, indexesWanted, null);
        req.recursive = true;
        this.redirectSuffix = parameters.getLocalParameterString();
        if (this.redirectSuffix.length() > 0) {
            this.redirectSuffix = "?" + this.redirectSuffix;
        }
        if (this.redirectSuffix.length() == 0 && (urlappend = parameters.getHandleParametersByName(URLAPPEND)).length > 0) {
            this.redirectSuffix = StringUtils.decodeURLIgnorePlus(urlappend[0]);
        }
        this.server.processRequest(req, this.htmlResponder);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final void handleHdlRequest(InputStream in) throws Exception {
        int n = 0;
        int r = in.read();
        if (r != 10 && r != 13) {
            this.envelopeBuf[0] = (byte)r;
            ++n;
        }
        while (n < 20 && (r = in.read(this.envelopeBuf, n, 20 - n)) >= 0) {
            n += r;
        }
        if (n < 20) {
            this.handleResponse(new ErrorResponse(0, 2, MSG_INVALID_MSG_SIZE));
            return;
        }
        Encoder.decodeEnvelope(this.envelopeBuf, this.envelope);
        if (this.envelope.messageLength > 262144 || this.envelope.messageLength < 0) {
            this.handleResponse(new ErrorResponse(0, 2, MSG_INVALID_MSG_SIZE));
            return;
        }
        if (this.messageBuf.length < this.envelope.messageLength) {
            this.messageBuf = new byte[this.envelope.messageLength];
        }
        r = 0;
        for (n = 0; n < this.envelope.messageLength && (r = in.read(this.messageBuf, n, this.envelope.messageLength - n)) >= 0; n += r) {
        }
        if (n < this.envelope.messageLength) {
            throw new HandleException(6, "Expecting " + this.envelope.messageLength + " bytes, " + "only received " + n);
        }
        if (this.envelope.encrypted) {
            if (this.envelope.sessionId <= 0) {
                this.main.logError(75, "Invalid session id. Request message not decrypted.");
                System.err.println("Invalid session id. Request message not decrypted.");
                this.handleResponse(new ErrorResponse(0, 501, Util.encodeString("Invalid session id. Unable to decrypt request message.")));
                return;
            }
            ServerSideSessionInfo sssinfo = null;
            if (!(this.server instanceof HandleServer)) {
                this.main.logError(75, "Session manager not available. Request message not decrypted.");
                System.err.println("Session manager not available. Request message not decrypted.");
                this.handleResponse(new ErrorResponse(0, 501, Util.encodeString("Session manager not available. Unable to decrypt request message.")));
                return;
            }
            sssinfo = ((HandleServer)this.server).getSession(this.envelope.sessionId);
            if (sssinfo == null) {
                this.main.logError(75, "Session information not available. Request message not decrypted.");
                System.err.println("Session information not available. Request message not decrypted.");
                this.handleResponse(new ErrorResponse(0, 501, Util.encodeString("Session manager not available. Unable to decrypt request message.")));
                return;
            }
            try {
                this.messageBuf = AbstractMessage.decryptMessage(this.messageBuf, sssinfo.getSessionKey());
            }
            catch (Exception e) {
                this.main.logError(75, "Exception decrypting request: " + e);
                System.err.println("Exception decrypting request with session key: " + e.getMessage());
                this.handleResponse(new ErrorResponse(0, 501, Util.encodeString("Exception decrypting request with session key " + e)));
                return;
            }
        }
        this.currentHdlRequest = (AbstractRequest)Encoder.decodeMessage(this.messageBuf, 0, this.envelope);
        this.server.processRequest(this.currentHdlRequest, this);
    }

    private final int determineRequestType(String contentType) {
        if (contentType == null) {
            return 1;
        }
        if ((contentType = contentType.toUpperCase()).indexOf("application/x-hdl-message".toUpperCase()) >= 0) {
            return 0;
        }
        return 1;
    }

    private final int determineResponseType(String acceptsValue) {
        if (acceptsValue == null) {
            return 1;
        }
        if ((acceptsValue = acceptsValue.toUpperCase()).indexOf("application/x-hdl-message".toUpperCase()) >= 0) {
            return 0;
        }
        return 1;
    }

    public void handleResponseError(String error) {
        this.main.logError(50, String.valueOf(this.getClass()) + ": Server error: " + error);
    }

    public final void handleResponse(AbstractResponse response) {
        switch (this.responseType) {
            case 0: {
                this.handleHdlResponse(response);
                break;
            }
            default: {
                this.handleHtmlResponse(response);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void handleHtmlResponse(AbstractResponse response) {
        block34: {
            OutputStream ostr;
            BufferedWriter out = null;
            try {
                ostr = this.socket.getOutputStream();
            }
            catch (Exception e) {
                try {
                    this.socket.close();
                }
                catch (IOException ee) {
                }
                Object var8_11 = null;
                if (out != null) {
                    try {
                        out.flush();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                return;
            }
            out = new BufferedWriter(new OutputStreamWriter(ostr, "UTF8"));
            if (this.sfxEnabled && this.sfxAwareClient && !this.suppressSFXRedirect && this.sfxBaseURL != null) {
                this.showHtmlPage = false;
                String[] uri = new String[]{this.sfxBaseURL + '?' + "id=doi:" + URLEncoder.encode(this.sfxID)};
                this.printRedirect(uri, out);
            } else if (response != null && response.opCode == 1 && response.responseCode == 1) {
                HandleValue[] values = ((ResolutionResponse)response).getHandleValues();
                String[] uris = new String[values.length];
                if (!this.suppressRedirect) {
                    for (int i = values.length - 1; values != null && i >= 0; --i) {
                        if (!values[i].hasType(Common.STD_TYPE_URL)) continue;
                        this.showHtmlPage = false;
                        uris[i] = Util.decodeString(values[i].getData()) + this.redirectSuffix;
                    }
                }
                if (this.showHtmlPage) {
                    this.printHtmlResponse(response, out);
                } else {
                    this.printRedirect(uris, out);
                }
            } else {
                this.printHtmlResponse(response, out);
            }
            out.flush();
            long respTime = System.currentTimeMillis() - this.recvTime;
            if (this.logAccesses && response != null) {
                this.main.logAccess(this.currentHtmlLogAccessType, this.socket.getInetAddress(), 1, response.responseCode, this.currentHtmlLogAccessHdl, respTime);
            }
            this.socket.close();
            Object var8_12 = null;
            if (out == null) break block34;
            try {
                out.flush();
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (Exception e2) {}
            break block34;
            {
                catch (IOException e) {
                    this.main.logError(0, String.valueOf(this.getClass()) + ": Exception sending html response: " + e);
                    Object var8_13 = null;
                    if (out == null) break block34;
                    try {
                        out.flush();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (Exception e2) {}
                    break block34;
                }
                catch (Exception e) {
                    this.main.logError(50, String.valueOf(this.getClass()) + ": Exception sending html response: " + e);
                    e.printStackTrace();
                    Object var8_14 = null;
                    if (out == null) break block34;
                    try {
                        out.flush();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_15 = null;
                if (out != null) {
                    try {
                        out.flush();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private final void printRedirect(String[] uris, Writer out) throws IOException {
        out.write("HTTP/1.1 302 Moved Temporarily\n");
        out.write("Content-type: text/html; charset=utf-8\n");
        for (int i = 0; i < uris.length; ++i) {
            if (uris[i] == null) continue;
            out.write("Location: " + uris[i] + "\n");
        }
        out.write("\n<HTML><HEAD><TITLE>Handle Redirect</TITLE></HEAD>");
        out.write("\n<BODY><A HREF=\"" + uris[0] + "\">");
        out.write(uris[0] + "</A></BODY></HTML>");
    }

    private final void printErrorPage(Writer out) throws IOException {
        String title;
        String trace = "";
        if (this.resolutionError == 2) {
            title = "Not Found";
        } else if (this.resolutionError == 1) {
            int index = this.currentHdl.indexOf("/");
            String na = index != -1 ? this.currentHdl.substring(0, index) : this.currentHdl;
            title = "Naming Authority [" + na + "] Not Found";
        } else if (this.resolutionError == 3) {
            title = "Cannot Connect to Server";
        } else {
            title = "System Error";
            if (this.originalException != null) {
                trace = "<p><p>The original error: " + this.originalException;
            }
        }
        int pos = 0;
        int next = 0;
        Enumeration e = this.errorPage.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o == ERROR_TOKEN) {
                out.write(HdlHttpRequestHandler.htmlEscape(title));
                pos = next + 8;
                continue;
            }
            if (o == HANDLE_TOKEN) {
                out.write(HdlHttpRequestHandler.htmlEscape(this.currentHdl));
                pos = next + 9;
                continue;
            }
            if (o == TRACE_TOKEN) {
                out.write(HdlHttpRequestHandler.htmlEscape(trace));
                pos = next + 8;
                continue;
            }
            out.write((String)o);
            pos += next + 2;
        }
        out.flush();
    }

    private static final String htmlEscape(String str) {
        if (str == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer("");
        int sz = str.length();
        boolean idx = false;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '>') {
                sb.append("&gt;");
                continue;
            }
            if (ch == '\"') {
                sb.append("&quot;");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    private final void printHtmlResponse(AbstractResponse resp, Writer out) throws IOException {
        ResolutionResponse rresp;
        out.write("HTTP/1.0 200 OK\n");
        out.write("Content-type: text/html; charset=utf-8\n\n");
        if (resp == null) {
            if (this.resolutionError == 0) {
                out.write(this.queryPage);
            } else {
                this.printErrorPage(out);
            }
            out.flush();
            return;
        }
        if ((!(resp instanceof ErrorResponse) || resp.responseCode != 200) && resp instanceof ErrorResponse) {
            this.resolutionError = resp.responseCode == 100 ? 2 : 100;
            this.printErrorPage(out);
            out.flush();
            return;
        }
        if (resp instanceof ErrorResponse && resp.responseCode == 200) {
            if (this.currentHdl == null) {
                this.resolutionError = 100;
                this.printErrorPage(out);
                out.flush();
                return;
            }
            int pos = 0;
            int next = 0;
            Enumeration e = this.responsePage.elements();
            while (e.hasMoreElements()) {
                Object o = e.nextElement();
                if (o == HANDLE_TOKEN) {
                    out.write(HdlHttpRequestHandler.htmlEscape(this.currentHdl));
                    pos = next + 9;
                    continue;
                }
                if (o == VALUES_TOKEN) {
                    out.write("<tr><td align=CENTER><b>No values found for requested types.</td></tr>");
                    pos = next + 9;
                    continue;
                }
                out.write((String)o);
            }
            out.flush();
            return;
        }
        HandleValue[] values = null;
        try {
            rresp = (ResolutionResponse)resp;
            values = rresp.getHandleValues();
        }
        catch (Exception e) {
            this.originalException = e;
            this.resolutionError = 100;
            this.printErrorPage(out);
            out.flush();
            return;
        }
        int pos = 0;
        int next = 0;
        Enumeration e = this.responsePage.elements();
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            if (o == HANDLE_TOKEN) {
                out.write(HdlHttpRequestHandler.htmlEscape(Util.decodeString(rresp.handle)));
                pos = next + 9;
                continue;
            }
            if (o == VALUES_TOKEN) {
                if (values != null && values.length > 0) {
                    out.write("<tr><td align=CENTER>Index</td><td align=CENTER>Type</td><td align=CENTER>Timestamp</td><td align=CENTER>Data</td></tr>");
                } else {
                    out.write("<tr><td align=CENTER><b>No values found for requested types.</td></tr>");
                }
                for (int i = 0; values != null && i < values.length; ++i) {
                    String dataStr = values[i].getDataAsString();
                    String typeStr = values[i].getTypeAsString();
                    String timeStampStr = values[i].getNicerTimestampAsString();
                    out.write("<tr " + (i % 2 == 0 ? "bgcolor=\"#dddddd\"" : "bgcolor=\"#ffffff\"") + "><td align=CENTER><b>" + values[i].getIndex() + "</b></td>" + "<td align=CENTER><b>" + HdlHttpRequestHandler.htmlEscape(typeStr) + "</b></td>");
                    out.write("<td nowrap>" + HdlHttpRequestHandler.htmlEscape(timeStampStr) + "</td>");
                    if (values[i].hasType(Common.STD_TYPE_URL)) {
                        out.write("<td><a href=\"" + dataStr + "\">" + HdlHttpRequestHandler.htmlEscape(dataStr) + "</a></td>");
                    } else if (values[i].hasType(Common.STD_TYPE_EMAIL)) {
                        out.write("<td><a href=\"mailto:" + dataStr + "\">" + HdlHttpRequestHandler.htmlEscape(dataStr) + "</a></td>");
                    } else {
                        out.write("<td>" + HdlHttpRequestHandler.htmlEscape(dataStr) + "</td>");
                    }
                    out.write("</tr>\n");
                }
                pos = next + 9;
                continue;
            }
            out.write((String)o);
        }
        out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void handleHdlResponse(AbstractResponse response) {
        block21: {
            OutputStream out;
            block20: {
                out = null;
                byte[] msg = response.getEncodedMessage();
                boolean encrypted = false;
                if (response.encrypt && response.sessionId > 0) {
                    ServerSideSessionInfo sssinfo = null;
                    if (this.server instanceof HandleServer) {
                        sssinfo = ((HandleServer)this.server).getSession(response.sessionId);
                        if (sssinfo != null && sssinfo.lastRequestId > 0) {
                            try {
                                msg = AbstractMessage.encryptMessage(msg, sssinfo.getSessionKey());
                                encrypted = true;
                            }
                            catch (Exception e) {
                                this.main.logError(50, "Exception encrypting response: " + e);
                                System.err.println("Exception encrypting message with session key: " + e.getMessage());
                                encrypted = false;
                            }
                        }
                    } else {
                        this.main.logError(50, "Session manager not available. Message not encrypted.");
                        System.err.println("Session manager not available. Message not encrypted.");
                        encrypted = false;
                    }
                }
                this.envelope.encrypted = encrypted;
                this.envelope.messageLength = msg.length;
                this.envelope.messageId = 0;
                this.envelope.sessionId = response.sessionId;
                Encoder.encodeEnvelope(this.envelope, this.envelopeBuf);
                out = new BufferedOutputStream(this.socket.getOutputStream(), 512);
                out.write(Util.encodeString("HTTP/1.0 200 OK\r\n"));
                out.write(Util.encodeString("Content-length: " + (this.envelopeBuf.length + msg.length) + "\r\n"));
                out.write(Util.encodeString("Content-type: application/x-hdl-message\r\n"));
                out.write(Util.encodeString("\r\n"));
                out.write(this.envelopeBuf);
                out.write(msg);
                long respTime = System.currentTimeMillis() - this.recvTime;
                if (this.logAccesses && this.currentHdlRequest != null) {
                    this.main.logAccess(ACCESS_TYPE, this.socket.getInetAddress(), this.currentHdlRequest.opCode, response != null ? response.responseCode : 2, Util.decodeString(this.currentHdlRequest.handle), respTime);
                }
                if (!response.streaming) break block20;
                response.streamResponse(out);
            }
            Object var8_9 = null;
            if (out == null) break block21;
            try {
                out.flush();
            }
            catch (Exception e2) {
                // empty catch block
            }
            try {
                out.close();
            }
            catch (Exception e2) {}
            break block21;
            {
                catch (Exception e) {
                    this.main.logError(50, String.valueOf(this.getClass()) + ": Exception sending response: " + e);
                    e.printStackTrace(System.err);
                    Object var8_10 = null;
                    if (out == null) break block21;
                    try {
                        out.flush();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var8_11 = null;
                if (out != null) {
                    try {
                        out.flush();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                    try {
                        out.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private class HtmlResponder
    implements ResponseMessageCallback {
        ResolutionRequest originalRequest = null;

        private HtmlResponder() {
        }

        public void handleResponse(AbstractResponse message) {
            try {
                if (HdlHttpRequestHandler.this.followAliases && message != null && message.opCode == 1 && message.responseCode == 1) {
                    HandleValue[] values = ((ResolutionResponse)message).getHandleValues();
                    for (int i = 0; i < values.length; ++i) {
                        if (!values[i].hasType(Common.STD_TYPE_HSALIAS)) continue;
                        if (--HdlHttpRequestHandler.this.aliasCount <= 0) {
                            HdlHttpRequestHandler.this.main.logError(50, "Alias count exceeded for " + HdlHttpRequestHandler.this.currentHdl);
                        }
                        ResolutionRequest req = new ResolutionRequest(values[i].getData(), null, null, null);
                        req.takeValuesFrom(message);
                        req.recursive = true;
                        HdlHttpRequestHandler.this.server.processRequest(req, this);
                        return;
                    }
                }
            }
            catch (Exception e) {
                HdlHttpRequestHandler.this.main.logError(50, "Error following alias: " + e);
            }
            HdlHttpRequestHandler.this.handler.handleResponse(message);
        }
    }
}

