/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import java.net.DatagramPacket;
import java.net.InetAddress;
import net.handle.hdllib.MessageEnvelope;
import net.handle.server.HdlUdpRequestHandler;

class HdlUdpPendingRequest {
    String idString;
    boolean[] gotPacket = null;
    HdlUdpRequestHandler handler = null;
    byte[] message;

    static final String getRequestId(InetAddress addr, int requestId) {
        return String.valueOf(requestId) + '@' + addr.getHostAddress();
    }

    HdlUdpPendingRequest(String idString, MessageEnvelope firstEnv, DatagramPacket firstPkt, HdlUdpRequestHandler handler) {
        this.idString = idString;
        this.handler = handler;
        int numPackets = firstEnv.messageLength / 492;
        if (firstEnv.messageLength % 492 != 0) {
            ++numPackets;
        }
        this.gotPacket = new boolean[numPackets];
        this.addPacket(firstEnv, firstPkt);
    }

    boolean isComplete() {
        for (int i = 0; i < this.gotPacket.length; ++i) {
            if (this.gotPacket[i]) continue;
            return false;
        }
        return true;
    }

    void addPacket(MessageEnvelope env, DatagramPacket pkt) {
        this.gotPacket[env.messageId] = true;
        if (this.message == null) {
            this.message = new byte[env.messageLength];
        }
        System.arraycopy(pkt.getData(), 20, this.message, env.messageId * 492, pkt.getLength() - 20);
    }

    byte[] getMessage() {
        return this.message;
    }
}

