/*
 * Decompiled with CFR 0.152.
 */
package net.handle.server;

import net.handle.server.AbstractServer;
import net.handle.server.DnsUdpInterface;
import net.handle.server.HdlHttpInterface;
import net.handle.server.HdlTcpInterface;
import net.handle.server.HdlUdpInterface;
import net.handle.server.Main;
import net.handle.util.StreamTable;

public abstract class NetworkInterface
implements Runnable {
    private boolean keepRunning = true;
    protected AbstractServer server;
    protected boolean needsGC = false;
    protected Main main;
    public static final String INTFC_HDLTCP = "hdl_tcp";
    public static final String INTFC_HDLTCP_CONFIG = "hdl_tcp_config";
    public static final String INTFC_HDLUDP = "hdl_udp";
    public static final String INTFC_HDLUDP_CONFIG = "hdl_udp_config";
    public static final String INTFC_HDLHTTP = "hdl_http";
    public static final String INTFC_HDLHTTP_CONFIG = "hdl_http_config";
    public static final String INTFC_DNS = "dns";
    public static final String INTFC_DNS_CONFIG = "dns_config";

    public NetworkInterface(Main main) {
        this.main = main;
    }

    public static NetworkInterface getInstance(Main main, String frontEndLabel, StreamTable configTable) throws Exception {
        if (frontEndLabel.equals(INTFC_HDLUDP)) {
            return new HdlUdpInterface(main, (StreamTable)configTable.get(INTFC_HDLUDP_CONFIG));
        }
        if (frontEndLabel.equals(INTFC_HDLTCP)) {
            return new HdlTcpInterface(main, (StreamTable)configTable.get(INTFC_HDLTCP_CONFIG));
        }
        if (frontEndLabel.equals(INTFC_HDLHTTP)) {
            return new HdlHttpInterface(main, (StreamTable)configTable.get(INTFC_HDLHTTP_CONFIG));
        }
        if (frontEndLabel.equals(INTFC_DNS)) {
            return new DnsUdpInterface(main, (StreamTable)configTable.get(INTFC_DNS_CONFIG));
        }
        throw new Exception("Invalid interface type: \"" + frontEndLabel + "\"");
    }

    final boolean needsGC() {
        return this.needsGC;
    }

    final void resetGC() {
        this.needsGC = false;
    }

    public final void run() {
        while (this.keepRunning) {
            try {
                this.serveRequests();
            }
            catch (Throwable t) {
                this.main.logError(100, "Error establishing interface: " + t);
                t.printStackTrace();
            }
            try {
                if (!this.keepRunning) continue;
                Thread.currentThread();
                Thread.sleep(300000L);
            }
            catch (Throwable t) {
                this.main.logError(100, "Error sleeping!: " + t);
            }
        }
    }

    public final void stopRunning() {
        this.keepRunning = false;
        this.stopService();
    }

    protected abstract void stopService();

    public abstract void serveRequests();

    public void finalize() {
        this.stopRunning();
    }
}

