/*
 * Decompiled with CFR 0.152.
 */
package net.handle.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.net.URLEncoder;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import net.handle.util.TemplateException;

public class Template {
    public static int getMatchingBraceLocation(String str) {
        Stack<String> stack = new Stack<String>();
        int leftIdx = -1;
        int rightIdx = -1;
        int totIdx = 0;
        String str2 = str;
        while (true) {
            leftIdx = str2.indexOf("{{");
            rightIdx = str2.indexOf("}}");
            if (rightIdx < 0) {
                return -1;
            }
            if (leftIdx >= 0 && leftIdx < rightIdx) {
                stack.push("{{");
                str2 = str2.substring(leftIdx + 2, str2.length());
                totIdx += leftIdx + 2;
                continue;
            }
            str2 = str2.substring(rightIdx + 2, str2.length());
            totIdx += rightIdx + 2;
            if (stack.empty()) {
                return totIdx - 2;
            }
            String match = (String)stack.pop();
        }
    }

    public static String subDictIntoFile(String filename, Hashtable dict) throws IOException, TemplateException {
        return Template.subDictIntoFile(new File(filename), dict);
    }

    public static String subDictIntoFile(File file, Hashtable dict) throws IOException, TemplateException {
        BufferedReader in = new BufferedReader(new FileReader(file));
        StringBuffer sb = new StringBuffer();
        char[] ch = new char[256];
        int n = 0;
        while ((n = in.read(ch, 0, ch.length)) >= 0) {
            sb.append(ch, 0, n);
        }
        try {
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return Template.subDictIntoString(sb.toString(), dict);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String subDictIntoStream(InputStream in, Hashtable dict) throws IOException, TemplateException {
        try {
            int r;
            InputStreamReader rdr = new InputStreamReader(in, "UTF8");
            StringWriter sw = new StringWriter();
            char[] ch = new char[1024];
            while ((r = rdr.read(ch, 0, ch.length)) >= 0) {
                sw.write(ch, 0, r);
            }
            String string = Template.subDictIntoString(sw.toString(), dict);
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static String subDictIntoString(String str, Hashtable dict) throws TemplateException {
        String nstr = "";
        String estr = "";
        boolean noMoreTags = false;
        while (true) {
            String key;
            boolean isRepeatingTag = false;
            int begTag = 0;
            int endTag = 0;
            begTag = str.indexOf("{{");
            if (begTag < 0) break;
            endTag = Template.getMatchingBraceLocation(str.substring(begTag + 2, str.length()));
            if ((endTag += begTag + 2) < 0) {
                throw new TemplateException("Unmatched {{.");
            }
            String checkEqualString = str.substring(begTag, endTag);
            int eqIndex = checkEqualString.indexOf("=");
            nstr = str.substring(0, begTag);
            estr = str.substring(endTag + 2, str.length());
            if (eqIndex > 2) {
                key = checkEqualString.substring(2, eqIndex).trim();
                isRepeatingTag = true;
            } else {
                key = str.substring(begTag + 2, endTag).trim();
                isRepeatingTag = false;
            }
            String value = "";
            if (isRepeatingTag) {
                Vector val;
                String restOfTag = checkEqualString.substring(eqIndex + 1);
                try {
                    val = (Vector)dict.get(key);
                }
                catch (ClassCastException e) {
                    throw new TemplateException("Invalid value for key=\"" + key + "\"");
                }
                if (val != null) {
                    for (int i = 0; i < val.size(); ++i) {
                        Hashtable table;
                        try {
                            table = (Hashtable)val.elementAt(i);
                        }
                        catch (ClassCastException e) {
                            throw new TemplateException("Invalid type for element " + i + " of repeating tag");
                        }
                        if (table == null) continue;
                        nstr = nstr + Template.subDictIntoString(restOfTag, table);
                    }
                }
            } else {
                Object obj;
                String format = null;
                int colonKey = key.indexOf("::");
                if (colonKey >= 0) {
                    format = key.substring(colonKey + 2);
                    key = key.substring(0, colonKey);
                }
                if ((obj = dict.get(key)) != null) {
                    nstr = format != null && format.equals("URLEncode") ? nstr + URLEncoder.encode(obj.toString()) : (format != null && format.equals("CGIEscape") ? nstr + Template.cgiEscape(obj.toString()) : (format != null && format.equals("SQLString") ? nstr + Template.sqlEscape(obj.toString()) : (format != null && format.startsWith("?") ? nstr + Template.conditionalInclude(format, obj.toString()) : nstr + obj.toString())));
                }
            }
            str = nstr + estr;
        }
        return str;
    }

    private static String conditionalInclude(String format, String value) {
        if (format == null || value == null || format.length() <= 1) {
            return "";
        }
        int firstColon = (format = format.substring(1)).indexOf(58);
        if (firstColon < 0) {
            return "";
        }
        int secondColon = format.indexOf(58, firstColon + 1);
        String compVal = format.substring(0, firstColon);
        String elseVal = null;
        String ifVal = null;
        if (secondColon < 0) {
            ifVal = format.substring(firstColon + 1);
            elseVal = "";
        } else {
            ifVal = format.substring(firstColon + 1, secondColon);
            elseVal = format.substring(secondColon + 1);
        }
        if (value.equals(compVal)) {
            return ifVal;
        }
        return elseVal;
    }

    public static String cgiEscape(String str) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '<') {
                sb.append("&lt;");
                continue;
            }
            if (ch == '>') {
                sb.append("&gt;");
                continue;
            }
            if (ch == '\"') {
                sb.append("&quot;");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }

    public static String sqlEscape(String str) {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch == '\'') {
                sb.append("''");
                continue;
            }
            if (ch == '\n') {
                sb.append("\\n");
                continue;
            }
            if (ch == '\r') {
                sb.append("\\r");
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

