/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.pluginloader;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Iterator;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import nl.mpi.flap.module.BaseModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginService {
    private static final Logger logger = LoggerFactory.getLogger(PluginService.class);
    private ServiceLoader<BaseModule> serviceLoader;

    public PluginService(URL[] pluginJarUrls) {
        if (logger.isDebugEnabled()) {
            for (URL inputURL : pluginJarUrls) {
                logger.debug("Plugin URL: " + inputURL.toString());
            }
        }
        this.serviceLoader = ServiceLoader.load(BaseModule.class, URLClassLoader.newInstance(pluginJarUrls, this.getClass().getClassLoader()));
    }

    public Iterator<BaseModule> getPlugins() throws ServiceConfigurationError {
        return this.serviceLoader.iterator();
    }
}

