/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.bcarchive.typecheck;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class JpegCheck {
    static final int LEVEL2 = 1;
    static final int LEVEL3 = 2;
    static final int BAD = 4;
    static final int BUFSIZE1 = 32768;
    static final int BUFSIZE2 = 262144;
    static byte[] buf = new byte[262144];
    static final String[] chanNames = new String[]{"?", "Y", "Cb", "Cr", "I", "Q"};
    static final String[] typeNames = new String[]{"baseline", "extended", "progressive", "lossless", "---", "differential", "differential progressive", "differential lossless"};
    static final String[] markerNames = new String[]{"SOF0", "SOF1", "SOF2", "SOF3", "DHT", "SOF5", "SOF6", "SOF7", "JPGA", "SOF9", "SOFA", "SOFB", "SOFC", "SOFD", "SOFE", "SOFF", "RST0", "RST1", "RST2", "RST3", "RST4", "RST5", "RST6", "RST7", "SOI", "EOI", "SOS", "DQT", "DNL", "DRI", "DHP", "EXP", "APP0", "APP1", "APP2", "APP3", "APP4", "APP5", "APP6", "APP7", "APP8", "APP9", "APPA", "APPB", "APPC", "APPD", "APPE", "APPF", "JPG0", "JPG1", "JPG2", "JPG3", "JPG4", "JPG5", "JPG6", "JPG7", "JPG8", "JPG9", "JPGA", "JPGB", "JPGC", "JPGD", "COM", "TEM"};
    boolean verboseMode = false;

    public void setVerbose(boolean v) {
        this.verboseMode = v;
    }

    int readShort(int offset) {
        if (offset + 1 >= 262144 || offset < 0) {
            return -1;
        }
        int n1 = 0xFF & buf[offset + 0];
        int n2 = 0xFF & buf[offset + 1];
        return n2 | n1 << 8;
    }

    int readMarker(int offset) {
        if (this.readByte(offset) != 255) {
            return -1;
        }
        return this.readByte(offset + 1);
    }

    String readString(int pos) {
        int strLen = 0;
        while (this.readByte(pos + strLen) < 128 && this.readByte(pos + strLen) >= 32) {
            ++strLen;
        }
        return new String(buf, pos, strLen);
    }

    int readByte(int offset) {
        if (offset >= 262144 || offset < 0) {
            return -1;
        }
        int n1 = 0xFF & buf[offset + 0];
        return n1;
    }

    public synchronized String checkJpeg(RandomAccessFile jpeg) throws IOException {
        int complex = 0;
        String info = "";
        String verbose = "";
        String resolution = "";
        boolean hadExif = false;
        boolean hadJfif = false;
        boolean lazyWaiting = false;
        int pos = 0;
        int[] markers = new int[64];
        jpeg.seek(0L);
        long longsize = jpeg.length();
        int size = longsize > 262144L ? 262144 : (int)longsize;
        JpegCheck.buf[0] = 0;
        JpegCheck.buf[1] = 0;
        if (size > 32768) {
            jpeg.readFully(buf, 0, 32768);
            lazyWaiting = true;
        } else {
            jpeg.readFully(buf, 0, size);
        }
        if (size < 1) {
            return "bad empty file";
        }
        if (size < 32768 && this.readMarker(size - 2) != 217) {
            complex |= 1;
            verbose = verbose + " [extra data after EOI?]";
        }
        if (this.readMarker(pos) != 216) {
            if (this.readString(0).startsWith("GIF8")) {
                return "bad GIF file, not JPEG";
            }
            return "bad JPEG signature missing";
        }
        pos += 2;
        while (pos + 4 < size) {
            int mark = this.readMarker(pos);
            int len = this.readShort(pos + 2);
            if (mark == 255) {
                ++pos;
                continue;
            }
            if (mark == 0) {
                pos += 2;
                continue;
            }
            if (mark >= 208 && mark <= 215) {
                pos += 2;
                continue;
            }
            if (mark == -1) {
                return "bad scan for marker needed at " + pos;
            }
            if (mark == 1) {
                mark = 255;
            }
            if (mark < 192) {
                return "bad unexpected marker: 0x" + Integer.toHexString(mark) + " at " + pos;
            }
            int n = mark - 192;
            markers[n] = markers[n] + 1;
            if (mark == 218) break;
            switch (mark) {
                case 192: 
                case 193: 
                case 194: 
                case 195: 
                case 197: 
                case 198: 
                case 199: 
                case 201: 
                case 202: 
                case 203: 
                case 205: 
                case 206: 
                case 207: {
                    if (mark > 200) {
                        info = info + " ARITHMETIC CODING " + typeNames[mark - 200];
                        complex |= 4;
                    } else {
                        info = info + " " + typeNames[mark - 192];
                    }
                    if (mark > 192) {
                        complex |= 1;
                    }
                    if (mark == 195) {
                        complex |= 2;
                    }
                    if (mark > 195) {
                        complex |= 2;
                    }
                    resolution = resolution + " " + this.readShort(pos + 7) + "x" + this.readShort(pos + 5);
                    int channels = this.readByte(pos + 9);
                    if (this.readByte(pos + 4) != 8) {
                        info = info + " " + this.readByte(pos + 4) + "*" + channels + "bpp";
                        complex |= 4;
                    } else if (channels == 1) {
                        info = info + " GREY ";
                    } else if (channels == 3) {
                        info = info + " COLOR ";
                    } else if (channels == 4) {
                        info = info + " CMYK ";
                        complex |= 4;
                    } else {
                        info = info + " 8*" + channels + "bpp ";
                        complex |= 4;
                    }
                    StringBuilder subSamp = new StringBuilder();
                    StringBuilder chanInfo = new StringBuilder();
                    for (int i = 0; i < channels; ++i) {
                        int whichChannel = this.readByte(pos + 10 + 3 * i);
                        int subSampling = this.readByte(pos + 11 + 3 * i);
                        int xSubSamp = subSampling >> 4;
                        int ySubSamp = subSampling & 0xF;
                        int quantTable = this.readByte(pos + 12 + 3 * i);
                        if (whichChannel < 0 || whichChannel > 5) {
                            chanInfo.append('(').append(whichChannel).append(')');
                            complex |= 4;
                        } else {
                            chanInfo.append(chanNames[whichChannel]);
                        }
                        subSamp.append(' ').append(xSubSamp);
                        subSamp.append('x').append(ySubSamp);
                        subSamp.append(':').append(quantTable);
                        if (xSubSamp != 1 && xSubSamp != 2) {
                            complex |= 2;
                        }
                        if (ySubSamp != 1 && ySubSamp != 2) {
                            complex |= 2;
                        }
                        if (xSubSamp <= 4 && ySubSamp <= 4 && xSubSamp != 0 && ySubSamp != 0 && quantTable <= 3) continue;
                        complex |= 4;
                    }
                    verbose = verbose + subSamp.toString();
                    info = info + chanInfo.toString();
                    verbose = verbose.replaceFirst("2x2:0 1x1:1 1x1:1", "2:1:1");
                    verbose = verbose.replaceFirst("1x1:0 1x1:1 1x1:1", "1:1:1");
                    break;
                }
                case 196: {
                    break;
                }
                case 200: 
                case 204: {
                    complex |= 4;
                    break;
                }
                case 216: {
                    complex |= 4;
                    break;
                }
                case 217: {
                    complex |= 4;
                    break;
                }
                case 219: {
                    break;
                }
                case 220: {
                    resolution = resolution + ";" + this.readShort(pos + 4);
                    complex |= 2;
                    break;
                }
                case 221: {
                    break;
                }
                case 222: {
                    complex |= 2;
                    break;
                }
                case 223: {
                    complex |= 2;
                    break;
                }
                case 224: {
                    if (this.readByte(pos + 4) != 74 || this.readByte(pos + 5) != 70 || this.readByte(pos + 6) != 73 || this.readByte(pos + 7) != 70 || this.readByte(pos + 8) != 0 || this.readByte(pos + 9) != 1 || this.readByte(pos + 10) > 2 || len < 16) {
                        complex |= 2;
                        verbose = verbose + " [@0=" + this.readString(pos + 4) + "/" + len + "]";
                        break;
                    }
                    int xdpi = this.readShort(pos + 12);
                    int ydpi = this.readShort(pos + 14);
                    int unit = this.readByte(pos + 11);
                    hadJfif = true;
                    info = info + " JFIF";
                    if (xdpi == ydpi) {
                        verbose = unit == 0 ? verbose + " 1:1" : verbose + " " + xdpi + (unit == 1 ? "dpi" : "dots/cm");
                    } else {
                        verbose = unit == 0 ? verbose + " " + xdpi + ":" + ydpi : verbose + " " + xdpi + "x" + ydpi + (unit == 1 ? "dpi" : "dots/cm");
                        complex |= 1;
                    }
                    int xthumb = this.readByte(pos + 16);
                    if (xthumb == 0) break;
                    verbose = verbose + " " + xthumb + "x" + this.readByte(pos + 17) + "_thumb";
                    break;
                }
                case 225: {
                    if (this.readByte(pos + 4) != 69 || this.readByte(pos + 5) != 120 || this.readByte(pos + 6) != 105 || this.readByte(pos + 7) != 102 || this.readByte(pos + 8) != 0 || len < 12) {
                        if (this.readString(pos + 4).equals("http://ns.adobe.com/xap/1.0/")) {
                            verbose = verbose + " XMP";
                            break;
                        }
                        complex |= 2;
                        verbose = verbose + " [@1=" + this.readString(pos + 4) + "/" + len + "]";
                        break;
                    }
                    info = info + " EXIF";
                    hadExif = true;
                    if (this.readMarker(pos + len - 2) != 217) break;
                    verbose = verbose + " JPG_thumb?";
                    break;
                }
                case 226: {
                    String appName = this.readString(pos + 4);
                    if (appName.equals("ICC_PROFILE")) {
                        verbose = verbose + " ICC/" + len + "@" + pos;
                        break;
                    }
                    if (appName.equals("FPXR")) {
                        complex |= 1;
                        verbose = verbose + " [@2=FPXR/" + len + "@" + pos + "]";
                        break;
                    }
                    complex |= 1;
                    verbose = verbose + " [@2" + appName + "/" + len + "@" + pos + "]";
                    break;
                }
                case 238: {
                    String appName = this.readString(pos + 4);
                    if (appName.equals("Adobe") && (len == 14 || len == 33)) {
                        verbose = verbose + " Adobe";
                        break;
                    }
                    complex |= 1;
                    verbose = verbose + " [@14=" + this.readString(pos + 4) + "/" + len + "]";
                    break;
                }
                case 227: 
                case 228: 
                case 229: 
                case 230: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 235: 
                case 236: {
                    complex |= 1;
                    verbose = verbose + " [@" + (mark - 224) + "=" + this.readString(pos + 4) + "/" + len + "@" + pos + "]";
                    break;
                }
                case 237: {
                    complex |= 1;
                    verbose = verbose + " [@13=" + this.readString(pos + 4).replaceFirst("Photoshop", "<PS>");
                    if (this.verboseMode) {
                        verbose = verbose + "/" + len;
                    }
                    verbose = verbose + "]";
                    break;
                }
                case 239: {
                    verbose = verbose + " [@15=" + this.readString(pos + 4) + "/" + len + "]";
                    break;
                }
                case 240: 
                case 253: {
                    complex |= 1;
                    break;
                }
                case 241: 
                case 242: 
                case 243: 
                case 244: 
                case 245: 
                case 246: 
                case 247: 
                case 248: 
                case 250: 
                case 251: 
                case 252: {
                    complex |= 2;
                    break;
                }
                case 254: {
                    String comment = this.readString(pos + 4);
                    if (comment.equals("File written by Adobe Photoshop")) {
                        verbose = verbose + " PS";
                        break;
                    }
                    if (!this.verboseMode) break;
                    verbose = verbose + " [# " + this.readString(pos + 4) + "]";
                    break;
                }
            }
            if (!lazyWaiting || (pos += len + 2) + 1024 <= 32768) continue;
            lazyWaiting = false;
            verbose = verbose + " BIGHEADER";
            jpeg.readFully(buf, 32768, size - 32768);
            if (size >= 262144 || this.readMarker(size - 2) == 217) continue;
            complex |= 1;
            verbose = verbose + " [extra data after EOI?]";
        }
        if (markers[26] == 0) {
            if (pos + 4 >= size) {
                info = info + " file truncated? start of scans missing!";
                complex |= 4;
            } else {
                info = info + " data starts late";
                complex |= 2;
            }
        }
        StringBuilder markerList = new StringBuilder();
        for (int i = 0; i < markers.length; ++i) {
            String mName = markerNames[i];
            if (mName.startsWith("SOF")) {
                mName = mName.substring(3);
            }
            if (mName.equals("SOS") || mName.equals("DRI") || mName.equals("COM") || mName.startsWith("APP")) {
                markers[i] = 0;
            }
            if (mName.equals("DHT")) {
                if (markers[i] == 4 && markers[27] == 2) {
                    markerList.append(" 4+2");
                    markers[i] = 0;
                    markers[27] = 0;
                } else if (markers[i] == 1 && markers[27] == 1) {
                    markerList.append(" 1+1");
                    markers[i] = 0;
                    markers[27] = 0;
                }
            }
            if (markers[i] > 1) {
                markerList.append(' ').append(mName).append('*').append(markers[i]);
                continue;
            }
            if (markers[i] != 1) continue;
            markerList.append(' ').append(mName);
        }
        if (resolution.trim().length() < 3) {
            info = info + " resolution unknown!";
            complex |= 4;
        }
        if (!hadExif && !hadJfif) {
            info = info + " neither JFIF nor Exif!";
            complex |= 4;
        }
        info = info + " r: " + resolution.trim();
        info = info + " i: " + verbose.trim();
        info = info + " [" + markerList.toString().trim() + "]";
        if ((complex & 4) != 0) {
            return "bad " + info.trim();
        }
        if ((complex & 2) != 0) {
            return "level3 " + info.trim();
        }
        if ((complex & 1) != 0) {
            return "level2 " + info.trim();
        }
        return "level1 " + info.trim();
    }

    public static void main(String[] args) {
        JpegCheck me = new JpegCheck();
        if (args.length < 1) {
            System.out.println("Give input filename(s) as argument(s)...");
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            RandomAccessFile what = null;
            try {
                what = new RandomAccessFile(args[i], "r");
                String result = me.checkJpeg(what);
                what.close();
                System.out.println("" + result + " file: " + args[i]);
                continue;
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("Could not open input file: " + fnfe);
                continue;
            }
            catch (IOException ioe) {
                System.out.println("Could not check input file: " + args[i]);
                System.out.println("I/O Error: " + ioe);
                ioe.printStackTrace();
                if (what == null) continue;
                try {
                    what.close();
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }
}

