/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.bcarchive.typecheck;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class TiffCheck {
    byte[] buf = new byte[4096];
    static final String[] cSpaces = new String[]{"B", "W", "RGB", "PAL", "MASK", "CMYK", "YCbCr"};
    boolean verbose = false;

    public void setVerbose(boolean v) {
        this.verbose = v;
    }

    long readLong(int offset, boolean mac) {
        if (offset + 3 >= 4096 || offset < 0) {
            return -1L;
        }
        long n1 = 0xFF & this.buf[offset + 0];
        long n2 = 0xFF & this.buf[offset + 1];
        long n3 = 0xFF & this.buf[offset + 2];
        long n4 = 0xFF & this.buf[offset + 3];
        if (mac) {
            return n4 | n3 << 8 | n2 << 16 | n1 << 24;
        }
        return n1 | n2 << 8 | n3 << 16 | n4 << 24;
    }

    int readShort(int offset, boolean mac) {
        if (offset + 1 >= 4096 || offset < 0) {
            return -1;
        }
        int n1 = 0xFF & this.buf[offset + 0];
        int n2 = 0xFF & this.buf[offset + 1];
        if (mac) {
            return n2 | n1 << 8;
        }
        return n1 | n2 << 8;
    }

    int readByte(int offset) {
        if (offset >= 4096 || offset < 0) {
            return -1;
        }
        int n1 = 0xFF & this.buf[offset + 0];
        return n1;
    }

    public synchronized String checkTiff(RandomAccessFile tiff) throws IOException {
        String what = "";
        boolean mac = false;
        int complex = 0;
        int n = 0;
        long pos = 0L;
        long fill = 0L;
        long nextpos = 0L;
        int images = 0;
        int thumbs = 0;
        int pages = 0;
        tiff.seek(0L);
        tiff.readFully(this.buf, 0, 8);
        if (this.buf[0] == 77 && this.buf[1] == 77 && this.buf[2] == 0 && this.buf[3] == 42) {
            what = "Mac";
            complex |= 1;
            mac = true;
        } else {
            if (this.buf[0] != 73 || this.buf[1] != 73 || this.buf[2] != 42 || this.buf[3] != 0) {
                return "bad No TIFF at all";
            }
            what = "Intel";
        }
        nextpos = pos = this.readLong(4, mac);
        while (nextpos != 0L) {
            if (nextpos < 0L || nextpos > tiff.length() - 6L) {
                what = what + " BADSEEK[" + nextpos + "]";
                complex |= 4;
                nextpos = 0L;
                break;
            }
            if (this.verbose) {
                what = what + " @" + nextpos + ":";
            }
            tiff.seek(nextpos);
            pos = nextpos;
            tiff.readFully(this.buf, 0, 6);
            n = this.readShort(0, mac);
            if (n < 0 || 6 + n * 12 > 3071) {
                what = what + " BADTAGCOUNT[" + n + "]";
                complex |= 4;
                nextpos = 0L;
                break;
            }
            if (n != 0) {
                tiff.readFully(this.buf, 6, n * 12);
            }
            nextpos = this.readLong(2 + n * 12, mac);
            fill = tiff.read(this.buf, 6 + n * 12, 3072 - (6 + n * 12));
            fill += (long)(6 + n * 12);
            ++images;
            int needed = 3;
            for (int i = 0; i < n; ++i) {
                int where = 2 + i * 12;
                int tag = this.readShort(where, mac);
                int type = this.readShort(where + 2, mac);
                long count = this.readLong(where + 4, mac);
                long point = 0L;
                long firstValue = 0L;
                if (count < 1L) {
                    what = what + " NULL";
                    complex |= 4;
                }
                if (type == 1 || type == 2 || type == 3 && count > 2L || (type == 4 || type == 7) && count > 1L || type == 5) {
                    point = this.readLong(where + 8, mac);
                    if (point - pos >= (long)where && point - pos < fill) {
                        point -= pos;
                    } else {
                        if (point < 0L || point > tiff.length() - 6L) {
                            what = what + " BADSEEK2[" + point + "]";
                            complex |= 4;
                            pos = 0L;
                            nextpos = 0L;
                            break;
                        }
                        System.err.println("Load: " + point);
                        tiff.seek(point);
                        long size = tiff.length() - point;
                        if (size > 1024L) {
                            size = 1024L;
                        }
                        tiff.readFully(this.buf, 3072, (int)size);
                        point = 3072L;
                    }
                } else {
                    point = where + 8;
                }
                if (point > 0x7FFFEFFFL) {
                    point = 0x7FFFEFFFL;
                }
                switch (type) {
                    case 1: {
                        firstValue = this.readByte((int)point);
                        break;
                    }
                    case 2: {
                        firstValue = -1L;
                        break;
                    }
                    case 3: {
                        firstValue = this.readShort((int)point, mac);
                        break;
                    }
                    case 4: 
                    case 7: {
                        firstValue = this.readLong((int)point, mac);
                        break;
                    }
                    case 5: {
                        firstValue = this.readLong((int)point, mac) / (this.readLong((int)point + 4, mac) | 1L);
                        break;
                    }
                    default: {
                        firstValue = -1L;
                    }
                }
                if (type > 5) {
                    complex |= 1;
                }
                if (type < 1 || type == 6 || type > 16) {
                    what = what + " tag/type[" + tag + "/" + type + "]";
                    complex |= 4;
                }
                block7 : switch (tag) {
                    case 254: {
                        if ((firstValue & 1L) == 1L) {
                            ++thumbs;
                            --images;
                        }
                        if ((firstValue & 2L) == 2L) {
                            ++pages;
                        }
                        if ((firstValue & 0xFFFFFFFFFFFFFF00L) == 0L) break;
                        what = what + " flags[" + firstValue + "]";
                        complex |= 4;
                        break;
                    }
                    case 255: {
                        complex |= 1;
                        what = what + " OLD";
                        if (firstValue == 1L) {
                            ++images;
                            break;
                        }
                        if (firstValue == 2L) {
                            ++thumbs;
                            --images;
                            break;
                        }
                        if (firstValue != 3L) break;
                        ++pages;
                        break;
                    }
                    case 256: {
                        what = what + " r: " + firstValue;
                        --needed;
                        break;
                    }
                    case 257: {
                        what = what + "x" + firstValue;
                        --needed;
                        break;
                    }
                    case 258: {
                        what = what + "/" + firstValue;
                        if (firstValue == 1L || firstValue == 8L) break;
                        complex |= 2;
                        break;
                    }
                    case 259: {
                        switch ((int)firstValue) {
                            case 1: 
                            case 32771: {
                                what = what + " raw";
                                break block7;
                            }
                            case 2: 
                            case 32773: {
                                what = what + " RLE";
                                break block7;
                            }
                            case 3: {
                                what = what + " fax3";
                                complex |= 2;
                                break block7;
                            }
                            case 4: {
                                what = what + " fax4";
                                complex |= 2;
                                break block7;
                            }
                            case 5: {
                                what = what + " LZW";
                                complex |= 1;
                                break block7;
                            }
                            case 6: {
                                what = what + " BADJPEG";
                                complex |= 4;
                                break block7;
                            }
                            case 7: {
                                what = what + " JPEG";
                                complex |= 2;
                                break block7;
                            }
                            case 8: 
                            case 32946: {
                                what = what + " deflate";
                                complex |= 2;
                                break block7;
                            }
                            case 9: 
                            case 10: 
                            case 34661: {
                                what = what + " faxJBIG";
                                complex |= 2;
                                break block7;
                            }
                            case 34712: {
                                what = what + " JPEG2000";
                                complex |= 2;
                                break block7;
                            }
                        }
                        what = what + " pack[" + firstValue + "]";
                        complex |= 4;
                        break;
                    }
                    case 262: {
                        if (firstValue == 4L) {
                            complex |= 1;
                        }
                        if (firstValue == 6L) {
                            complex |= 2;
                        }
                        if (firstValue == 5L || firstValue > 6L) {
                            complex |= 4;
                        }
                        what = firstValue < 7L && firstValue >= 0L ? what + " " + cSpaces[(int)firstValue] : what + " color[" + firstValue + "]";
                        --needed;
                        break;
                    }
                    case 266: {
                        if (firstValue == 1L) break;
                        complex |= 1;
                        break;
                    }
                    case 274: {
                        if (firstValue == 1L) break;
                        complex |= 1;
                        break;
                    }
                    case 277: {
                        if (firstValue > 4L || firstValue < 1L) {
                            what = what + "/" + firstValue + "ch";
                            complex |= 4;
                            break;
                        }
                        if (firstValue != 2L && firstValue != 4L) break;
                        complex |= 1;
                        what = what + "a";
                        break;
                    }
                    case 281: {
                        if (firstValue == 1L || firstValue >= 128L) break;
                        complex |= 1;
                        break;
                    }
                    case 297: {
                        complex |= 1;
                        what = what + "(" + firstValue + ")";
                        break;
                    }
                    case 317: {
                        if (firstValue == 2L) {
                            complex |= 1;
                        }
                        if (firstValue >= 1L && firstValue <= 2L) break;
                        what = what + " pre[" + firstValue + "]";
                        complex |= 4;
                        break;
                    }
                    case 322: 
                    case 323: 
                    case 324: 
                    case 325: {
                        complex |= 1;
                        break;
                    }
                    case 339: {
                        if (firstValue == 2L) {
                            what = what + " signed";
                            complex |= 1;
                            break;
                        }
                        if (firstValue == 3L) {
                            what = what + " float";
                            complex |= 4;
                            break;
                        }
                        if (firstValue == 1L || firstValue == 4L) break;
                        complex |= 4;
                        what = what + " data[" + firstValue + "]";
                        break;
                    }
                    case 343: {
                        what = what + " clip";
                        complex |= 1;
                        break;
                    }
                    case 344: 
                    case 345: {
                        break;
                    }
                    case 346: {
                        complex |= 1;
                        break;
                    }
                }
                if (tag == 262 && firstValue == 4L || tag == 254 && (firstValue & 1L) == 1L || tag == 255 && firstValue == 2L) break;
            }
            if (needed <= 0) continue;
            what = what + " UNDERSPECIFIED";
            complex |= 4;
        }
        if (images == 0 && pages == 0) {
            what = what + " empty";
            complex |= 4;
        }
        if (pages > 1) {
            complex |= 1;
            what = what + " " + pages + " pages";
        }
        if ((complex & 4) != 0) {
            return "bad " + what;
        }
        if ((complex & 2) != 0) {
            return "level3 " + what;
        }
        if ((complex & 1) != 0) {
            return "level2 " + what;
        }
        return "level1 " + what;
    }

    public static void main(String[] args) {
        TiffCheck me = new TiffCheck();
        me.setVerbose(false);
        if (args.length < 1) {
            System.out.println("Give input filename(s) as argument(s)...");
            System.exit(1);
        }
        for (int i = 0; i < args.length; ++i) {
            RandomAccessFile what = null;
            try {
                what = new RandomAccessFile(args[i], "r");
                String result = me.checkTiff(what);
                what.close();
                System.out.println("" + result + " file: " + args[i]);
                continue;
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("Could not open input file: " + fnfe);
                continue;
            }
            catch (IOException ioe) {
                System.out.println("Could not check input file: " + args[i]);
                System.out.println("I/O Error: " + ioe);
                ioe.printStackTrace();
                if (what == null) continue;
                try {
                    what.close();
                    continue;
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
    }
}

