/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import nl.mpi.arbil.ArbilSwingInjector;
import nl.mpi.arbil.ArbilVersion;
import nl.mpi.arbil.data.ArbilDataNodeLoader;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.ui.ArbilTreeController;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.ImageBoxRenderer;
import nl.mpi.arbil.userstorage.ArbilSessionStorage;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.ArbilBugCatcher;
import nl.mpi.arbil.util.ArbilMimeHashQueue;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbilcommons.journal.ArbilJournal;
import nl.mpi.flap.plugin.PluginBugCatcher;

public class ArbilDesktopInjector
extends ArbilSwingInjector {
    private ArbilTreeHelper treeHelper;
    private ArbilMimeHashQueue mimeHashQueue;
    private ArbilWindowManager windowManager;
    private ArbilDataNodeLoader dataNodeLoader;
    private ImageBoxRenderer imageBoxRenderer;
    private ArbilTreeController treeController;

    public synchronized void injectHandlers() {
        this.injectHandlers(new ApplicationVersionManager(new ArbilVersion()));
    }

    public synchronized void injectHandlers(ApplicationVersionManager versionManager) {
        this.injectVersionManager(versionManager);
        ArbilSessionStorage sessionStorage = new ArbilSessionStorage();
        this.injectSessionStorage(sessionStorage);
        BugCatcherManager.setBugCatcher(new ArbilBugCatcher(sessionStorage, versionManager));
        ArbilJournal.setBugCatcher((PluginBugCatcher)BugCatcherManager.getBugCatcher());
        this.windowManager = new ArbilWindowManager();
        this.windowManager.setSessionStorage(sessionStorage);
        this.windowManager.setVersionManager(versionManager);
        this.imageBoxRenderer = new ImageBoxRenderer();
        this.windowManager.setImageBoxRenderer(this.imageBoxRenderer);
        ArbilWindowManager messageDialogHandler = this.windowManager;
        sessionStorage.setMessageDialogHandler(messageDialogHandler);
        this.injectDialogHandler(messageDialogHandler);
        sessionStorage.setWindowManager(this.windowManager);
        this.injectWindowManager(this.windowManager);
        this.mimeHashQueue = new ArbilMimeHashQueue(this.windowManager, sessionStorage);
        this.mimeHashQueue.setMessageDialogHandler(messageDialogHandler);
        this.injectMimeHashQueue(this.mimeHashQueue);
        this.treeHelper = new ArbilTreeHelper(sessionStorage, messageDialogHandler);
        this.windowManager.setTreeHelper(this.treeHelper);
        sessionStorage.setTreeHelper(this.treeHelper);
        this.injectTreeHelper(this.treeHelper);
        this.dataNodeLoader = new ArbilDataNodeLoader(messageDialogHandler, sessionStorage, this.mimeHashQueue, this.treeHelper);
        this.treeHelper.setDataNodeLoader(this.dataNodeLoader);
        this.mimeHashQueue.setDataNodeLoader(this.dataNodeLoader);
        this.windowManager.setDataNodeLoader(this.dataNodeLoader);
        this.injectDataNodeLoader(this.dataNodeLoader);
        this.treeController = new ArbilTreeController(sessionStorage, this.treeHelper, this.windowManager, messageDialogHandler, this.dataNodeLoader);
    }

    public ArbilTreeHelper getTreeHelper() {
        return this.treeHelper;
    }

    public ArbilTreeController getTreeController() {
        return this.treeController;
    }

    public ArbilMimeHashQueue getMimeHashQueue() {
        return this.mimeHashQueue;
    }

    public ArbilWindowManager getWindowManager() {
        return this.windowManager;
    }

    public ArbilDataNodeLoader getDataNodeLoader() {
        return this.dataNodeLoader;
    }

    public ImageBoxRenderer getImageBoxRenderer() {
        return this.imageBoxRenderer;
    }
}

