/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.Authenticator;
import javax.swing.JFrame;
import javax.swing.JSplitPane;
import nl.mpi.arbil.ArbilDesktopInjector;
import nl.mpi.arbil.ArbilIcons;
import nl.mpi.arbil.ArbilVersion;
import nl.mpi.arbil.MacAdapter;
import nl.mpi.arbil.data.ArbilTreeHelper;
import nl.mpi.arbil.ui.ArbilTaskStatusBar;
import nl.mpi.arbil.ui.ArbilTreeController;
import nl.mpi.arbil.ui.ArbilTreePanels;
import nl.mpi.arbil.ui.ArbilWindowManager;
import nl.mpi.arbil.ui.PreviewSplitPanel;
import nl.mpi.arbil.ui.menu.ArbilMenuBar;
import nl.mpi.arbil.util.ApplicationVersionManager;
import nl.mpi.arbil.util.ArbilMimeHashQueue;
import nl.mpi.arbil.util.AuthenticatorStub;
import nl.mpi.arbil.util.BugCatcherManager;

public class ArbilMain
extends JFrame {
    private JSplitPane mainSplitPane;
    private ArbilMenuBar arbilMenuBar;
    private ArbilTaskStatusBar statusBar;
    private final ArbilTreeHelper treeHelper;
    private final ArbilTreeController treeController;
    private final ArbilWindowManager windowManager;
    private final ApplicationVersionManager versionManager;
    private final ArbilMimeHashQueue mimeHashQueue;

    public static void main(String[] args) {
        System.setProperty("sun.swing.enableImprovedDragGesture", "true");
        System.setProperty("apple.awt.graphics.UseQuartz", "true");
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ApplicationVersionManager versionManager = new ApplicationVersionManager(new ArbilVersion());
                try {
                    new ArbilMain(versionManager).run();
                }
                catch (Exception ex) {
                    BugCatcherManager.getBugCatcher().logError(ex);
                }
            }
        });
    }

    public ArbilMain(ApplicationVersionManager versionManager) {
        this.versionManager = versionManager;
        ArbilDesktopInjector injector = new ArbilDesktopInjector();
        injector.injectHandlers(versionManager);
        this.treeHelper = injector.getTreeHelper();
        this.treeController = injector.getTreeController();
        this.windowManager = injector.getWindowManager();
        this.mimeHashQueue = injector.getMimeHashQueue();
    }

    public void run() {
        this.initApplication();
        this.initUI();
        this.checkFirstRun();
    }

    private void initApplication() {
        try {
            Authenticator.setDefault(new AuthenticatorStub(this.windowManager));
        }
        catch (SecurityException sEx) {
            BugCatcherManager.getBugCatcher().logError("Failed to set custom Authenticator. Default authentication dialogs may appear.", sEx);
        }
        this.treeHelper.init();
        this.mimeHashQueue.init();
    }

    private void initUI() {
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ArbilMain.this.arbilMenuBar.performCleanExit();
            }
        });
        this.initComponents();
        this.windowManager.addTaskListener(this.statusBar);
        PreviewSplitPanel previewSplitPanel = PreviewSplitPanel.getInstance();
        this.mainSplitPane.setRightComponent(previewSplitPanel);
        ArbilTreePanels arbilTreePanels = new ArbilTreePanels(this.treeHelper, this.treeController, this.windowManager);
        this.mainSplitPane.setLeftComponent(arbilTreePanels);
        this.arbilMenuBar = new ArbilMenuBar(previewSplitPanel, null);
        this.setJMenuBar(this.arbilMenuBar);
        this.mainSplitPane.setDividerLocation(0.25);
        this.windowManager.loadGuiState(this, this.statusBar);
        this.setTitle(this.versionManager.getApplicationVersion().applicationTitle + " " + this.versionManager.getApplicationVersion().compileDate);
        this.setIconImage(ArbilIcons.getSingleInstance().linorgIcon.getImage());
        this.setVisible(true);
        if (this.arbilMenuBar.checkNewVersionAtStartCheckBoxMenuItem.isSelected()) {
            this.versionManager.checkForUpdate();
        }
        this.initMacHandlers();
    }

    private void initMacHandlers() {
        block3: {
            MacAdapter macAdapter = new MacAdapter(){

                protected boolean performApplicationExit() {
                    return ArbilMain.this.arbilMenuBar.performCleanExit();
                }

                protected void performApplicationAbout() {
                    ArbilMain.this.windowManager.openAboutPage();
                }
            };
            try {
                if (macAdapter.initMacApplicationHandlers()) {
                    this.arbilMenuBar.setMacOsMenu(true);
                }
            }
            catch (MacAdapter.MacAdapterException exception) {
                System.err.println("Could not configure MacOS application handlers");
                if (exception == null) break block3;
                System.err.println(exception);
            }
        }
    }

    private void checkFirstRun() {
        this.windowManager.showSetupWizardIfFirstRun();
        this.windowManager.openIntroductionPage();
    }

    private void initComponents() {
        this.mainSplitPane = new JSplitPane();
        this.statusBar = new ArbilTaskStatusBar();
        this.setDefaultCloseOperation(0);
        this.setTitle("Arbil");
        this.mainSplitPane.setDividerLocation(100);
        this.mainSplitPane.setDividerSize(5);
        this.mainSplitPane.setName("mainSplitPane");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.mainSplitPane, "Center");
        this.getContentPane().add((Component)this.statusBar, "South");
        this.pack();
    }
}

