/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.data;

import java.util.Collections;
import java.util.List;
import nl.mpi.arbil.clarin.profiles.CmdiTemplate;
import nl.mpi.arbil.data.ArbilVocabulary;
import nl.mpi.arbil.data.ArbilVocabularyItem;
import nl.mpi.arbil.data.DocumentationLanguages;
import nl.mpi.arbil.templates.ArbilTemplateManager;
import nl.mpi.arbil.userstorage.SessionStorage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CmdiDocumentationLanguages
extends DocumentationLanguages {
    private final SessionStorage sessionStorage;
    private static final String CMDI_LANGUAGE_VOCABULARY_URL_KEY = "CmdiLanguageVocabularyUrl";
    private static final String CMDI_LANGUAGE_VOCABULARY_PATH_KEY = "CmdiLanguageVocabularyPath";
    private static final String SELECTED_LANGUAGES_KEY = "selectedLanguagesCmdi";
    public static final String CMDI_VOCABULARY_URL = "http://catalog.clarin.eu/ds/ComponentRegistry/rest/registry/components/clarin.eu:cr1:c_1271859438110/xsd";
    public static final String CMDI_VOCABULARY_PATH = ".CMD.Components.ISO639.iso-639-3-code";
    private static String cmdiLanguageVocabularyUrl = null;
    private static String cmdiLanguageVocabularyPath = null;
    private List<ArbilVocabularyItem> languages;
    private List<ArbilVocabularyItem> sortedLanguages;

    public synchronized String getLanguageVocabularyUrl() {
        if (cmdiLanguageVocabularyUrl == null && (cmdiLanguageVocabularyUrl = this.sessionStorage.loadString(CMDI_LANGUAGE_VOCABULARY_URL_KEY)) == null) {
            cmdiLanguageVocabularyUrl = CMDI_VOCABULARY_URL;
            this.sessionStorage.saveString(CMDI_LANGUAGE_VOCABULARY_URL_KEY, cmdiLanguageVocabularyUrl);
        }
        return cmdiLanguageVocabularyUrl;
    }

    public synchronized String getLanguageVocabularyPath() {
        if (cmdiLanguageVocabularyPath == null && (cmdiLanguageVocabularyPath = this.sessionStorage.loadString(CMDI_LANGUAGE_VOCABULARY_PATH_KEY)) == null) {
            cmdiLanguageVocabularyPath = CMDI_VOCABULARY_PATH;
            this.sessionStorage.saveString(CMDI_LANGUAGE_VOCABULARY_PATH_KEY, cmdiLanguageVocabularyPath);
        }
        return cmdiLanguageVocabularyPath;
    }

    public CmdiDocumentationLanguages(SessionStorage sessionStorage) {
        super(SELECTED_LANGUAGES_KEY, sessionStorage);
        this.sessionStorage = sessionStorage;
    }

    @Override
    public synchronized List<ArbilVocabularyItem> getAllLanguages() {
        if (this.languages == null) {
            this.languages = this.getLanguages();
        }
        return this.languages;
    }

    private synchronized List<ArbilVocabularyItem> getLanguages() {
        ArbilVocabulary vocab;
        CmdiTemplate profile = (CmdiTemplate)ArbilTemplateManager.getSingleInstance().getCmdiTemplate(this.getLanguageVocabularyUrl());
        if (profile != null && (vocab = profile.getFieldVocabulary(this.getLanguageVocabularyPath())) != null) {
            return vocab.getVocabularyItems();
        }
        return null;
    }

    @Override
    public synchronized List<ArbilVocabularyItem> getSortedLanguageListSubset() {
        if (this.sortedLanguages == null) {
            this.sortedLanguages = this.getAllLanguages();
            if (this.sortedLanguages != null) {
                Collections.sort(this.sortedLanguages);
            }
        }
        return this.sortedLanguages;
    }
}

