/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.search;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeContainer;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.data.DataNodeLoader;
import nl.mpi.arbil.search.ArbilNodeSearchTerm;
import nl.mpi.arbil.search.RemoteServerSearchTerm;
import nl.mpi.arbil.ui.AbstractArbilTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilSearch {
    private ArrayList<ArbilNode> localSearchNodes = new ArrayList();
    private ArrayList<ArbilNode> remoteSearchNodes = new ArrayList();
    private ArrayList<ArbilNode> foundNodes = new ArrayList();
    private boolean searchStopped = false;
    private int totalSearched;
    private int totalNodesToSearch = -1;
    private AbstractArbilTableModel resultsTableModel;
    private ArbilDataNodeContainer container;
    private Collection<? extends ArbilNode> selectedNodes;
    private Collection<? extends ArbilNodeSearchTerm> nodeSearchTerms;
    private RemoteServerSearchTerm remoteServerSearchTerm;
    private ArbilSearchListener listener;
    private static DataNodeLoader dataNodeLoader;

    public static void setDataNodeLoader(DataNodeLoader dataNodeLoaderInstance) {
        dataNodeLoader = dataNodeLoaderInstance;
    }

    public ArbilSearch(Collection<? extends ArbilNode> selectedNodes, List<? extends ArbilNodeSearchTerm> nodeSearchTerms, RemoteServerSearchTerm remoteServerSearchTerm, AbstractArbilTableModel resultsTableModel) {
        this(selectedNodes, nodeSearchTerms, remoteServerSearchTerm, resultsTableModel, null, null);
    }

    public ArbilSearch(Collection<? extends ArbilNode> selectedNodes, List<? extends ArbilNodeSearchTerm> nodeSearchTerms, RemoteServerSearchTerm remoteServerSearchTerm, AbstractArbilTableModel resultsTableModel, ArbilDataNodeContainer container, ArbilSearchListener listener) {
        this.remoteServerSearchTerm = remoteServerSearchTerm;
        this.selectedNodes = selectedNodes;
        this.nodeSearchTerms = nodeSearchTerms;
        this.resultsTableModel = resultsTableModel;
        this.container = container;
        this.listener = listener;
    }

    public void stopSearch() {
        this.searchStopped = true;
    }

    public boolean isSearchStopped() {
        return this.searchStopped;
    }

    public void splitLocalRemote() {
        for (ArbilNode arbilNode : this.selectedNodes) {
            if (arbilNode.isLocal()) {
                this.localSearchNodes.add(arbilNode);
                continue;
            }
            this.remoteSearchNodes.add(arbilNode);
        }
    }

    public void searchLocalNodes() {
        this.totalSearched = 0;
        while (this.localSearchNodes.size() > 0 && !this.searchStopped) {
            ArbilNode currentElement = this.localSearchNodes.remove(0);
            if (currentElement instanceof ArbilNode) {
                this.searchLocalNode(currentElement);
            }
            if (this.listener == null) continue;
            this.listener.searchProgress((Object)currentElement);
        }
    }

    public void fetchRemoteSearchResults() {
        if (this.remoteServerSearchTerm != null) {
            for (URI serverFoundUrl : this.remoteServerSearchTerm.getServerSearchResults(this.remoteSearchNodes.toArray(new ArbilDataNode[0]))) {
                System.out.println("remote node found: " + serverFoundUrl);
                this.localSearchNodes.add(dataNodeLoader.getArbilDataNode(null, serverFoundUrl));
            }
        }
    }

    public ArrayList<ArbilNode> getFoundNodes() {
        return this.foundNodes;
    }

    public void clearResults() {
        this.foundNodes.clear();
    }

    public int getTotalSearched() {
        return this.totalSearched;
    }

    public int getTotalNodesToSearch() {
        return this.totalNodesToSearch;
    }

    public void setTotalNodesToSearch(int totalNodesToSearch) {
        this.totalNodesToSearch = totalNodesToSearch;
    }

    private int searchLocalNode(ArbilNode currentNode) {
        ArbilDataNode dataNode = null;
        if (currentNode instanceof ArbilDataNode) {
            dataNode = (ArbilDataNode)currentNode;
        }
        if (!(dataNode == null || currentNode.isChildNode() || !currentNode.isLoading() && currentNode.isDataLoaded())) {
            System.out.println("searching: " + dataNode.getUrlString());
            if (dataNode.isMetaDataNode() || dataNode.isLocal()) {
                System.out.println("still loading so putting back into the list: " + (Object)((Object)currentNode));
                if (!dataNode.fileNotFound) {
                    if (this.container != null) {
                        dataNode.registerContainer(this.container);
                    }
                    this.localSearchNodes.add(currentNode);
                }
            } else {
                System.out.println("skipping unloaded remote resource: " + (Object)((Object)currentNode));
            }
        } else {
            System.out.println("searching: " + (Object)((Object)currentNode));
            if (currentNode.isLocal() || !currentNode.isCorpus()) {
                for (ArbilNode currentChildNode : currentNode.getChildArray()) {
                    System.out.println("adding to search list: " + (Object)((Object)currentChildNode));
                    if (this.container != null) {
                        currentChildNode.registerContainer(this.container);
                    }
                    this.localSearchNodes.add(currentChildNode);
                }
            }
            if (dataNode != null) {
                this.searchLocalDataNode(dataNode);
            }
        }
        return this.totalSearched;
    }

    private void searchLocalDataNode(ArbilDataNode dataNode) {
        boolean nodePassedFilter = true;
        for (ArbilNodeSearchTerm arbilNodeSearchTerm : this.nodeSearchTerms) {
            boolean termPassedFilter = true;
            if (arbilNodeSearchTerm.getNodeType().equals("Corpus")) {
                termPassedFilter = dataNode.isCorpus();
            } else if (arbilNodeSearchTerm.getNodeType().equals("Session")) {
                termPassedFilter = dataNode.isSession();
            } else if (arbilNodeSearchTerm.getNodeType().equals("Catalogue")) {
                termPassedFilter = dataNode.isCatalogue();
            } else if (!arbilNodeSearchTerm.getNodeType().equals("All")) {
                termPassedFilter = dataNode.getUrlString().matches(".*" + arbilNodeSearchTerm.getNodeType() + "\\(\\d*?\\)$");
            }
            if (termPassedFilter) {
                if (null != arbilNodeSearchTerm.getSearchFieldName() && arbilNodeSearchTerm.getSearchFieldName().length() > 0) {
                    termPassedFilter = dataNode.containsFieldValue(arbilNodeSearchTerm.getSearchFieldName(), arbilNodeSearchTerm.getSearchString());
                } else if (null != arbilNodeSearchTerm.getSearchString() && arbilNodeSearchTerm.getSearchString().length() > 0) {
                    termPassedFilter = dataNode.containsFieldValue(arbilNodeSearchTerm.getSearchString());
                }
            }
            boolean bl = termPassedFilter = arbilNodeSearchTerm.isNotEqual() != termPassedFilter;
            if (!arbilNodeSearchTerm.isBooleanAnd() && nodePassedFilter) break;
            if (arbilNodeSearchTerm.isBooleanAnd()) {
                nodePassedFilter = nodePassedFilter && termPassedFilter;
                continue;
            }
            nodePassedFilter = nodePassedFilter || termPassedFilter;
        }
        ++this.totalSearched;
        if (nodePassedFilter) {
            this.foundNodes.add(dataNode);
            this.resultsTableModel.addSingleArbilDataNode(dataNode);
        } else if (this.container != null) {
            dataNode.removeContainer(this.container);
        }
        if (this.totalNodesToSearch < this.totalSearched + this.localSearchNodes.size()) {
            this.totalNodesToSearch = this.totalSearched + this.localSearchNodes.size();
        }
    }

    public static interface ArbilSearchListener {
        public void searchProgress(Object var1);
    }
}

