/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import nl.mpi.arbil.ui.TypeAheadComboBoxEditor;
import nl.mpi.arbil.userstorage.SessionStorage;
import nl.mpi.arbil.util.BugCatcherManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilNodeSearchColumnComboBox
extends JComboBox {
    private List<String> options;
    private TypeAheadComboBoxEditor typeAheadEditor;
    private static final String[] defaultOptions = new String[]{"Name", "Title", "Description", "Genre", "Subject", "Task"};
    private static SessionStorage sessionStorage;

    public static void setSessionStorage(SessionStorage sessionStorageInstance) {
        sessionStorage = sessionStorageInstance;
    }

    public ArbilNodeSearchColumnComboBox() {
        this("", "");
    }

    public ArbilNodeSearchColumnComboBox(String initialValue, String originalValue) {
        try {
            String[] optionsArray = sessionStorage.loadStringArray("searchFieldOptions");
            if (optionsArray != null) {
                this.options = new ArrayList<String>(Arrays.asList(optionsArray));
            }
        }
        catch (IOException ex) {
            BugCatcherManager.getBugCatcher().logError(ex);
        }
        if (this.options == null) {
            this.options = new ArrayList<String>(Arrays.asList(defaultOptions));
        }
        for (String option : this.options) {
            this.addItem(option);
        }
        this.typeAheadEditor = new ArbilNodeSearchColumnComboBoxEditor(initialValue, originalValue);
        this.setEditor(this.typeAheadEditor);
    }

    public synchronized void addOption(String option) {
        if (!this.options.contains(option)) {
            this.options.add(option);
            this.addItem(option);
        }
    }

    public static synchronized void addOptions(Collection<String> options) {
        try {
            String[] optionsArray = sessionStorage.loadStringArray("searchFieldOptions");
            List<String> existingOptions = optionsArray != null ? Arrays.asList(optionsArray) : new ArrayList<String>(Arrays.asList(defaultOptions));
            ArrayList<String> newOptions = new ArrayList<String>(existingOptions);
            for (String option : options) {
                if (option == null || option.length() <= 0 || existingOptions.contains(option)) continue;
                newOptions.add(option);
            }
            sessionStorage.saveStringArray("searchFieldOptions", newOptions.toArray(new String[0]));
        }
        catch (IOException ex) {
            BugCatcherManager.getBugCatcher().logError("Could not save search options", ex);
        }
    }

    public static synchronized void removeOptions(Collection<String> options) {
        try {
            String[] optionsArray = sessionStorage.loadStringArray("searchFieldOptions");
            List<String> existingOptions = optionsArray != null ? Arrays.asList(optionsArray) : new ArrayList<String>(Arrays.asList(defaultOptions));
            ArrayList<String> newOptions = new ArrayList<String>(existingOptions);
            for (String option : options) {
                if (option == null || !existingOptions.contains(option)) continue;
                newOptions.remove(option);
            }
            sessionStorage.saveStringArray("searchFieldOptions", newOptions.toArray(new String[0]));
        }
        catch (IOException ex) {
            BugCatcherManager.getBugCatcher().logError("Could not save search options", ex);
        }
    }

    public String getText() {
        return this.typeAheadEditor.getCurrentValue();
    }

    public void setText(String text) {
        this.typeAheadEditor.setItem(text);
    }

    public JTextField getTextField() {
        return this.typeAheadEditor.getTextField();
    }

    private class ArbilNodeSearchColumnComboBoxEditor
    extends TypeAheadComboBoxEditor {
        public ArbilNodeSearchColumnComboBoxEditor(String value, String originalValue) {
            super(new JTextField(value), value, originalValue, ArbilNodeSearchColumnComboBox.this);
            this.init();
        }

        protected String getItemAt(int index) {
            return (String)ArbilNodeSearchColumnComboBox.this.options.get(index);
        }

        protected int getItemsCount() {
            return ArbilNodeSearchColumnComboBox.this.options.size();
        }

        protected boolean isList() {
            return false;
        }

        protected boolean isOpen() {
            return true;
        }

        protected boolean isItemsDeletable() {
            return true;
        }

        protected synchronized boolean deleteItem(Object item) {
            if (item instanceof String && ArbilNodeSearchColumnComboBox.this.options.remove((String)item)) {
                ArbilNodeSearchColumnComboBox.removeOptions(Collections.singleton((String)item));
                ArbilNodeSearchColumnComboBox.this.removeItem(item);
                return true;
            }
            return false;
        }
    }
}

