/*
 * Decompiled with CFR 0.152.
 */
package nl.mpi.arbil.ui;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreePath;
import nl.mpi.arbil.data.ArbilDataNode;
import nl.mpi.arbil.data.ArbilDataNodeContainer;
import nl.mpi.arbil.data.ArbilNode;
import nl.mpi.arbil.ui.ArbilTable;
import nl.mpi.arbil.ui.ArbilTableModel;
import nl.mpi.arbil.ui.ArbilTreeController;
import nl.mpi.arbil.ui.ArbilTreeRenderer;
import nl.mpi.arbil.ui.JListToolTip;
import nl.mpi.arbil.ui.PreviewSplitPanel;
import nl.mpi.arbil.ui.menu.TreeContextMenu;
import nl.mpi.arbil.util.ArbilActionBuffer;
import nl.mpi.arbil.util.BugCatcherManager;
import nl.mpi.arbil.util.MessageDialogHandler;
import nl.mpi.arbil.util.TreeHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArbilTree
extends JTree
implements ArbilDataNodeContainer,
ClipboardOwner {
    protected ArbilTable customPreviewTable = null;
    private boolean clearSelectionOnFocusLost = false;
    private final TreeHelper treeHelper;
    private final ArbilTreeController treeController;
    private final MessageDialogHandler dialogHandler;
    protected final Object sortRunnerLock = new Object();
    private final ArbilActionBuffer sortRunner = new ArbilActionBuffer("ArbilTree sort thread", 100, 150, this.sortRunnerLock){

        protected void executeAction() {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        ArbilTree.this.sortDescendentNodes((DefaultMutableTreeNode)ArbilTree.this.getModel().getRoot());
                    }
                });
            }
            catch (InterruptedException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
            }
            catch (InvocationTargetException exception) {
                BugCatcherManager.getBugCatcher().logError(exception);
            }
        }
    };
    private JListToolTip listToolTip = new JListToolTip();

    public void setCustomPreviewTable(ArbilTable customPreviewTable) {
        this.customPreviewTable = customPreviewTable;
    }

    public void setClearSelectionOnFocusLost(boolean clearSelectionOnFocusLost) {
        this.clearSelectionOnFocusLost = clearSelectionOnFocusLost;
    }

    public ArbilTree(ArbilTreeController treeController, TreeHelper treeHelper, MessageDialogHandler dialogHandler) {
        this.treeController = treeController;
        this.treeHelper = treeHelper;
        this.dialogHandler = dialogHandler;
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                ArbilTree.this.treeMousePressedReleased(evt);
                ArbilTree.this.putSelectionIntoPreviewTable();
            }

            public void mouseReleased(MouseEvent evt) {
                ArbilTree.this.treeMousePressedReleased(evt);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent evt) {
                ArbilTree.this.treeKeyTyped(evt);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                if (evt.getModifiers() == 0 && evt.getButton() == 1) {
                    JComponent c = (JComponent)evt.getSource();
                    TransferHandler th = c.getTransferHandler();
                    th.exportAsDrag(c, evt, 1);
                }
            }
        });
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent evt) {
                if (evt.getPath() != null) {
                    ArbilTree.this.requestResort();
                }
            }

            public void treeCollapsed(TreeExpansionEvent evt) {
            }
        });
        this.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillCollapse(TreeExpansionEvent evt) throws ExpandVetoException {
                if (evt.getPath().getPathCount() == 1) {
                    System.out.println("root node cannot be collapsed");
                    throw new ExpandVetoException(evt, "root node cannot be collapsed");
                }
            }

            public void treeWillExpand(TreeExpansionEvent evt) throws ExpandVetoException {
            }
        });
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent evt) {
                ArbilTree.this.putSelectionIntoPreviewTable();
            }
        });
        this.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (ArbilTree.this.clearSelectionOnFocusLost) {
                    ArbilTree.this.clearSelection();
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new ArbilTreeRenderer());
        ((DefaultTreeModel)this.treeModel).setAsksAllowsChildren(true);
    }

    protected void putSelectionIntoPreviewTable() {
        ArbilTable targetPreviewTable = this.customPreviewTable;
        if (targetPreviewTable == null && PreviewSplitPanel.isPreviewTableShown() && PreviewSplitPanel.getInstance().getPreviewTable() != null) {
            targetPreviewTable = PreviewSplitPanel.getInstance().getPreviewTable();
        }
        if (targetPreviewTable != null) {
            TableCellEditor currentCellEditor = targetPreviewTable.getCellEditor();
            if (currentCellEditor != null) {
                currentCellEditor.stopCellEditing();
            }
            ArbilDataNode leadSelectionDataNode = this.getLeadSelectionDataNode();
            ArbilTableModel arbilTableModel = targetPreviewTable.getArbilTableModel();
            if (arbilTableModel.getArbilDataNodeCount() != 1 || !arbilTableModel.containsArbilDataNode(leadSelectionDataNode)) {
                arbilTableModel.removeAllArbilDataNodeRows();
                arbilTableModel.addSingleArbilDataNode(leadSelectionDataNode);
            }
        }
    }

    private void treeMousePressedReleased(MouseEvent evt) {
        TreePath clickedNodePath = ((JTree)evt.getSource()).getPathForLocation(evt.getX(), evt.getY());
        boolean clickedPathIsSelected = ((JTree)evt.getSource()).isPathSelected(clickedNodePath);
        if (evt.isPopupTrigger()) {
            if (!(evt.isShiftDown() || evt.isControlDown() || clickedPathIsSelected)) {
                ((JTree)evt.getSource()).clearSelection();
                ((JTree)evt.getSource()).addSelectionPath(clickedNodePath);
            }
            new TreeContextMenu(this, this.treeController, this.treeHelper, this.dialogHandler).show(evt.getX(), evt.getY());
        }
    }

    private void treeKeyTyped(KeyEvent evt) {
        if (evt.getKeyChar() == '\n') {
            this.treeController.openSelectedNodesInTable((ArbilTree)evt.getSource());
        }
        if (evt.getKeyChar() == '\u007f') {
            this.treeHelper.deleteNodes((JTree)evt.getSource());
        }
        if (evt.getKeyCode() == 525) {
            Rectangle selectionBounds = ((JTree)evt.getSource()).getRowBounds(((JTree)evt.getSource()).getLeadSelectionRow());
            new TreeContextMenu(this, this.treeController, this.treeHelper, this.dialogHandler).show(selectionBounds.x, selectionBounds.y);
        }
    }

    @Override
    public JToolTip createToolTip() {
        this.listToolTip.updateList();
        return this.listToolTip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getRowHeight() {
        Graphics g = this.getGraphics();
        if (g != null) {
            try {
                int requiredHeight;
                FontMetrics fontMetrics = g.getFontMetrics();
                int n = requiredHeight = fontMetrics.getHeight();
                return n;
            }
            catch (Exception exception) {
            }
            finally {
                g.dispose();
            }
        }
        return super.getRowHeight();
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        String tip = null;
        Point p = event.getPoint();
        if (this.getRowForLocation(event.getX(), event.getY()) == -1) {
            this.listToolTip.setTartgetObject(null);
        } else {
            TreePath curPath = this.getPathForLocation(event.getX(), event.getY());
            Object targetObject = ((DefaultMutableTreeNode)curPath.getLastPathComponent()).getUserObject();
            if (targetObject instanceof ArbilDataNode) {
                this.listToolTip.setTartgetObject(targetObject);
                tip = ((ArbilDataNode)targetObject).getUrlString();
            } else {
                this.listToolTip.setTartgetObject(null);
            }
        }
        return tip;
    }

    public ArbilNode[] getAllSelectedNodes() {
        return this.getSelectedNodesOfType(ArbilNode.class).toArray(new ArbilNode[0]);
    }

    public ArbilDataNode[] getSelectedNodes() {
        return this.getSelectedNodesOfType(ArbilDataNode.class).toArray(new ArbilDataNode[0]);
    }

    public <T> ArrayList<T> getSelectedNodesOfType(Class<T> type) {
        ArrayList<Object> selectedNodes = new ArrayList<Object>();
        for (int selectedCount = 0; selectedCount < this.getSelectionCount(); ++selectedCount) {
            DefaultMutableTreeNode parentNode = (DefaultMutableTreeNode)this.getSelectionPaths()[selectedCount].getLastPathComponent();
            if (!type.isAssignableFrom(parentNode.getUserObject().getClass())) continue;
            Object currentTreeObject = parentNode.getUserObject();
            selectedNodes.add(currentTreeObject);
        }
        return selectedNodes;
    }

    public ArbilNode getLeadSelectionNode() {
        DefaultMutableTreeNode selectedTreeNode = null;
        ArbilNode returnObject = null;
        TreePath currentNodePath = this.getSelectionPath();
        if (currentNodePath != null) {
            selectedTreeNode = (DefaultMutableTreeNode)currentNodePath.getLastPathComponent();
        }
        if (selectedTreeNode != null && selectedTreeNode.getUserObject() instanceof ArbilNode) {
            returnObject = (ArbilNode)((Object)selectedTreeNode.getUserObject());
        }
        return returnObject;
    }

    public ArbilDataNode getLeadSelectionDataNode() {
        ArbilNode returnObject = this.getLeadSelectionNode();
        if (returnObject != null && returnObject instanceof ArbilDataNode) {
            return (ArbilDataNode)returnObject;
        }
        return null;
    }

    public void copyNodeUrlToClipboard(ArbilDataNode[] selectedNodes) {
        if (selectedNodes != null) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            String copiedNodeUrls = null;
            for (ArbilDataNode currentNode : selectedNodes) {
                if (currentNode == null) continue;
                copiedNodeUrls = copiedNodeUrls == null ? "" : copiedNodeUrls.concat("\n");
                try {
                    if (currentNode.hasResource()) {
                        copiedNodeUrls = copiedNodeUrls.concat(URLDecoder.decode(currentNode.getFullResourceURI().toString(), "UTF-8"));
                        continue;
                    }
                    copiedNodeUrls = copiedNodeUrls.concat(URLDecoder.decode(currentNode.getURI().toString(), "UTF-8"));
                }
                catch (UnsupportedEncodingException murle) {
                    BugCatcherManager.getBugCatcher().logError(murle);
                }
            }
            StringSelection stringSelection = new StringSelection(copiedNodeUrls);
            clipboard.setContents(stringSelection, this);
            System.out.println("copied: \n" + copiedNodeUrls);
        }
    }

    private void sortDescendentNodes(DefaultMutableTreeNode currentNode) {
        ArbilNode currentDataNode;
        boolean isExpanded = true;
        ArbilNode[] childDataNodeArray = new ArbilNode[]{};
        if (currentNode.getUserObject() instanceof ArbilNode && (currentDataNode = (ArbilNode)((Object)currentNode.getUserObject())) != null) {
            childDataNodeArray = currentDataNode.getChildArray();
            isExpanded = this.isExpanded(new TreePath(currentNode.getPath()));
            if (isExpanded && currentDataNode instanceof ArbilDataNode && !currentDataNode.isLoading() && !currentDataNode.isDataLoaded()) {
                ((ArbilDataNode)currentDataNode).loadFullArbilDom();
            }
        }
        Arrays.sort((Object[])childDataNodeArray);
        DefaultTreeModel thisTreeModel = (DefaultTreeModel)this.treeModel;
        if (!isExpanded) {
            currentNode.setAllowsChildren(childDataNodeArray.length > 0);
            thisTreeModel.nodeChanged(currentNode);
        } else {
            int childIndex;
            if (childDataNodeArray.length > 0) {
                currentNode.setAllowsChildren(true);
                thisTreeModel.nodeChanged(currentNode);
            }
            for (childIndex = 0; childIndex < childDataNodeArray.length; ++childIndex) {
                ArbilNode currentDataNode2 = childDataNodeArray[childIndex];
                for (int modelChildIndex = 0; modelChildIndex < thisTreeModel.getChildCount(currentNode); ++modelChildIndex) {
                    if (!((DefaultMutableTreeNode)thisTreeModel.getChild(currentNode, modelChildIndex)).getUserObject().equals((Object)currentDataNode2)) continue;
                    if (childIndex != modelChildIndex) {
                        DefaultMutableTreeNode shiftedNode = (DefaultMutableTreeNode)thisTreeModel.getChild(currentNode, modelChildIndex);
                        thisTreeModel.removeNodeFromParent(shiftedNode);
                        thisTreeModel.insertNodeInto(shiftedNode, currentNode, childIndex);
                        break;
                    }
                    thisTreeModel.nodeChanged((DefaultMutableTreeNode)thisTreeModel.getChild(currentNode, modelChildIndex));
                    break;
                }
                if (childIndex < thisTreeModel.getChildCount(currentNode) && ((DefaultMutableTreeNode)thisTreeModel.getChild(currentNode, childIndex)).getUserObject().equals((Object)currentDataNode2)) continue;
                currentDataNode2.registerContainer(this);
                DefaultMutableTreeNode addableNode = new DefaultMutableTreeNode((Object)currentDataNode2);
                thisTreeModel.insertNodeInto(addableNode, currentNode, childIndex);
                this.nodeAdded(addableNode, currentDataNode2);
            }
            for (childIndex = thisTreeModel.getChildCount(currentNode) - 1; childIndex >= childDataNodeArray.length; --childIndex) {
                DefaultMutableTreeNode toRemove = (DefaultMutableTreeNode)thisTreeModel.getChild(currentNode, childIndex);
                thisTreeModel.removeNodeFromParent(toRemove);
                this.nodeRemoved(toRemove);
            }
            for (childIndex = 0; childIndex < thisTreeModel.getChildCount(currentNode); ++childIndex) {
                this.sortDescendentNodes((DefaultMutableTreeNode)thisTreeModel.getChild(currentNode, childIndex));
            }
        }
    }

    protected void nodeAdded(DefaultMutableTreeNode addableNode, ArbilNode addedDataNode) {
    }

    protected void nodeRemoved(DefaultMutableTreeNode toRemove) {
    }

    public void requestResort() {
        this.sortRunner.requestActionAndNotify();
    }

    @Override
    public boolean isFullyLoadedNodeRequired() {
        return false;
    }

    @Override
    public void dataNodeRemoved(ArbilNode dataNode) {
        this.requestResort();
    }

    @Override
    public void dataNodeIconCleared(ArbilNode dataNode) {
        this.requestResort();
    }

    @Override
    public void dataNodeChildAdded(ArbilNode destination, ArbilNode newNode) {
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
        System.out.println("lost clipboard ownership");
    }
}

